/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.resourcemanager;

import java.util.List;
import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.Section;
import org.xmind.gef.EditDomain;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.CategorizedGalleryViewer;
import org.xmind.ui.gallery.FramePart;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.gallery.IDecorationContext;
import org.xmind.ui.gallery.ILabelDecorator;
import org.xmind.ui.resources.ColorUtils;

public abstract class ResourceManagerViewer
extends CategorizedGalleryViewer {
    private static final int DEFAULT_FRAME_HEIGHT = 100;
    private static final int DEFAULT_FRAME_WIDTH = 200;
    public static final int DEFAULT_FLOATING_TEXT_EDITOR_WIDTH_EXPAND = 10;
    private ResourceManager resourceManager;

    public void createControl(Composite container) {
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)container);
    }

    protected void configureNestedViewer(GalleryViewer viewer, Object category) {
        super.configureNestedViewer(viewer, category);
        this.initNestedGalleryViewer(viewer);
    }

    protected void initNestedGalleryViewer(GalleryViewer galleryViewerer) {
        EditDomain editDomain = new EditDomain();
        editDomain.installTool("select tool", (ITool)new ResourceCategorizedSelectTool());
        galleryViewerer.setEditDomain(editDomain);
        Properties properties = galleryViewerer.getProperties();
        properties.set("org.xmind.ui.gallery.titlePlacement", (Object)GalleryViewer.TITLE_BOTTOM);
        properties.set("org.xmind.ui.gallery.hideTitle", false);
        properties.set("org.xmind.ui.gallery.singleClickToOpen", (Object)Boolean.FALSE);
        properties.set("org.xmind.ui.gallery.solidFrames", true);
        properties.set("org.xmind.ui.gallery.flatFrames", true);
        properties.set("constrained", true);
        properties.set("org.xmind.ui.gallery.customDecorateContentPane", true);
    }

    protected void initProperties() {
        Properties properties = this.getProperties();
        properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.wrap", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(200, 100));
        properties.set("org.xmind.ui.gallery.titlePlacement", (Object)GalleryViewer.TITLE_BOTTOM);
        properties.set("org.xmind.ui.gallery.singleClickToOpen", (Object)Boolean.FALSE);
        properties.set("org.xmind.ui.gallery.solidFrames", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.flatFrames", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.hideTitle", (Object)Boolean.FALSE);
        properties.set("constrained", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout().align(1, 1));
    }

    protected void configureSection(Section section, Object category) {
        super.configureSection(section, category);
    }

    protected void createSectionTextClient(Section section, String text, final Object category) {
        Label label = new Label((Composite)section, 0);
        label.setText(text);
        label.setForeground((Color)this.resourceManager.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#0082F9")));
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ResourceManagerViewer.this.handleClickSectionTextClient(category);
            }
        });
        label.setCursor(new Cursor((Device)Display.getCurrent(), 21));
        section.setTextClient((Control)label);
    }

    protected void handleClickSectionTextClient(Object category) {
    }

    protected ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    protected org.eclipse.swt.widgets.Layout createFormLayout() {
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = -3;
        layout.marginHeight = 0;
        return layout;
    }

    protected class CategorizedLabelProvider
    extends LabelProvider
    implements ILabelDecorator {
        protected CategorizedLabelProvider() {
        }

        public IFigure decorateFigure(IFigure figure, Object element, IDecorationContext context) {
            Object themeContentFigure;
            List children = figure.getChildren();
            boolean needInitFigureContent = children.isEmpty();
            if (needInitFigureContent) {
                themeContentFigure = new SizeableImageFigure(this.getImage(element));
                figure.add((IFigure)themeContentFigure);
                if (context != null) {
                    figure.setLayoutManager((LayoutManager)new Layout(context));
                    boolean imageConstrained = Boolean.TRUE.equals(context.getProperty("constrained", (Object)false));
                    boolean imageStretched = Boolean.TRUE.equals(context.getProperty("stretched", (Object)false));
                    themeContentFigure.setConstrained(imageConstrained);
                    themeContentFigure.setStretched(imageStretched);
                }
            }
            if ((children = figure.getChildren()).size() == 1 && (themeContentFigure = children.get(0)) instanceof SizeableImageFigure) {
                themeContentFigure.setImage(this.getImage(element));
            }
            return figure;
        }
    }

    protected static class Layout
    extends AbstractHintLayout {
        private IDecorationContext properties;

        public Layout(IDecorationContext properties) {
            this.properties = properties;
        }

        public void layout(IFigure container) {
            Rectangle area = container.getClientArea();
            for (Object child : container.getChildren()) {
                IFigure figure = (IFigure)child;
                Dimension childSize = figure.getPreferredSize(-1, -1);
                int childWidth = Math.min(area.width, childSize.width);
                int childHeight = Math.min(area.height, childSize.height);
                figure.setBounds(new Rectangle(area.x, area.y, childWidth, childHeight));
            }
        }

        protected Dimension calculatePreferredSize(IFigure figure, int wHint, int hHint) {
            if (wHint > -1) {
                wHint = Math.max(0, wHint - figure.getInsets().getWidth());
            }
            if (hHint > -1) {
                hHint = Math.max(0, hHint - figure.getInsets().getHeight());
            }
            Insets insets = figure.getInsets();
            Dimension contentSize = (Dimension)this.properties.getProperty("org.xmind.ui.gallery.frameContentSize", null);
            if (contentSize != null) {
                return new Dimension(contentSize.width + insets.getWidth(), contentSize.height + insets.getHeight());
            }
            Dimension d = new Dimension();
            List children = figure.getChildren();
            int i = 0;
            while (i < children.size()) {
                IFigure child = (IFigure)children.get(i);
                if (!this.isObservingVisibility() || child.isVisible()) {
                    d.union(child.getPreferredSize(wHint, hHint));
                }
                ++i;
            }
            d.expand(figure.getInsets().getWidth(), figure.getInsets().getHeight());
            d.union(this.getBorderPreferredSize(figure));
            return d;
        }
    }

    protected class ResourceCategorizedSelectTool
    extends GallerySelectTool {
        protected ResourceCategorizedSelectTool() {
        }

        protected boolean handleMouseDown(org.xmind.gef.event.MouseEvent me) {
            FramePart targetFrame = this.findFrame(me.target);
            if (targetFrame != null && targetFrame.getFigure().isSelected()) {
                return super.handleMouseDown(me);
            }
            return this.handleSelectionOnMouseDown(me);
        }

        private FramePart findFrame(IPart part) {
            while (part != null) {
                if (part instanceof FramePart) {
                    return (FramePart)part;
                }
                part = part.getParent();
            }
            return null;
        }
    }
}

