/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.xmind.core.Core;
import org.xmind.core.IFileEntry;
import org.xmind.core.IImage;
import org.xmind.core.IManifest;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.IWorkbook;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.draw2d.IOriginBased;
import org.xmind.gef.event.DragDropEvent;
import org.xmind.gef.event.KeyEvent;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.service.IBendPointsFeedback;
import org.xmind.gef.service.IFeedback;
import org.xmind.gef.service.IRevealService;
import org.xmind.gef.service.IRevealServiceListener;
import org.xmind.gef.service.IViewerService;
import org.xmind.gef.service.RevealEvent;
import org.xmind.gef.service.ZoomingAndPanningRevealService;
import org.xmind.gef.tool.AbstractTool;
import org.xmind.gef.tool.IDragDropHandler;
import org.xmind.gef.tool.ISourceTool;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.tool.SelectTool;
import org.xmind.ui.branch.IBranchDoubleClickSupport;
import org.xmind.ui.branch.IBranchMoveSupport;
import org.xmind.ui.commands.DeleteMarkerCommand;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.actions.ReplaceMarkerAction;
import org.xmind.ui.internal.actions.ViewerAction;
import org.xmind.ui.internal.mindmap.BoundaryPart;
import org.xmind.ui.internal.mindmap.IconTipPart;
import org.xmind.ui.internal.mindmap.InfoItemIconPart;
import org.xmind.ui.internal.protocols.FilePathParser;
import org.xmind.ui.internal.protocols.FileProtocol;
import org.xmind.ui.internal.tools.QuickOpenHelper;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IBranchRangePart;
import org.xmind.ui.mindmap.IDrillDownTraceService;
import org.xmind.ui.mindmap.IIconTipPart;
import org.xmind.ui.mindmap.IImagePart;
import org.xmind.ui.mindmap.IInfoItemPart;
import org.xmind.ui.mindmap.ILabelPart;
import org.xmind.ui.mindmap.ILegendItemPart;
import org.xmind.ui.mindmap.ILegendPart;
import org.xmind.ui.mindmap.IMarkerPart;
import org.xmind.ui.mindmap.INumberingPart;
import org.xmind.ui.mindmap.IPlusMinusPart;
import org.xmind.ui.mindmap.IRelationshipPart;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMap;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.Logger;
import org.xmind.ui.util.MindMapUtils;
import org.xmind.ui.viewers.SWTUtils;

public class MindMapSelectTool
extends SelectTool {
    private IBranchPart movingSourceBranch = null;

    public MindMapSelectTool() {
        this.setContextId("org.xmind.ui.context.mindmap.edit");
    }

    public String getType() {
        return "select tool";
    }

    public boolean handleMouseDown(MouseEvent me) {
        if (me.target instanceof IPlusMinusPart) {
            if (me.target.getParent() instanceof IBranchPart) {
                IBranchPart branch = (IBranchPart)me.target.getParent();
                this.handleMouseDownOnPlusMinus(me, branch);
                return true;
            }
        } else if (me.target instanceof IconTipPart && !me.leftOrRight && this.handleMouseDownOnIconTip(me)) {
            return true;
        }
        return super.handleMouseDown(me);
    }

    private boolean handleMouseDownOnIconTip(MouseEvent me) {
        IconTipPart iconTip = (IconTipPart)me.target;
        if (iconTip.getPopupMenu() == null) {
            this.getStatus().setStatus(64, true);
            this.getStatus().setStatus(256, !me.leftOrRight);
            this.selectSingle((IPart)iconTip.getTopicPart());
            return true;
        }
        return false;
    }

    protected void handleMouseDownOnPlusMinus(MouseEvent me, IBranchPart branch) {
        this.getStatus().setStatus(64, true);
        this.getStatus().setStatus(256, !me.leftOrRight);
        ITopicPart topic = branch.getTopicPart();
        if (topic != null) {
            this.selectSingle((IPart)topic);
        }
        this.sendFoldedRequest(branch);
        me.consume();
    }

    protected void sendFoldedRequest(IBranchPart branch) {
        String reqType = branch.getTopic().isFolded() ? "extend" : "collapse";
        Request request = new Request(reqType);
        request.setViewer((IViewer)this.getTargetViewer());
        request.setPrimaryTarget((IPart)branch);
        request.setParameter("withAnimation", (Object)Boolean.TRUE);
        this.getDomain().handleRequest(request);
    }

    public boolean handleMouseUp(MouseEvent me) {
        if (me.target instanceof IconTipPart) {
            if (me.leftOrRight) {
                this.handleMouseUpOnIconTip(me);
                return true;
            }
        } else if (me.target instanceof IMarkerPart) {
            if (me.leftOrRight) {
                this.showMarkerMenu((IMarkerPart)me.target);
                return true;
            }
        } else if (me.target instanceof InfoItemIconPart && me.leftOrRight) {
            this.handleMouseUpOnInforItem(me);
            return true;
        }
        return super.handleMouseUp(me);
    }

    private void handleMouseUpOnInforItem(MouseEvent me) {
        this.getStatus().setStatus(2048, false);
        this.getStatus().setStatus(64, false);
        InfoItemIconPart inforItem = (InfoItemIconPart)me.target;
        this.selectSingle((IPart)inforItem.getTopicPart());
        final IAction action = inforItem.getAction();
        if (action != null) {
            this.setToSelectOnMouseUp(null);
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                        public void run() throws Exception {
                            action.run();
                        }
                    });
                }
            });
        }
    }

    protected void handleMouseUpOnIconTip(MouseEvent me) {
        this.getStatus().setStatus(2048, false);
        this.getStatus().setStatus(64, false);
        IconTipPart iconTip = (IconTipPart)me.target;
        this.selectSingle((IPart)iconTip.getTopicPart());
        final IAction action = iconTip.getAction();
        if (action != null) {
            this.setToSelectOnMouseUp(null);
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                        public void run() throws Exception {
                            action.run();
                        }
                    });
                }
            });
        }
    }

    protected boolean handleMouseDoubleClick(MouseEvent me) {
        if (me.leftOrRight && (me.target == null || me.target == this.getTargetViewer().getRootPart() || me.target instanceof ISheetPart)) {
            IBranchPart branch = this.findBranch((IPart)this.getTargetViewer().getRootPart(), me.cursorLocation);
            if (branch == null || !this.handleDoubleClickOnBranch(branch, me.cursorLocation)) {
                this.handleCreateFloatingTopicRequest(me.cursorLocation);
            }
            me.consume();
            return true;
        }
        return super.handleMouseDoubleClick(me);
    }

    private IBranchPart findBranch(IPart part, Point pos) {
        if (!part.getStatus().isActive()) {
            return null;
        }
        if (part instanceof IBranchPart) {
            IBranchPart branch = (IBranchPart)part;
            if (branch.getFigure().isVisible() && branch.getFigure().containsPoint(pos)) {
                if (branch.canSearchChild()) {
                    IBranchPart b;
                    for (IBranchPart sub : branch.getSubBranches()) {
                        b = this.findBranch((IPart)sub, pos);
                        if (b == null) continue;
                        return b;
                    }
                    for (IBranchPart sub : branch.getCalloutBranches()) {
                        b = this.findBranch((IPart)sub, pos);
                        if (b == null) continue;
                        return b;
                    }
                    for (IBranchPart sub : branch.getSummaryBranches()) {
                        b = this.findBranch((IPart)sub, pos);
                        if (b == null) continue;
                        return b;
                    }
                }
                return branch;
            }
        } else if (!(part instanceof IGraphicalPart) || ((IGraphicalPart)part).getFigure().isVisible()) {
            for (IPart child : part.getChildren()) {
                IBranchPart branch = this.findBranch(child, pos);
                if (branch == null) continue;
                return branch;
            }
        }
        return null;
    }

    private boolean handleDoubleClickOnBranch(IBranchPart branch, Point pos) {
        do {
            IStructure structure;
            if (!((structure = branch.getBranchPolicy().getStructure(branch)) instanceof IBranchDoubleClickSupport) || !((IBranchDoubleClickSupport)structure).handleDoubleClick(branch, pos)) continue;
            return true;
        } while ((branch = branch.getParentBranch()) != null);
        return false;
    }

    protected boolean handleKeyDown(KeyEvent ke) {
        boolean handled = super.handleKeyDown(ke);
        if (!handled) {
            int keyCode = ke.keyCode;
            int stateMask = ke.getState();
            Request navScrollRequest = this.createNavScrollRequest(stateMask, keyCode);
            if (navScrollRequest != null) {
                return this.handleNavScroll(navScrollRequest);
            }
            IPart p = this.getTargetViewer().getFocusedPart();
            if (p != null && SWTUtils.matchKey((int)stateMask, (int)keyCode, (int)0, (int)32) && this.handleQuickOpen(p)) {
                return true;
            }
            if (SWTUtils.matchKey((int)stateMask, (int)keyCode, (int)0, (int)27) && this.hideQuickOpen()) {
                return true;
            }
            if (p != null && p.hasRole("editable role") && MindMapUtils.isTopicTextChar(ke.character)) {
                int ignoreCount = this.getTargetViewer().getProperties().getInteger("org.xmind.ui.ignoreKeyDown", 0);
                if (ignoreCount > 0) {
                    this.getTargetViewer().getProperties().set("org.xmind.ui.ignoreKeyDown", ignoreCount - 1);
                } else {
                    Request req = new Request("edit");
                    req.setDomain(this.getDomain());
                    req.setViewer((IViewer)this.getTargetViewer());
                    this.fillTargets(req, (IViewer)this.getTargetViewer(), false);
                    if (req.hasTargets()) {
                        ITool activeTool;
                        this.startEditing(p, req);
                        if (ke.character != ' ' && (activeTool = this.getDomain().getActiveTool()) != this) {
                            activeTool.keyDown(ke, (IViewer)this.getTargetViewer());
                        }
                        return true;
                    }
                }
            }
        }
        return handled;
    }

    protected boolean hideQuickOpen() {
        if (QuickOpenHelper.getInstance().isOpen()) {
            QuickOpenHelper.getInstance().hide();
            return true;
        }
        return false;
    }

    protected boolean handleQuickOpen(IPart part) {
        if (QuickOpenHelper.getInstance().canShow()) {
            if (QuickOpenHelper.getInstance().isOpen()) {
                QuickOpenHelper.getInstance().hide();
                return true;
            }
            String filepath = this.getQuickOpenFilePaths(part);
            if (filepath != null) {
                QuickOpenHelper.getInstance().show(filepath);
                return true;
            }
        }
        return false;
    }

    private String getQuickOpenFilePaths(IPart p) {
        ITopic topic;
        String imagePath;
        if (p instanceof ITopicPart) {
            String path;
            ITopic topic2 = ((ITopicPart)p).getTopic();
            String uri = topic2.getHyperlink();
            if (uri != null && (path = this.uriToFilePath(topic2, uri)) != null) {
                return path;
            }
        } else if (p instanceof IImagePart && (imagePath = this.getImagePath(topic = ((IImagePart)p).getTopic())) != null) {
            return imagePath;
        }
        return null;
    }

    protected String uriToFilePath(ITopic topic, String uri) {
        if (HyperlinkUtils.isInternalURL((String)uri)) {
            return null;
        }
        if (HyperlinkUtils.isAttachmentURL((String)uri)) {
            return this.getAttachmentAbsolutePath(topic, uri);
        }
        String path = FilePathParser.toPath(uri);
        if (path == null) {
            return null;
        }
        return FileProtocol.getAbsolutePath(topic, path);
    }

    private String getImagePath(ITopic topic) {
        IImage image = topic.getImage();
        if (image == null) {
            return null;
        }
        String uri = image.getSource();
        if (uri == null) {
            return null;
        }
        return this.uriToFilePath(topic, uri);
    }

    protected String getAttachmentAbsolutePath(ITopic topic, String uri) {
        String path = HyperlinkUtils.toAttachmentPath((String)uri);
        if (path == null) {
            return null;
        }
        IWorkbook workbook = topic.getOwnedWorkbook();
        if (workbook == null) {
            return null;
        }
        String hiberLoc = Core.getWorkspace().getAbsolutePath(".temp-attachments/quickOpen");
        if (hiberLoc == null) {
            return null;
        }
        File hiberDir = new File(hiberLoc);
        if (hiberDir.exists()) {
            hiberDir.delete();
        }
        File attFile = new File(hiberLoc, path);
        FileUtils.ensureFileParent((File)attFile);
        IManifest manifest = workbook.getManifest();
        IFileEntry fileEntry = manifest.getFileEntry(path);
        try {
            InputStream is = fileEntry.openInputStream();
            FileOutputStream os = new FileOutputStream(attFile.getAbsolutePath());
            FileUtils.transfer((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            Logger.log(e, "Failed to transfer attachment to temp-attachments dir.");
            return null;
        }
        if (!attFile.exists()) {
            return null;
        }
        return attFile.getAbsolutePath();
    }

    protected boolean handleMouseDrag(MouseDragEvent me) {
        this.movingSourceBranch = null;
        return super.handleMouseDrag(me);
    }

    protected boolean canMove(IPart host, MouseDragEvent me) {
        IBranchPart branch;
        boolean canMove = super.canMove(host, me);
        if (!canMove && (branch = this.findBranch(host, me.startingLocation)) != null) {
            return this.canMoveInBranch(branch, me);
        }
        return canMove;
    }

    private boolean canMoveInBranch(IBranchPart branch, MouseDragEvent me) {
        do {
            IStructure structure;
            if (!((structure = branch.getBranchPolicy().getStructure(branch)) instanceof IBranchMoveSupport)) continue;
            boolean canMove = ((IBranchMoveSupport)structure).canMove(branch, me);
            if (canMove) {
                this.movingSourceBranch = branch;
            }
            return canMove;
        } while ((branch = branch.getParentBranch()) != null);
        return false;
    }

    protected String getMoveTool(IPart source, MouseDragEvent me) {
        if (this.movingSourceBranch != null) {
            return ((IBranchMoveSupport)this.movingSourceBranch.getBranchPolicy().getStructure(this.movingSourceBranch)).getMoveTool(this.movingSourceBranch, me);
        }
        if (source instanceof ITopicPart) {
            return "org.xmind.ui.tool.moveTopic";
        }
        if (source instanceof IRelationshipPart) {
            return "org.xmind.ui.tool.moveRelationship";
        }
        if (source instanceof IBranchRangePart) {
            return "org.xmind.ui.tool.resizeRange";
        }
        if (source instanceof IMarkerPart) {
            return "org.xmind.ui.tool.moveMarker";
        }
        if (source instanceof IImagePart) {
            int orientation;
            IImagePart imagePart = (IImagePart)source;
            Object feedback = imagePart.getAdapter(IFeedback.class);
            if (feedback instanceof IBendPointsFeedback && (orientation = ((IBendPointsFeedback)feedback).getOrientation(me.startingLocation)) == 0) {
                return "org.xmind.ui.tool.moveImage";
            }
            return "org.xmind.ui.tool.resizeImage";
        }
        if (source instanceof ILegendPart || source instanceof ILegendItemPart) {
            return "org.xmind.ui.tool.moveLegend";
        }
        return super.getMoveTool(source, me);
    }

    protected void changeToMoveTool(String moveToolType, ITool moveTool, IPart dragSource, MouseDragEvent me) {
        if ("move tool".equals(moveToolType)) {
            if (!this.canMove(dragSource, me)) {
                return;
            }
            if (!dragSource.getStatus().isSelected()) {
                this.selectSingle(dragSource);
            }
            this.getTargetViewer().setFocused((Object)dragSource);
        }
        if (this.movingSourceBranch != null) {
            super.changeToMoveTool(moveToolType, moveTool, (IPart)this.movingSourceBranch, me);
        } else {
            super.changeToMoveTool(moveToolType, moveTool, dragSource, me);
        }
        this.movingSourceBranch = null;
    }

    protected List<IPart> getSequenceParts(IPart start, IPart end) {
        return MindMapUtils.getSequenceTopics(start, end);
    }

    protected Request fillTargets(Request request, IViewer viewer, boolean includeRootPartIfEmpty) {
        return super.fillTargets(request, viewer, includeRootPartIfEmpty).setParameter("withAnimation", (Object)Boolean.TRUE);
    }

    protected void handleNonTargetedRequest(Request request) {
        IViewer viewer = request.getTargetViewer();
        if (viewer != null) {
            String requestType = request.getType();
            if ("create_floating".equals(requestType)) {
                this.handleCreateFloatingTopic(request, viewer);
                return;
            }
            if ("select_brothers".equals(requestType)) {
                this.handleSelectBrothers(request);
                return;
            }
            if ("select_children".equals(requestType)) {
                this.handleSelectChildren(request);
                return;
            }
            if ("select_central".equals(requestType)) {
                this.handleSelectCentral(request);
                return;
            }
            if ("extend_all".equals(requestType) || "collapse_all".equals(requestType)) {
                request = this.createExtendOrCollapseAllRequest(request, viewer);
            } else {
                if ("select_central".equals(requestType)) {
                    this.handleSelectCentral(viewer);
                    return;
                }
                if ("modify_hyperlink".equals(requestType)) {
                    request = this.createModifyHyperlinkRequest(request, viewer);
                } else if ("add_attachment".equals(requestType)) {
                    request = this.createAddAttachmentRequest(request, viewer);
                } else {
                    if ("create_relationship".equals(requestType)) {
                        this.handleCreateRelationship(requestType, viewer);
                        return;
                    }
                    if ("create_boundary".equals(requestType)) {
                        request = this.createCreateBoundaryRequest(request, viewer);
                    } else if ("create_summary".equals(requestType)) {
                        request = this.createCreateSummaryRequest(request, viewer);
                    } else {
                        if ("edit_label".equals(requestType)) {
                            this.handleEditLabelRequest(request, viewer);
                            return;
                        }
                        if ("drill_down".equals(requestType)) {
                            this.handleDrillDown(viewer);
                            return;
                        }
                        if ("drill_up".equals(requestType)) {
                            this.handleDrillUp(viewer);
                            return;
                        }
                        if ("traverse".equals(requestType)) {
                            this.handleTraverse(viewer);
                            return;
                        }
                    }
                }
            }
            if (request == null) {
                return;
            }
            if (request.hasTargets()) {
                this.handleTargetedRequest(request);
                return;
            }
        }
        super.handleNonTargetedRequest(request);
    }

    private void handleCreateFloatingTopic(Request request, IViewer viewer) {
        this.changeActiveTool("org.xmind.ui.tool.createFloatingTopic");
        this.getDomain().handleRequest(request);
    }

    private void handleSelectCentral(Request request) {
        IViewer viewer = request.getTargetViewer();
        if (viewer == null) {
            return;
        }
        ITopicPart centralTopic = (ITopicPart)viewer.getAdapter(ITopicPart.class);
        if (centralTopic == null) {
            return;
        }
        this.select(Arrays.asList(centralTopic), (IPart)centralTopic);
        new CenteredRevealHelper(viewer).start(centralTopic);
    }

    private void handleSelectBrothers(Request request) {
        List parts = this.getSelectedParts(request.getTargetViewer());
        ArrayList<ITopicPart> toSelect = new ArrayList<ITopicPart>();
        for (IPart p : parts) {
            IBranchPart branch = MindMapUtils.findBranch(p);
            if (branch == null) continue;
            this.collectBrothers(branch, toSelect);
        }
        if (!toSelect.isEmpty()) {
            this.select(toSelect, (IPart)toSelect.get(0));
        }
    }

    private void collectBrothers(IBranchPart branch, List<ITopicPart> toSelect) {
        IBranchPart parent = branch.getParentBranch();
        if (parent != null) {
            for (IBranchPart child : parent.getSubBranches()) {
                toSelect.add(child.getTopicPart());
            }
            for (IBranchPart child : parent.getCalloutBranches()) {
                toSelect.add(child.getTopicPart());
            }
        }
    }

    private void handleSelectChildren(Request request) {
        List parts = this.getSelectedParts(request.getTargetViewer());
        ArrayList<ITopicPart> toSelect = new ArrayList<ITopicPart>();
        for (IPart p : parts) {
            IBranchPart branch = MindMapUtils.findBranch(p);
            if (branch == null) continue;
            this.collectChildren(branch, toSelect);
        }
        if (!toSelect.isEmpty()) {
            this.select(toSelect, (IPart)toSelect.get(0));
        }
    }

    private void collectChildren(IBranchPart branch, List<ITopicPart> toSelect) {
        for (IBranchPart child : branch.getSubBranches()) {
            toSelect.add(child.getTopicPart());
        }
        for (IBranchPart child : branch.getCalloutBranches()) {
            toSelect.add(child.getTopicPart());
        }
    }

    private void handleTraverse(IViewer viewer) {
        IPart focusedPart = viewer.getFocusedPart();
        if (focusedPart != null && focusedPart instanceof IGraphicalEditPart && focusedPart.getStatus().isActive() && focusedPart.hasRole("traversable role")) {
            IGraphicalEditPart source = (IGraphicalEditPart)focusedPart;
            ITool tool = this.getTool("traverse tool");
            if (tool != null) {
                if (tool instanceof ISourceTool) {
                    ((ISourceTool)tool).setSource(source);
                }
                this.changeActiveTool("traverse tool");
            }
        }
    }

    protected void handleTargetedRequest(Request request) {
        ISheetPart sheet;
        String requestType = request.getType();
        if ("edit_label".equals(requestType)) {
            this.handleEditRequest(request);
            return;
        }
        if ("drill_down".equals(requestType)) {
            this.handleDrillDown(request.getTargetViewer(), request.getTargets());
            return;
        }
        if ("show_legend".equals(requestType) && request.getPrimaryTarget() instanceof ISheetPart && !(sheet = (ISheetPart)request.getPrimaryTarget()).getSheet().getLegend().hasPosition()) {
            this.createLegend(request);
            return;
        }
        super.handleTargetedRequest(request);
    }

    protected void navigateTo(List<IPart> toSelect, IPart toFocus, boolean sequential) {
        List<IBranchPart> branchesToExpand = this.findBranchesNeedsExpand(toSelect);
        if (branchesToExpand != null && !branchesToExpand.isEmpty()) {
            this.expand(branchesToExpand);
        }
        if (!this.canNavigateTo(toSelect)) {
            return;
        }
        super.navigateTo(toSelect, toFocus, sequential);
    }

    protected boolean canNavigateTo(List<IPart> toSelect) {
        for (IPart p : toSelect) {
            IFigure figure;
            if (!(p instanceof IGraphicalPart) || (figure = ((IGraphicalPart)p).getFigure()).isVisible()) continue;
            return false;
        }
        return true;
    }

    protected List<IBranchPart> findBranchesNeedsExpand(List<IPart> parts) {
        ArrayList<IBranchPart> branches = null;
        for (IPart p : parts) {
            IBranchPart toExpand;
            IBranchPart branch = MindMapUtils.findBranch(p);
            if (branch == null || (toExpand = this.findBranchNeedsExpand(branch)) == null) continue;
            if (branches == null) {
                branches = new ArrayList<IBranchPart>();
            }
            branches.add(toExpand);
        }
        return branches;
    }

    private IBranchPart findBranchNeedsExpand(IBranchPart branch) {
        IBranchPart parent = branch.getParentBranch();
        if (parent != null) {
            if (parent.isFolded()) {
                return parent;
            }
            return this.findBranchNeedsExpand(parent);
        }
        return null;
    }

    protected void expand(List<IBranchPart> branches) {
        this.getDomain().handleRequest(new Request("extend").setViewer((IViewer)this.getTargetViewer()).setTargets(branches));
    }

    protected Request createAddAttachmentRequest(Request request, IViewer viewer) {
        List<ITopicPart> topics = MindMapUtils.getTopicParts(this.getSelectedParts(viewer));
        if (topics.isEmpty()) {
            return request;
        }
        FileDialog dialog = new FileDialog(viewer.getControl().getShell(), 4098);
        String ret = dialog.open();
        if (ret == null) {
            return request;
        }
        String parentPath = dialog.getFilterPath();
        String[] fileNames = dialog.getFileNames();
        ArrayList<String> paths = new ArrayList<String>(fileNames.length);
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            if (fileName.contains(".")) {
                MindMapUIPlugin.getDefault().getUsageDataCollector().increase(String.format("Attachment/FormatCount/%s", fileName.toLowerCase().substring(fileName.lastIndexOf(46) + 1)));
            } else {
                MindMapUIPlugin.getDefault().getUsageDataCollector().increase("AttachmentFormatCount:BlankFormat");
            }
            String path = new File(parentPath, fileName).getAbsolutePath();
            paths.add(path);
            ++n2;
        }
        request.setTargets(topics);
        request.setParameter("paths", (Object)paths.toArray(new String[0]));
        return request;
    }

    protected Request createModifyHyperlinkRequest(Request request, IViewer viewer) {
        List<ITopicPart> topics = MindMapUtils.getTopicParts(this.getSelectedParts(viewer));
        if (topics.isEmpty()) {
            return null;
        }
        if (request.hasParameter("text")) {
            return request.setTargets(topics);
        }
        return null;
    }

    protected void handleSelectCentral(IViewer viewer) {
        ITopic centralTopic = (ITopic)viewer.getAdapter(ITopic.class);
        if (centralTopic != null) {
            viewer.setSelection((ISelection)new StructuredSelection((Object)centralTopic));
        }
    }

    protected Request createExtendOrCollapseAllRequest(Request request, IViewer viewer) {
        ArrayList<IBranchPart> selectedParts = this.getSelectedParts(viewer);
        if (this.isSheetSelected((List<IPart>)selectedParts, viewer)) {
            ISheetPart sheet = (ISheetPart)viewer.getAdapter(ISheetPart.class);
            if (sheet == null) {
                return request;
            }
            IBranchPart centralBranch = sheet.getCentralBranch();
            if (centralBranch == null) {
                return request;
            }
            selectedParts = new ArrayList<IBranchPart>();
            selectedParts.add(centralBranch);
            selectedParts.addAll(sheet.getFloatingBranches());
        }
        request.setParameter("withAnimation", (Object)Boolean.TRUE);
        request.setTargets((List)selectedParts);
        return request;
    }

    protected boolean isSheetSelected(List<IPart> parts, IViewer viewer) {
        if (parts.isEmpty()) {
            return true;
        }
        for (IPart p : parts) {
            if (!(p instanceof ISheetPart) && p != viewer.getRootPart()) continue;
            return true;
        }
        return false;
    }

    protected void handleCreateFloatingTopicRequest(Point location) {
        if (location == null) {
            return;
        }
        ISheetPart sheet = (ISheetPart)this.getTargetViewer().getAdapter(ISheetPart.class);
        if (sheet == null) {
            return;
        }
        Point position = new Point();
        IFigure figure = sheet.getFigure();
        if (figure instanceof IOriginBased) {
            Point origin = ((IOriginBased)figure).getOrigin();
            position.setLocation(location.x - origin.x, location.y - origin.y);
        }
        Request request = new Request("create_floating");
        request.setDomain(this.getDomain());
        request.setViewer((IViewer)this.getTargetViewer());
        request.setPrimaryTarget((IPart)sheet);
        request.setParameter("position", (Object)position);
        request.setParameter("withAnimation", (Object)Boolean.TRUE);
        this.getDomain().handleRequest(request);
    }

    protected boolean isSelectableOnSelectAll(IPart child) {
        if (!(child instanceof ITopicPart)) {
            return false;
        }
        return super.isSelectableOnSelectAll(child);
    }

    protected void handleCreateRelationship(String reqType, IViewer viewer) {
        ITool next = this.getTool("org.xmind.ui.tool.createRelationship");
        if (next instanceof AbstractTool) {
            ((AbstractTool)next).setTargetViewer(viewer);
        }
        this.changeActiveTool("org.xmind.ui.tool.createRelationship");
    }

    protected Request createCreateBoundaryRequest(Request request, IViewer viewer) {
        List selectedParts = this.getSelectedParts(viewer);
        List<ITopic> topics = MindMapUtils.getTopics(selectedParts);
        if (!topics.isEmpty()) {
            List<IPart> parts = MindMapUtils.getParts(topics, viewer);
            request.setTargets(parts);
            request.setParameter("withAnimation", (Object)Boolean.TRUE);
            return request;
        }
        ITool next = this.getTool("org.xmind.ui.tool.createBoundary");
        if (next instanceof AbstractTool) {
            ((AbstractTool)next).setTargetViewer(viewer);
        }
        this.changeActiveTool("org.xmind.ui.tool.createBoundary");
        return null;
    }

    private Request createCreateSummaryRequest(Request request, IViewer viewer) {
        List selectedParts = this.getSelectedParts((IViewer)this.getTargetViewer());
        List<ITopic> topics = MindMapUtils.getTopics(selectedParts);
        if (!topics.isEmpty()) {
            List<IPart> parts = MindMapUtils.getParts(topics, (IViewer)this.getTargetViewer());
            request.setTargets(parts);
            request.setParameter("withAnimation", (Object)Boolean.TRUE);
            return request;
        }
        ITool next = this.getTool("org.xmind.ui.tool.createSummary");
        if (next instanceof AbstractTool) {
            ((AbstractTool)next).setTargetViewer(viewer);
        }
        this.changeActiveTool("org.xmind.ui.tool.createSummary");
        return null;
    }

    protected void handleDrillDown(IViewer viewer) {
        Object obj;
        ISheet sheet = (ISheet)viewer.getAdapter(ISheet.class);
        if (sheet == null) {
            return;
        }
        ISelection selection = viewer.getSelection();
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof ITopic) {
            ITopic rootTopic = (ITopic)obj;
            this.drillDown(viewer, sheet, rootTopic);
        }
    }

    private void handleDrillDown(IViewer viewer, List<IPart> sources) {
        if (sources.isEmpty()) {
            return;
        }
        ISheet sheet = (ISheet)viewer.getAdapter(ISheet.class);
        if (sheet == null) {
            return;
        }
        IPart p = sources.get(0);
        Object m = MindMapUtils.getRealModel(p);
        if (m instanceof ITopic) {
            this.drillDown(viewer, sheet, (ITopic)m);
            if (viewer.getEditDomain() != null) {
                viewer.getEditDomain().handleRequest("select_central", viewer);
            }
        }
    }

    private void drillDown(IViewer viewer, ISheet sheet, ITopic newRoot) {
        MindMap newInput = new MindMap(sheet, newRoot);
        this.initTopicRightNumber(newRoot);
        viewer.setInput((Object)newInput);
    }

    private void initTopicRightNumber(ITopic newRoot) {
        ITopicExtension extension;
        ITopicExtensionElement element;
        String rightNum;
        if (newRoot == null) {
            return;
        }
        String structureClass = newRoot.getStructureClass();
        if (("org.xmind.ui.map.unbalanced".equals(structureClass) || structureClass == null) && (rightNum = (element = (ITopicExtensionElement)(extension = newRoot.createExtension("org.xmind.ui.map.unbalanced")).getContent().getCreatedChild("right-number")).getTextContent()) == null) {
            int size = newRoot.getChildren("attached").size();
            if (size > 3) {
                size /= 2;
            }
            element.setTextContent(String.valueOf(size));
        }
    }

    protected void handleDrillUp(IViewer viewer) {
        IDrillDownTraceService traceService;
        ISheet sheet = (ISheet)viewer.getAdapter(ISheet.class);
        if (sheet != null && (traceService = (IDrillDownTraceService)viewer.getService(IDrillDownTraceService.class)) != null) {
            ITopic newRoot = traceService.getPreviousCentralTopic();
            this.drillDown(viewer, sheet, newRoot);
        }
    }

    private void createLegend(Request request) {
        this.changeActiveTool("org.xmind.ui.tool.createLegend");
    }

    protected void handleEditLabelRequest(Request request, IViewer viewer) {
        request = this.fillTargets(request, viewer, false);
        ArrayList<ITopicPart> targets = new ArrayList<ITopicPart>(request.getTargets());
        int i = 0;
        while (i < targets.size()) {
            IPart p = (IPart)targets.get(i);
            if (p instanceof IIconTipPart) {
                targets.set(i, ((IIconTipPart)p).getTopicPart());
            } else if (p instanceof IMarkerPart) {
                targets.set(i, ((IMarkerPart)p).getTopicPart());
            } else if (p instanceof IImagePart) {
                targets.set(i, ((IImagePart)p).getTopicPart());
            } else if (p instanceof INumberingPart) {
                targets.set(i, ((INumberingPart)p).getTopicPart());
            } else if (p instanceof IInfoItemPart) {
                targets.set(i, ((IInfoItemPart)p).getTopicPart());
            }
            ++i;
        }
        request.setTargets(targets);
        this.handleEditRequest(request);
    }

    protected String getEditTool(IPart source, Request request) {
        String requestType;
        String string = requestType = request == null ? null : request.getType();
        if (source instanceof ITopicPart) {
            if ("edit_label".equals(requestType)) {
                return "org.xmind.ui.tool.editLabel";
            }
            return "org.xmind.ui.tool.editTopicTitle";
        }
        if (source instanceof ILegendItemPart) {
            return "org.xmind.ui.tool.editLegendItem";
        }
        return super.getEditTool(source, request);
    }

    protected Request createEditRequestOnDoubleClick(IPart source, MouseEvent me) {
        if (source instanceof ILabelPart) {
            ITopicPart topic;
            ILabelPart label = (ILabelPart)source;
            IBranchPart branch = label.getOwnedBranch();
            if (branch != null && (topic = branch.getTopicPart()) != null) {
                return new Request("edit_label").setPrimaryTarget((IPart)topic).setDomain(this.getDomain()).setViewer((IViewer)this.getTargetViewer());
            }
        } else if (source instanceof ILegendItemPart) {
            ILegendItemPart item = (ILegendItemPart)source;
            return new Request("edit_legend_item").setPrimaryTarget((IPart)item).setDomain(this.getDomain()).setViewer((IViewer)this.getTargetViewer());
        }
        return super.createEditRequestOnDoubleClick(source, me);
    }

    protected boolean handleDragStarted(DragDropEvent de) {
        ITool dndTool = this.getTool("dnd tool");
        if (dndTool != null) {
            this.changeActiveTool("dnd tool");
            if (this.getDomain().getActiveTool() == dndTool && dndTool instanceof IDragDropHandler) {
                ((IDragDropHandler)dndTool).dragStarted(de, (IViewer)this.getTargetViewer());
            }
            return true;
        }
        return super.handleDragStarted(de);
    }

    protected void showMarkerMenu(IMarkerPart target) {
        if (this.getTargetViewer() == null || this.getTargetViewer().getEditDomain() == null || this.getTargetViewer().getEditDomain().getCommandStack() == null || "PresentationViewer".equals(this.getTargetViewer().getClass().getSimpleName())) {
            return;
        }
        MenuManager menuManager = new MenuManager();
        MindMapSelectTool.fillMarkerGroup(menuManager, target.getMarkerRef(), this.getTargetViewer());
        final Menu menu = menuManager.createContextMenu(this.getTargetViewer().getControl());
        Point p = this.getTargetViewer().computeToDisplay(target.getFigure().getBounds().getBottomLeft(), true);
        menu.setLocation(p.x, p.y);
        menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
            }

            public void menuHidden(MenuEvent e) {
                e.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        menu.dispose();
                    }
                });
            }
        });
        menu.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                menu.setVisible(true);
            }
        });
    }

    private static void fillMarkerGroup(MenuManager menuManager, final IMarkerRef markerRef, IGraphicalViewer targetViewer) {
        HashSet<String> addedMarkerIds = new HashSet<String>();
        MindMapSelectTool.fillMarkerGroup(menuManager, markerRef, targetViewer, markerRef.getOwnedWorkbook().getMarkerSheet(), addedMarkerIds);
        MindMapSelectTool.fillMarkerGroup(menuManager, markerRef, targetViewer, MindMapUI.getResourceManager().getUserMarkerSheet(), addedMarkerIds);
        menuManager.add((IContributionItem)new Separator());
        ViewerAction deleteAction = new ViewerAction(targetViewer){

            public void run() {
                this.executeCommand((Command)new DeleteMarkerCommand(markerRef));
            }
        };
        deleteAction.setText(WorkbenchMessages.Workbench_delete);
        deleteAction.setToolTipText(WorkbenchMessages.Workbench_deleteToolTip);
        deleteAction.setImageDescriptor(MindMapUI.getImages().get("remove.png", true));
        deleteAction.setDisabledImageDescriptor(MindMapUI.getImages().get("remove.png", false));
        menuManager.add((IAction)deleteAction);
    }

    private static void fillMarkerGroup(MenuManager menuManager, IMarkerRef sourceMarkerRef, IGraphicalViewer targetViewer, IMarkerSheet markerSheet, Set<String> addedMarkerIds) {
        IMarker sourceMarker = markerSheet.findMarker(sourceMarkerRef.getMarkerId());
        if (sourceMarker == null) {
            return;
        }
        IMarkerGroup group = sourceMarker.getParent();
        if (group == null) {
            return;
        }
        ArrayList<IMarker> visibleMarkers = new ArrayList<IMarker>();
        for (IMarker marker : group.getMarkers()) {
            if (marker.isHidden()) continue;
            visibleMarkers.add(marker);
        }
        for (IMarker targetMarker : visibleMarkers) {
            if (addedMarkerIds.contains(targetMarker.getId())) continue;
            menuManager.add((IAction)new ReplaceMarkerAction(targetViewer, sourceMarkerRef, targetMarker));
            addedMarkerIds.add(targetMarker.getId());
        }
    }

    protected Request createNavScrollRequest(int state, int key) {
        Request request;
        if (state != (SWT.MOD1 | SWT.MOD3)) {
            return null;
        }
        if (key == 0x1000001) {
            request = new Request("navigate_up");
        } else if (key == 0x1000002) {
            request = new Request("navigate_down");
        } else if (key == 0x1000003) {
            request = new Request("navigate_left");
        } else if (key == 0x1000004) {
            request = new Request("navigate_right");
        } else {
            return null;
        }
        request.setViewer((IViewer)this.getTargetViewer());
        request.setDomain(this.getDomain());
        return request;
    }

    protected boolean handleNavRequest(Request request, boolean sequential) {
        ISelection newSelection;
        IViewer viewer = request.getTargetViewer();
        ISelection oldSelection = viewer == null ? null : viewer.getSelection();
        boolean handled = super.handleNavRequest(request, sequential);
        ISelection iSelection = newSelection = viewer == null ? null : viewer.getSelection();
        if (!(sequential || handled && !this.isSelectionEqual(oldSelection, newSelection))) {
            return this.handleNavScroll(request);
        }
        return handled;
    }

    private boolean isSelectionEqual(ISelection oldSelection, ISelection newSelection) {
        if (oldSelection instanceof IStructuredSelection && newSelection instanceof IStructuredSelection) {
            HashSet oldElements = new HashSet(((IStructuredSelection)oldSelection).toList());
            HashSet newElements = new HashSet(((IStructuredSelection)newSelection).toList());
            return oldElements.equals(newElements);
        }
        return oldSelection == newSelection || oldSelection != null && oldSelection.equals(newSelection);
    }

    private boolean handleNavScroll(Request request) {
        String type = request.getType();
        IViewer viewer = request.getTargetViewer();
        if (viewer == null) {
            return false;
        }
        Viewport viewport = (Viewport)viewer.getAdapter(Viewport.class);
        if (viewport == null) {
            return false;
        }
        IFigure contents = viewport.getContents();
        Rectangle contentsBounds = contents instanceof FreeformFigure ? ((FreeformFigure)contents).getFreeformExtent() : contents.getBounds();
        contentsBounds = contentsBounds.getExpanded(60, 60).intersect(contents.getBounds());
        Rectangle clientArea = viewport.getClientArea();
        Point center = ((IGraphicalViewer)viewer).getCenterPoint().getCopy();
        int d = 0;
        if ("navigate_left".equals(type)) {
            d = Math.min(50, Math.abs(contentsBounds.x - clientArea.x));
            center.translate(-d, 0);
        } else if ("navigate_up".equals(type)) {
            d = Math.min(50, Math.abs(contentsBounds.y - clientArea.y));
            center.translate(0, -d);
        } else if ("navigate_right".equals(type)) {
            d = Math.min(50, Math.abs(contentsBounds.right() - clientArea.right()));
            center.translate(-d, 0);
        } else if ("navigate_down".equals(type)) {
            d = Math.min(50, Math.abs(contentsBounds.bottom() - clientArea.bottom()));
            center.translate(0, -d);
        } else {
            return false;
        }
        if (d == 0) {
            return false;
        }
        ((IGraphicalViewer)viewer).center(center);
        return true;
    }

    protected void handleEditRequest(Request request) {
        BoundaryPart boundary;
        IPart source = request.getPrimaryTarget();
        if (source instanceof BoundaryPart && (boundary = (BoundaryPart)source).isPolygonShape(boundary.getFigure())) {
            return;
        }
        super.handleEditRequest(request);
    }

    private class CenteredRevealHelper
    implements IRevealServiceListener {
        private ZoomingAndPanningRevealService service;
        private boolean oldCentered;

        public CenteredRevealHelper(IViewer viewer) {
            IViewerService service = viewer.getService(IRevealService.class);
            if (service != null && service instanceof ZoomingAndPanningRevealService) {
                this.service = (ZoomingAndPanningRevealService)service;
                this.oldCentered = this.service.isCentered();
            } else {
                this.service = null;
                this.oldCentered = false;
            }
        }

        public void start(IGraphicalPart part) {
            if (this.service != null) {
                this.service.setCentered(true);
                this.service.reveal((ISelection)new StructuredSelection((Object)part));
                this.service.addRevealServiceListener((IRevealServiceListener)this);
            }
        }

        public void revealingStarted(RevealEvent event) {
        }

        public void revealingCanceled(RevealEvent event) {
            this.restore();
        }

        public void revealingFinished(RevealEvent event) {
            this.restore();
        }

        void restore() {
            this.service.removeRevealServiceListener((IRevealServiceListener)this);
            this.service.setCentered(this.oldCentered);
        }
    }
}

