/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.ui.internal.views.InspectorContentSection;
import org.xmind.ui.internal.views.Messages;
import org.xmind.ui.mindmap.MindMapUI;

public class AttachmentsInspectorSection
extends InspectorContentSection
implements ICoreEventListener {
    private ICoreEventRegister register;
    private List<ITopic> topicsWithAttachment;
    private List<ITopic> allTopics;

    public AttachmentsInspectorSection() {
        this.setTitle(NLS.bind((String)Messages.AttachmentsInspectorSection_title, (Object)0));
    }

    @Override
    protected Object[] getAllPropertyContents(IGraphicalViewer viewer) {
        List<ITopic> topicsWithAttachment = null;
        List<ITopic> allTopics = null;
        ISheet sheet = (ISheet)viewer.getAdapter(ISheet.class);
        if (sheet != null) {
            allTopics = this.getAllTopics();
            topicsWithAttachment = this.getTopicwithAttachment(allTopics);
        }
        this.setLabelRef(topicsWithAttachment, allTopics);
        if (topicsWithAttachment != null) {
            return topicsWithAttachment.toArray();
        }
        return new Object[0];
    }

    private void setLabelRef(List<ITopic> topicsWithAttachment, List<ITopic> allTopics) {
        if (topicsWithAttachment == this.topicsWithAttachment && allTopics == this.allTopics) {
            return;
        }
        if (this.register != null) {
            this.register.unregisterAll();
            this.register = null;
        }
        this.topicsWithAttachment = topicsWithAttachment;
        this.allTopics = allTopics;
        if (allTopics != null) {
            this.register = new CoreEventRegister((Object)this.getCurrentWorkbook(), (ICoreEventListener)this);
            this.register.register("modifyTime");
        }
    }

    private List<ITopic> getTopicwithAttachment(List<ITopic> all) {
        ArrayList<ITopic> topics = null;
        for (ITopic topic : all) {
            if (!this.hasAttachment(topic)) continue;
            if (topics == null) {
                topics = new ArrayList<ITopic>();
            }
            topics.add(topic);
        }
        return topics;
    }

    private boolean hasAttachment(ITopic topic) {
        return topic.getHyperlink() != null && topic.getHyperlink().startsWith("xap:");
    }

    @Override
    protected Image getPropertyInspectorImage(Object element) {
        if (element instanceof ITopic) {
            String path = HyperlinkUtils.toAttachmentPath((String)((ITopic)element).getHyperlink());
            ImageDescriptor image = MindMapUI.getImages().getFileIcon(path, true);
            if (image != null) {
                return image.createImage();
            }
        }
        return super.getPropertyInspectorImage(element);
    }

    @Override
    protected String getPropertyInspectorText(Object element) {
        if (element instanceof ITopic) {
            return ((ITopic)element).getTitleText().replaceAll("\r\n|\r|\n", " ");
        }
        return null;
    }

    @Override
    protected void refreshList() {
        super.refreshList();
        if (this.topicsWithAttachment == null) {
            this.setTitle(NLS.bind((String)Messages.AttachmentsInspectorSection_title, (Object)0));
        } else {
            this.setTitle(NLS.bind((String)Messages.AttachmentsInspectorSection_title, (Object)this.topicsWithAttachment.size()));
        }
    }

    @Override
    protected void handleDispose() {
        if (this.register != null) {
            this.register.unregisterAll();
            this.register = null;
        }
    }

    public void handleCoreEvent(final CoreEvent event) {
        Control c = this.getControl();
        if (c == null || c.isDisposed()) {
            return;
        }
        c.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                AttachmentsInspectorSection.this.refreshList(event);
            }
        });
    }

    protected void refreshList(CoreEvent event) {
        this.refreshList();
        this.getControl().getParent().layout();
    }
}

