/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.Core;
import org.xmind.core.IBoundary;
import org.xmind.core.IControlPoint;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.internal.command.Logger;
import org.xmind.core.io.ByteArrayStorage;
import org.xmind.core.io.IStorage;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.image.ImageExportUtils;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.IDecorationContext;
import org.xmind.ui.gallery.ILabelDecorator;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.mindmap.MindMap;
import org.xmind.ui.mindmap.MindMapImageExporter;
import org.xmind.ui.mindmap.MindMapUI;

public class ThemeLabelProvider
extends LabelProvider
implements ILabelDecorator {
    private static final String THEME_PREVIEWS_DIR = ".themePreviews";
    private static final int IMAGE_WIDTH = 800;
    private static final int IMAGE_HEIGHT = 400;
    private static final int BACKGROUND_ENLARGEMENT_MARGINS = 400;
    private static Image defaultImage;
    private String structureClass;

    public ThemeLabelProvider() {
        ThemePreviewImageProviderManager.INSTANCE.addThemePreviewImageListener(this);
    }

    public ThemeLabelProvider(String structureClass) {
        this.structureClass = structureClass;
        ThemePreviewImageProviderManager.INSTANCE.addThemePreviewImageListener(this);
    }

    public String getText(Object element) {
        if (element instanceof IStyle && "theme".equals(((IStyle)element).getType())) {
            return ((IStyle)element).getName();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof IStyle && "theme".equals(((IStyle)element).getType())) {
            return ThemePreviewImageProviderManager.INSTANCE.getThemePreviewImage((IStyle)element, this.structureClass == null || "".equals(this.structureClass) ? this.getCurrentCentralStructure() : this.structureClass);
        }
        return super.getImage(element);
    }

    public void dispose() {
        ThemePreviewImageProviderManager.INSTANCE.removeThemePreviewImageListener(this);
        super.dispose();
    }

    private void themePreviewImageChanged(IStyle theme) {
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, (Object)theme));
    }

    private static File getPreviewImageCacheFileForTheme(IStyle theme, String structureClass) {
        File root = MindMapUIPlugin.getDefault().getStateLocation().toFile();
        File cacheDir = new File(root, THEME_PREVIEWS_DIR);
        String themeId = theme.getId();
        IStyleSheet sheet = theme.getOwnedStyleSheet();
        String parentId = sheet == MindMapUI.getResourceManager().getSystemThemeSheet() ? "system" : (sheet == MindMapUI.getResourceManager().getUserThemeSheet() ? "user" : "other");
        String fileName = String.format("%s-%s-%s.png", parentId, structureClass, themeId);
        return new File(cacheDir, fileName);
    }

    private static Image createPreviewImageForTheme(IStyle theme, String structureClass, Display display) {
        IWorkbook workbook = ThemeLabelProvider.createTemplateWorkbook(structureClass);
        IStyle appliedTheme = workbook.getStyleSheet().importStyle(theme);
        if (appliedTheme != null) {
            workbook.getPrimarySheet().setThemeId(appliedTheme.getId());
        }
        final MindMapImageExporter exporter = new MindMapImageExporter(display);
        Properties props = new Properties();
        props.set("margin", 400);
        exporter.setSource(new MindMap(workbook.getPrimarySheet()), props, new Insets(15));
        exporter.setResize(1, 800, 400);
        final Image[] image = new Image[1];
        if (!display.isDisposed()) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    image[0] = exporter.createImage();
                }
            });
        }
        return image[0];
    }

    private static IWorkbook createTemplateWorkbook(String structureClass) {
        ByteArrayStorage tempStorage = new ByteArrayStorage();
        IWorkbook workbook = Core.getWorkbookBuilder().createWorkbook((IStorage)tempStorage);
        ISheet sheet = workbook.getPrimarySheet();
        ITopic rootTopic = sheet.getRootTopic();
        rootTopic.setTitleText(MindMapMessages.TitleText_CentralTopic);
        rootTopic.setStructureClass(structureClass == null || "".equals(structureClass) ? "org.xmind.ui.map.clockwise" : structureClass);
        ITopic mainTopic1 = workbook.createTopic();
        mainTopic1.setTitleText(NLS.bind((String)MindMapMessages.TitleText_MainTopic, (Object)1));
        rootTopic.add(mainTopic1);
        ITopic subTopic1 = workbook.createTopic();
        subTopic1.setTitleText(NLS.bind((String)MindMapMessages.TitleText_Subtopic, (Object)1));
        mainTopic1.add(subTopic1);
        ITopic subTopic2 = workbook.createTopic();
        subTopic2.setTitleText(NLS.bind((String)MindMapMessages.TitleText_Subtopic, (Object)2));
        mainTopic1.add(subTopic2);
        ITopic subTopic3 = workbook.createTopic();
        subTopic3.setTitleText(NLS.bind((String)MindMapMessages.TitleText_Subtopic, (Object)3));
        mainTopic1.add(subTopic3);
        ITopic floatingTopic = workbook.createTopic();
        floatingTopic.setTitleText(MindMapMessages.TitleText_FloatingTopic);
        floatingTopic.setPosition(0, -120);
        rootTopic.add(floatingTopic, "detached");
        IBoundary boundary = workbook.createBoundary();
        boundary.setTitleText(MindMapMessages.TitleText_Boundary);
        boundary.setStartIndex(0);
        boundary.setEndIndex(0);
        rootTopic.addBoundary(boundary);
        IRelationship relationship = workbook.createRelationship();
        relationship.setTitleText(MindMapMessages.TitleText_Relationship);
        relationship.setEnd1Id(mainTopic1.getId());
        relationship.setEnd2Id(floatingTopic.getId());
        IControlPoint cp1 = relationship.getControlPoint(0);
        cp1.setPosition(50, -100);
        IControlPoint cp2 = relationship.getControlPoint(1);
        cp2.setPosition(100, 0);
        sheet.addRelationship(relationship);
        return workbook;
    }

    public IFigure decorateFigure(IFigure figure, Object element, IDecorationContext context) {
        List children = figure.getChildren();
        boolean needInitFigureContent = children.isEmpty();
        if (needInitFigureContent) {
            SizeableImageFigure themeContentFigure = new SizeableImageFigure(this.getImage(element));
            SizeableImageFigure defaultImageFigure = new SizeableImageFigure(ThemeLabelProvider.getDefaultImage());
            figure.add((IFigure)themeContentFigure);
            figure.add((IFigure)defaultImageFigure);
            if (context != null) {
                figure.setLayoutManager((LayoutManager)new Layout(context));
                boolean imageConstrained = Boolean.TRUE.equals(context.getProperty("constrained", (Object)false));
                boolean imageStretched = Boolean.TRUE.equals(context.getProperty("stretched", (Object)false));
                themeContentFigure.setConstrained(imageConstrained);
                themeContentFigure.setStretched(imageStretched);
                defaultImageFigure.setConstrained(imageConstrained);
                defaultImageFigure.setStretched(imageStretched);
            }
        }
        int supportSize = 2;
        children = figure.getChildren();
        if (children.size() == supportSize) {
            Object themeContentFigure = children.get(0);
            Object defaultImageFigure = children.get(supportSize - 1);
            if (themeContentFigure instanceof SizeableImageFigure && defaultImageFigure instanceof SizeableImageFigure) {
                ((SizeableImageFigure)themeContentFigure).setImage(this.getImage(element));
                IStyle defaultTheme = MindMapUI.getResourceManager().getDefaultTheme();
                ((SizeableImageFigure)defaultImageFigure).setImage((Image)(element == defaultTheme ? ThemeLabelProvider.getDefaultImage() : null));
            }
        }
        return figure;
    }

    private static Image getDefaultImage() {
        ImageDescriptor desc;
        if (defaultImage == null && (desc = MindMapUI.getImages().get("star.png", true)) != null) {
            try {
                defaultImage = desc.createImage(false);
            }
            catch (Throwable throwable) {}
        }
        return defaultImage;
    }

    private String getCurrentCentralStructure() {
        if (this.structureClass != null && !"".equals(this.structureClass)) {
            return this.structureClass;
        }
        String defaultStructureClass = "org.xmind.ui.map.clockwise";
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return defaultStructureClass;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return defaultStructureClass;
        }
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (activeEditor == null || !(activeEditor instanceof IGraphicalEditor)) {
            return defaultStructureClass;
        }
        IGraphicalEditorPage page = ((IGraphicalEditor)activeEditor).getActivePageInstance();
        if (page == null) {
            return defaultStructureClass;
        }
        ISheet sheet = (ISheet)page.getAdapter(ISheet.class);
        if (sheet == null) {
            return defaultStructureClass;
        }
        ITopic topic = sheet.getRootTopic();
        return topic.getStructureClass();
    }

    private static class Layout
    extends AbstractHintLayout {
        private IDecorationContext properties;

        public Layout(IDecorationContext properties) {
            this.properties = properties;
        }

        public void layout(IFigure container) {
            Rectangle area = container.getClientArea();
            for (Object child : container.getChildren()) {
                IFigure figure = (IFigure)child;
                Dimension childSize = figure.getPreferredSize(-1, -1);
                int childWidth = Math.min(area.width, childSize.width);
                int childHeight = Math.min(area.height, childSize.height);
                figure.setBounds(new Rectangle(area.x, area.y, childWidth, childHeight));
            }
        }

        protected Dimension calculatePreferredSize(IFigure figure, int wHint, int hHint) {
            if (wHint > -1) {
                wHint = Math.max(0, wHint - figure.getInsets().getWidth());
            }
            if (hHint > -1) {
                hHint = Math.max(0, hHint - figure.getInsets().getHeight());
            }
            Insets insets = figure.getInsets();
            Dimension contentSize = (Dimension)this.properties.getProperty("org.xmind.ui.gallery.frameContentSize", null);
            if (contentSize != null) {
                return new Dimension(contentSize.width + insets.getWidth(), contentSize.height + insets.getHeight());
            }
            Dimension d = new Dimension();
            List children = figure.getChildren();
            int i = 0;
            while (i < children.size()) {
                IFigure child = (IFigure)children.get(i);
                if (!this.isObservingVisibility() || child.isVisible()) {
                    d.union(child.getPreferredSize(wHint, hHint));
                }
                ++i;
            }
            d.expand(figure.getInsets().getWidth(), figure.getInsets().getHeight());
            d.union(this.getBorderPreferredSize(figure));
            return d;
        }
    }

    private static class ThemePreviewImageLoader
    extends Job {
        private IStyle theme;
        private String structureClass;
        private Display display;
        private Image previewImage;

        public ThemePreviewImageLoader(IStyle theme, String structureClass, Display display) {
            super(NLS.bind((String)MindMapMessages.ThemeLabel_LoadTheme, (Object)theme.getName()));
            this.theme = theme;
            this.structureClass = structureClass;
            this.display = display;
            this.previewImage = null;
        }

        protected IStatus run(IProgressMonitor monitor) {
            Image image = null;
            File cacheFile = this.getPreviewImageCacheFile();
            if (cacheFile.exists()) {
                try {
                    image = new Image((Device)this.display, cacheFile.getAbsolutePath());
                }
                catch (Throwable error) {
                    Logger.log((String)("Failed to load cached theme preview image from file " + cacheFile.getAbsolutePath()), (Throwable)error);
                    cacheFile.delete();
                }
            }
            if (monitor.isCanceled()) {
                if (image != null) {
                    image.dispose();
                }
                return Status.CANCEL_STATUS;
            }
            if (image == null) {
                try {
                    image = this.createPreviewImage();
                }
                catch (Throwable fatalError) {
                    return new Status(4, "org.xmind.ui.mindmap", "Failed to create preview image for theme (" + this.theme.getName() + ")", fatalError);
                }
                if (image != null) {
                    if (monitor.isCanceled()) {
                        image.dispose();
                        return Status.CANCEL_STATUS;
                    }
                    FileUtils.ensureFileParent((File)cacheFile);
                    try {
                        FileOutputStream out = new FileOutputStream(cacheFile);
                        try {
                            ImageExportUtils.saveImage((Image)image, (OutputStream)out, (int)5);
                        }
                        finally {
                            ((OutputStream)out).close();
                        }
                    }
                    catch (IOException error) {
                        Logger.log((String)("Failed to save theme preview image to cache file " + cacheFile.getAbsolutePath()), (Throwable)error);
                    }
                }
            }
            if (image != null) {
                if (monitor.isCanceled()) {
                    image.dispose();
                    cacheFile.delete();
                    return Status.CANCEL_STATUS;
                }
                this.previewImage = image;
            }
            return Status.OK_STATUS;
        }

        private Image createPreviewImage() {
            return ThemeLabelProvider.createPreviewImageForTheme(this.theme, this.structureClass, this.display);
        }

        private File getPreviewImageCacheFile() {
            return ThemeLabelProvider.getPreviewImageCacheFileForTheme(this.theme, this.structureClass);
        }

        public Image getPreviewImage() {
            return this.previewImage;
        }

        public IStyle getTheme() {
            return this.theme;
        }

        public String getStructureClass() {
            return this.structureClass;
        }
    }

    private static class ThemePreviewImageProviderManager
    implements ICoreEventListener,
    ISchedulingRule {
        public static final ThemePreviewImageProviderManager INSTANCE = new ThemePreviewImageProviderManager();
        private Map<String, Map<IStyle, Image>> imageGroups = new HashMap<String, Map<IStyle, Image>>();
        private Map<String, Map<IStyle, ThemePreviewImageLoader>> loaderGroups = new HashMap<String, Map<IStyle, ThemePreviewImageLoader>>();
        private ListenerList listeners = new ListenerList();
        private ICoreEventRegistration themeRemovalEventReg = null;
        private IJobChangeListener loaderListener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Image image;
                super.done(event);
                ThemePreviewImageLoader loader = (ThemePreviewImageLoader)event.getJob();
                Map loaderGroup = (Map)ThemePreviewImageProviderManager.this.loaderGroups.get(loader.getStructureClass());
                if (loaderGroup != null && !loaderGroup.isEmpty()) {
                    loaderGroup.remove(loader.getTheme());
                }
                if ((image = loader.getPreviewImage()) != null) {
                    ThemePreviewImageProviderManager.this.setPreviewImage(loader.getTheme(), loader.getStructureClass(), image);
                }
            }
        };

        private ThemePreviewImageProviderManager() {
            this.checkLocalLanguage();
        }

        private void checkLocalLanguage() {
            String lang = System.getProperty("osgi.nl");
            File root = MindMapUIPlugin.getDefault().getStateLocation().toFile();
            File cacheDir = new File(root, ThemeLabelProvider.THEME_PREVIEWS_DIR);
            FileUtils.ensureDirectory((File)cacheDir);
            File langFile = new File(cacheDir, lang);
            if (!langFile.exists()) {
                File[] files;
                File[] fileArray = files = cacheDir.listFiles();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.exists()) {
                        file.delete();
                    }
                    ++n2;
                }
                try {
                    langFile.createNewFile();
                }
                catch (IOException iOException) {}
            }
        }

        public void addThemePreviewImageListener(ThemeLabelProvider listener) {
            boolean wasEmpty = this.listeners.isEmpty();
            this.listeners.add((Object)listener);
            boolean isEmpty = this.listeners.isEmpty();
            if (wasEmpty && !isEmpty) {
                if (this.themeRemovalEventReg != null) {
                    this.themeRemovalEventReg.unregister();
                }
                this.themeRemovalEventReg = ((ICoreEventSource)MindMapUI.getResourceManager().getUserThemeSheet()).registerCoreEventListener("styleRemove", (ICoreEventListener)this);
            }
        }

        public void removeThemePreviewImageListener(ThemeLabelProvider listener) {
            boolean wasEmpty = this.listeners.isEmpty();
            this.listeners.remove((Object)listener);
            boolean isEmpty = this.listeners.isEmpty();
            if (!wasEmpty && isEmpty && this.themeRemovalEventReg != null) {
                this.themeRemovalEventReg.unregister();
                this.themeRemovalEventReg = null;
            }
        }

        private void fireThemePreviewImageChanged(final IStyle theme) {
            Object[] objectArray = this.listeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                final Object listener = objectArray[n2];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        ((ThemeLabelProvider)((Object)listener)).themePreviewImageChanged(theme);
                    }
                });
                ++n2;
            }
        }

        public void handleCoreEvent(CoreEvent event) {
            if ("styleRemove".equals(event.getType())) {
                IStyle theme = (IStyle)event.getTarget();
                this.deletePreviewImageCacheForTheme(theme);
            }
        }

        public Image getThemePreviewImage(IStyle theme, String structureClass) {
            Image image = null;
            Map<IStyle, Image> imageGroup = this.imageGroups.get(structureClass);
            if (imageGroup != null) {
                image = imageGroup.get(theme);
            }
            if (image != null) {
                return image;
            }
            Map<IStyle, ThemePreviewImageLoader> loaderGroup = this.loaderGroups.get(structureClass);
            if (loaderGroup == null) {
                loaderGroup = new HashMap<IStyle, ThemePreviewImageLoader>();
                this.loaderGroups.put(structureClass, loaderGroup);
            }
            if (!loaderGroup.containsKey(theme)) {
                ThemePreviewImageLoader loader = new ThemePreviewImageLoader(theme, structureClass, Display.getCurrent());
                loader.setRule(this);
                loader.setSystem(true);
                loader.addJobChangeListener(this.loaderListener);
                loaderGroup.put(theme, loader);
                MindMapUIPlugin.getDefault().registerJob(loader);
                loader.schedule();
            }
            return null;
        }

        private void deletePreviewImageCacheForTheme(IStyle theme) {
            for (String structureClass : this.imageGroups.keySet()) {
                File cacheFile = ThemeLabelProvider.getPreviewImageCacheFileForTheme(theme, structureClass);
                if (cacheFile.exists()) {
                    cacheFile.delete();
                }
                this.deletePreviewImageCacheInMemory(theme, structureClass);
            }
        }

        private void deletePreviewImageCacheInMemory(final IStyle theme, String structureClass) {
            Map<IStyle, ThemePreviewImageLoader> loaderGroup;
            Image image;
            Display display = null;
            Map<IStyle, Image> imageGroup = this.imageGroups.get(structureClass);
            if (imageGroup != null && !imageGroup.isEmpty() && (image = imageGroup.remove(theme)) != null && !(display = (Display)image.getDevice()).isDisposed()) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Display display = Display.getCurrent();
                        if (!display.isDisposed()) {
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    image.dispose();
                                }
                            });
                        }
                    }
                });
            }
            if ((loaderGroup = this.loaderGroups.get(structureClass)) != null && !loaderGroup.isEmpty()) {
                ThemePreviewImageLoader loader = loaderGroup.remove(theme);
                if (loader != null) {
                    loader.cancel();
                }
                if (display != null && !display.isDisposed()) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ThemePreviewImageProviderManager.this.fireThemePreviewImageChanged(theme);
                        }
                    });
                }
            }
        }

        private void setPreviewImage(final IStyle theme, String structureClass, Image image) {
            Image oldImage;
            Display display = null;
            Map<IStyle, Image> imageGroup = this.imageGroups.get(structureClass);
            if (imageGroup == null) {
                imageGroup = new HashMap<IStyle, Image>();
                this.imageGroups.put(structureClass, imageGroup);
            }
            if ((oldImage = imageGroup.put(theme, image)) != null && !(display = (Display)oldImage.getDevice()).isDisposed()) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Display display = Display.getCurrent();
                        if (!display.isDisposed()) {
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    oldImage.dispose();
                                }
                            });
                        }
                    }
                });
            }
            if (!(display = (Display)image.getDevice()).isDisposed()) {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ThemePreviewImageProviderManager.this.fireThemePreviewImageChanged(theme);
                    }
                });
            }
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

