/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.plugin.lsb;

import com.openstego.desktop.OpenStegoConfig;
import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.plugin.lsb.LSBConfig;
import com.openstego.desktop.ui.OpenStegoUI;
import com.openstego.desktop.ui.PluginEmbedOptionsUI;
import com.openstego.desktop.util.CommonUtil;
import com.openstego.desktop.util.LabelUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LSBEmbedOptionsUI
extends PluginEmbedOptionsUI {
    private static final long serialVersionUID = 6168148599483165215L;
    private static LabelUtil labelUtil = LabelUtil.getInstance("LSB");
    private JCheckBox randomImgCheckBox = new JCheckBox();
    private JComboBox<Integer> maxBitsComboBox = null;
    private OpenStegoUI stegoUI = null;

    public LSBEmbedOptionsUI(OpenStegoUI stegoUI) {
        this.stegoUI = stegoUI;
        GridBagConstraints gridBagConstraints = null;
        JLabel label = null;
        Integer[] maxBitsList = new Integer[8];
        this.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = 0;
        label = new JLabel(labelUtil.getString("gui.label.option.useRandomImage"));
        this.add((Component)label, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        label = new JLabel(labelUtil.getString("gui.label.option.maxBitsPerChannel"));
        this.add((Component)label, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.randomImgCheckBox, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        for (int i = 0; i < 8; ++i) {
            maxBitsList[i] = i + 1;
        }
        this.maxBitsComboBox = new JComboBox<Integer>(maxBitsList);
        this.maxBitsComboBox.setPreferredSize(new Dimension(40, 20));
        this.add(this.maxBitsComboBox, gridBagConstraints);
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                LSBEmbedOptionsUI.this.useRandomImgChanged();
            }
        };
        this.randomImgCheckBox.addChangeListener(changeListener);
        this.useRandomImgChanged();
    }

    private void useRandomImgChanged() {
        JTextField coverFileTextField = this.stegoUI.getEmbedPanel().getCoverFileTextField();
        JButton coverFileButton = this.stegoUI.getEmbedPanel().getCoverFileButton();
        if (this.randomImgCheckBox.isSelected()) {
            CommonUtil.setEnabled(coverFileTextField, false);
            coverFileTextField.setText("");
            coverFileButton.setEnabled(false);
        } else {
            CommonUtil.setEnabled(coverFileTextField, true);
            coverFileButton.setEnabled(true);
            coverFileTextField.requestFocus();
        }
    }

    @Override
    public boolean validateEmbedAction() throws OpenStegoException {
        return true;
    }

    @Override
    public void setGUIFromConfig(OpenStegoConfig config) throws OpenStegoException {
        this.maxBitsComboBox.setSelectedItem(((LSBConfig)config).getMaxBitsUsedPerChannel());
    }

    @Override
    public void setConfigFromGUI(OpenStegoConfig config) throws OpenStegoException {
        ((LSBConfig)config).setMaxBitsUsedPerChannel((Integer)this.maxBitsComboBox.getSelectedItem());
    }
}

