/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.util;

import com.openstego.desktop.OpenStegoException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public class StringUtil {
    private StringUtil() {
    }

    public static String getHexString(byte[] raw) {
        BigInteger bigInteger = new BigInteger(1, raw);
        return String.format("%0" + (raw.length << 1) + "x", bigInteger);
    }

    public static long passwordHash(String password) throws OpenStegoException {
        long DEFAULT_HASH = 98234782L;
        byte[] byteHash = null;
        String hexString = null;
        if (password == null || password.equals("")) {
            return 98234782L;
        }
        try {
            byteHash = MessageDigest.getInstance("MD5").digest(password.getBytes());
            hexString = StringUtil.getHexString(byteHash);
            hexString = hexString.substring(0, 15);
            return Long.parseLong(hexString, 16);
        }
        catch (NoSuchAlgorithmException nsaEx) {
            throw new OpenStegoException(nsaEx);
        }
    }

    public static List<String> getStringLines(String input) throws OpenStegoException {
        String str = null;
        ArrayList<String> stringList = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new StringReader(input));
            while ((str = reader.readLine()) != null) {
                if ((str = str.trim()).equals("") || str.startsWith("#")) continue;
                stringList.add(str.trim());
            }
        }
        catch (IOException ioEx) {
            throw new OpenStegoException(ioEx);
        }
        return stringList;
    }

    public static boolean isNullOrEmpty(String val) {
        return val == null || val.length() == 0;
    }
}

