#include "ibm.h"
#include "plat-keyboard.h"
#include "keyboard.h"

int keybsendcallback = 0;

typedef struct {
	uint8_t scancodes_make[8];
	uint8_t scancodes_break[8];
} scancode;

/*272 = 256 + 16 fake interim scancodes for disambiguation purposes.*/
static scancode scancode_set1[272] =
	{
		{{0}, {0}}, {{0x01, 0}, {0x81, 0}}, {{0x02, 0}, {0x82, 0}}, {{0x03, 0}, {0x83, 0}},
		{{0x04, 0}, {0x84, 0}}, {{0x05, 0}, {0x85, 0}}, {{0x06, 0}, {0x86, 0}}, {{0x07, 0}, {0x87, 0}},
		{{0x08, 0}, {0x88, 0}}, {{0x09, 0}, {0x89, 0}}, {{0x0a, 0}, {0x8a, 0}}, {{0x0b, 0}, {0x8b, 0}},
		{{0x0c, 0}, {0x8c, 0}}, {{0x0d, 0}, {0x8d, 0}}, {{0x0e, 0}, {0x8e, 0}}, {{0x0f, 0}, {0x8f, 0}},
		{{0x10, 0}, {0x90, 0}}, {{0x11, 0}, {0x91, 0}}, {{0x12, 0}, {0x92, 0}}, {{0x13, 0}, {0x93, 0}},
		{{0x14, 0}, {0x94, 0}}, {{0x15, 0}, {0x95, 0}}, {{0x16, 0}, {0x96, 0}}, {{0x17, 0}, {0x97, 0}},
		{{0x18, 0}, {0x98, 0}}, {{0x19, 0}, {0x99, 0}}, {{0x1a, 0}, {0x9a, 0}}, {{0x1b, 0}, {0x9b, 0}},
		{{0x1c, 0}, {0x9c, 0}}, {{0x1d, 0}, {0x9d, 0}}, {{0x1e, 0}, {0x9e, 0}}, {{0x1f, 0}, {0x9f, 0}},
		{{0x20, 0}, {0xa0, 0}}, {{0x21, 0}, {0xa1, 0}}, {{0x22, 0}, {0xa2, 0}}, {{0x23, 0}, {0xa3, 0}},
		{{0x24, 0}, {0xa4, 0}}, {{0x25, 0}, {0xa5, 0}}, {{0x26, 0}, {0xa6, 0}}, {{0x27, 0}, {0xa7, 0}},
		{{0x28, 0}, {0xa8, 0}}, {{0x29, 0}, {0xa9, 0}}, {{0x2a, 0}, {0xaa, 0}}, {{0x2b, 0}, {0xab, 0}},
		{{0x2c, 0}, {0xac, 0}}, {{0x2d, 0}, {0xad, 0}}, {{0x2e, 0}, {0xae, 0}}, {{0x2f, 0}, {0xaf, 0}},
		{{0x30, 0}, {0xb0, 0}}, {{0x31, 0}, {0xb1, 0}}, {{0x32, 0}, {0xb2, 0}}, {{0x33, 0}, {0xb3, 0}},
		{{0x34, 0}, {0xb4, 0}}, {{0x35, 0}, {0xb5, 0}}, {{0x36, 0}, {0xb6, 0}}, {{0x37, 0}, {0xb7, 0}},
		{{0x38, 0}, {0xb8, 0}}, {{0x39, 0}, {0xb9, 0}}, {{0x3a, 0}, {0xba, 0}}, {{0x3b, 0}, {0xbb, 0}},
		{{0x3c, 0}, {0xbc, 0}}, {{0x3d, 0}, {0xbd, 0}}, {{0x3e, 0}, {0xbe, 0}}, {{0x3f, 0}, {0xbf, 0}},
		{{0x40, 0}, {0xc0, 0}}, {{0x41, 0}, {0xc1, 0}}, {{0x42, 0}, {0xc2, 0}}, {{0x43, 0}, {0xc3, 0}},
		{{0x44, 0}, {0xc4, 0}}, {{0x45, 0}, {0xc5, 0}}, {{0x46, 0}, {0xc6, 0}}, {{0x47, 0}, {0xc7, 0}},
		{{0x48, 0}, {0xc8, 0}}, {{0x49, 0}, {0xc9, 0}}, {{0x4a, 0}, {0xca, 0}}, {{0x4b, 0}, {0xcb, 0}},
		{{0x4c, 0}, {0xcc, 0}}, {{0x4d, 0}, {0xcd, 0}}, {{0x4e, 0}, {0xce, 0}}, {{0x4f, 0}, {0xcf, 0}},
		{{0x50, 0}, {0xd0, 0}}, {{0x51, 0}, {0xd1, 0}}, {{0x52, 0}, {0xd2, 0}}, {{0x53, 0}, {0xd3, 0}},
		{{0x54, 0}, {0xd4, 0}}, {{0x55, 0}, {0xd5, 0}}, {{0x56, 0}, {0xd6, 0}}, {{0x57, 0}, {0xd7, 0}},
		{{0x58, 0}, {0xd8, 0}}, {{0x59, 0}, {0xd9, 0}}, {{0x5a, 0}, {0xda, 0}}, {{0x5b, 0}, {0xdb, 0}},
		{{0x5c, 0}, {0xdc, 0}}, {{0x5d, 0}, {0xdd, 0}}, {{0x5e, 0}, {0xde, 0}}, {{0x5f, 0}, {0xdf, 0}},
		{{0x60, 0}, {0xe0, 0}}, {{0x61, 0}, {0xe1, 0}}, {{0x62, 0}, {0xe2, 0}}, {{0x63, 0}, {0xe3, 0}},
		{{0x64, 0}, {0xe4, 0}}, {{0x65, 0}, {0xe5, 0}}, {{0x66, 0}, {0xe6, 0}}, {{0x67, 0}, {0xe7, 0}},
		{{0x68, 0}, {0xe8, 0}}, {{0x69, 0}, {0xe9, 0}}, {{0x6a, 0}, {0xea, 0}}, {{0x6b, 0}, {0xeb, 0}},
		{{0x6c, 0}, {0xec, 0}}, {{0x6d, 0}, {0xed, 0}}, {{0x6e, 0}, {0xee, 0}}, {{0x6f, 0}, {0xef, 0}},
		{{0x70, 0}, {0xf0, 0}}, {{0x71, 0}, {0xf1, 0}}, {{0x72, 0}, {0xf2, 0}}, {{0x73, 0}, {0xf3, 0}},
		{{0x74, 0}, {0xf4, 0}}, {{0x75, 0}, {0xf5, 0}}, {{0x76, 0}, {0xf6, 0}}, {{0x77, 0}, {0xf7, 0}},
		{{0x78, 0}, {0xf8, 0}}, {{0x79, 0}, {0xf9, 0}}, {{0x7a, 0}, {0xfa, 0}}, {{0x7b, 0}, {0xfb, 0}},
		{{0x7c, 0}, {0xfc, 0}}, {{0x7d, 0}, {0xfd, 0}}, {{0x7e, 0}, {0xfe, 0}}, {{0x7f, 0}, {0xff, 0}},

		{{0x80, 0}, {0}}, {{0x81, 0}, {0}}, {{0x82, 0}, {0}}, {{0xe0, 0x03, 0}, {0xe0, 0x83, 0}}, /*80*/
		{{0xe0, 0x04, 0}, {0xe0, 0x84, 0}}, {{0x85, 0}, {0}}, {{0x86, 0}, {0}}, {{0x87, 0}, {0}},             /*84*/
		{{0xe0, 0x08, 0}, {0xe0, 0x88, 0}}, {{0xe0, 0x09, 0}, {0xe0, 0x89, 0}}, {{0xe0, 0x0a, 0}, {0xe0, 0x8a, 0}}, {{0xe0, 0x0b, 0}, {0xe0, 0x8b, 0}}, /*88*/
		{{0xe0, 0x0c, 0}, {0xe0, 0x8c, 0}}, {{0}, {0}}, {{0xe0, 0x0e, 0}, {0xe0, 0x8e, 0}}, {{0xe0, 0x0f, 0}, {0xe0, 0x8f, 0}}, /*8c*/
		{{0xe0, 0x10, 0}, {0xe0, 0x90, 0}}, {{0xe0, 0x11, 0}, {0xe0, 0x91, 0}}, {{0xe0, 0x12, 0}, {0xe0, 0x92, 0}}, {{0xe0, 0x13, 0}, {0xe0, 0x93, 0}}, /*90*/
		{{0xe0, 0x14, 0}, {0xe0, 0x94, 0}}, {{0xe0, 0x15, 0}, {0xe0, 0x95, 0}}, {{0xe0, 0x16, 0}, {0xe0, 0x96, 0}}, {{0xe0, 0x17, 0}, {0xe0, 0x97, 0}}, /*94*/
		{{0xe0, 0x18, 0}, {0xe0, 0x98, 0}}, {{0xe0, 0x19, 0}, {0xe0, 0x99, 0}}, {{0xe0, 0x1a, 0}, {0xe0, 0x9a, 0}}, {{0xe0, 0x1b, 0}, {0xe0, 0x9b, 0}}, /*98*/
		{{0xe0, 0x1c, 0}, {0xe0, 0x9c, 0}}, {{0xe0, 0x1d, 0}, {0xe0, 0x9d, 0}}, {{0xe0, 0x1e, 0}, {0xe0, 0x9e, 0}}, {{0xe0, 0x1f, 0}, {0xe0, 0x9f, 0}}, /*9c*/
		{{0xe0, 0x20, 0}, {0xe0, 0xa0, 0}}, {{0xe0, 0x21, 0}, {0xe0, 0xa1, 0}}, {{0xe0, 0x22, 0}, {0xe0, 0xa2, 0}}, {{0xe0, 0x23, 0}, {0xe0, 0xa3, 0}}, /*a0*/
		{{0xe0, 0x24, 0}, {0xe0, 0xa4, 0}}, {{0xe0, 0x25, 0}, {0xe0, 0xa5, 0}}, {{0xe0, 0x26, 0}, {0xe0, 0xa6, 0}}, {{0}, {0}},             /*a4*/
		{{0}, {0}}, {{0}, {0}}, {{0xe0, 0x2a, 0}, {0xe0, 0xaa, 0}}, {{0}, {0}},             /*a8*/
		{{0xe0, 0x2c, 0}, {0xe0, 0xac, 0}}, {{0xe0, 0x2d, 0}, {0xe0, 0xad, 0}}, {{0xe0, 0x2e, 0}, {0xe0, 0xae, 0}}, {{0xe0, 0x2f, 0}, {0xe0, 0xaf, 0}}, /*ac*/
		{{0xe0, 0x30, 0}, {0xe0, 0xb0, 0}}, {{0xe0, 0x31, 0}, {0xe0, 0xb1, 0}}, {{0xe0, 0x32, 0}, {0xe0, 0xb2, 0}}, {{0}, {0}},             /*b0*/
		{{0xe0, 0x34, 0}, {0xe0, 0xb4, 0}}, {{0xe0, 0x35, 0}, {0xe0, 0xb5, 0}}, {{0xe0, 0x36, 0}, {0xe0, 0xb6, 0}}, {{0xe0, 0x37, 0}, {0xe0, 0xb7, 0}}, /*b4*/
		{{0xe0, 0x38, 0}, {0xe0, 0xb8, 0}}, {{0}, {0}}, {{0xe0, 0x3a, 0}, {0xe0, 0xba, 0}}, {{0xe0, 0x3b, 0}, {0xe0, 0xbb, 0}}, /*b8*/
		{{0xe0, 0x3c, 0}, {0xe0, 0xbc, 0}}, {{0xe0, 0x3d, 0}, {0xe0, 0xbd, 0}}, {{0xe0, 0x3e, 0}, {0xe0, 0xbe, 0}}, {{0xe0, 0x3f, 0}, {0xe0, 0xbf, 0}}, /*bc*/
		{{0xe0, 0x40, 0}, {0xe0, 0xc0, 0}}, {{0xe0, 0x41, 0}, {0xe0, 0xc1, 0}}, {{0xe0, 0x42, 0}, {0xe0, 0xc2, 0}}, {{0xe0, 0x43, 0}, {0xe0, 0xc3, 0}}, /*c0*/
		{{0xe0, 0x44, 0}, {0xe0, 0xc4, 0}}, {{0}, {0}}, {{0xe0, 0x46, 0}, {0xe0, 0xc6, 0}}, {{0xe0, 0x47, 0}, {0xe0, 0xc7, 0}}, /*c4*/
		{{0xe0, 0x48, 0}, {0xe0, 0xc8, 0}}, {{0xe0, 0x49, 0}, {0xe0, 0xc9, 0}}, {{0}, {0}}, {{0xe0, 0x4b, 0}, {0xe0, 0xcb, 0}}, /*c8*/
		{{0xe0, 0x4c, 0}, {0xe0, 0xcc, 0}}, {{0xe0, 0x4d, 0}, {0xe0, 0xcd, 0}}, {{0xe0, 0x4e, 0}, {0xe0, 0xce, 0}}, {{0xe0, 0x4f, 0}, {0xe0, 0xcf, 0}}, /*cc*/
		{{0xe0, 0x50, 0}, {0xe0, 0xd0, 0}}, {{0xe0, 0x51, 0}, {0xe0, 0xd1, 0}}, {{0xe0, 0x52, 0}, {0xe0, 0xd2, 0}}, {{0xe0, 0x53, 0}, {0xe0, 0xd3, 0}}, /*d0*/
		{{0xd4, 0}, {0}}, {{0xe0, 0x55, 0}, {0xe0, 0xd5, 0}}, {{0}, {0}}, {{0xe0, 0x57, 0}, {0xe0, 0xd7, 0}}, /*d4*/
		{{0xe0, 0x58, 0}, {0xe0, 0xd8, 0}}, {{0xe0, 0x59, 0}, {0xe0, 0xd9, 0}}, {{0xe0, 0x5a, 0}, {0xe0, 0xaa, 0}}, {{0xe0, 0x5b, 0}, {0xe0, 0xdb, 0}}, /*d8*/
		{{0xe0, 0x5c, 0}, {0xe0, 0xdc, 0}}, {{0xe0, 0x5d, 0}, {0xe0, 0xdd, 0}}, {{0xe0, 0x5e, 0}, {0xe0, 0xee, 0}}, {{0xe0, 0x5f, 0}, {0xe0, 0xdf, 0}}, /*dc*/
		{{0}, {0}}, {{0xe0, 0x61, 0}, {0xe0, 0xe1, 0}}, {{0xe0, 0x62, 0}, {0xe0, 0xe2, 0}}, {{0xe0, 0x63, 0}, {0xe0, 0xe3, 0}}, /*e0*/
		{{0xe0, 0x64, 0}, {0xe0, 0xe4, 0}}, {{0xe0, 0x65, 0}, {0xe0, 0xe5, 0}}, {{0xe0, 0x66, 0}, {0xe0, 0xe6, 0}}, {{0xe0, 0x67, 0}, {0xe0, 0xe7, 0}}, /*e4*/
		{{0xe0, 0x68, 0}, {0xe0, 0xe8, 0}}, {{0xe0, 0x69, 0}, {0xe0, 0xe9, 0}}, {{0xe0, 0x6a, 0}, {0xe0, 0xea, 0}}, {{0xe0, 0x6b, 0}, {0xe0, 0xeb, 0}}, /*e8*/
		{{0xe0, 0x6c, 0}, {0xe0, 0xec, 0}}, {{0xe0, 0x6d, 0}, {0xe0, 0xed, 0}}, {{0xe0, 0x6e, 0}, {0xe0, 0xee, 0}}, {{0}, {0}},             /*ec*/
		{{0xe0, 0x70, 0}, {0xe0, 0xf0, 0}}, {{0xf1, 0}, {0}}, {{0xf2, 0}, {0}}, {{0xe0, 0x73, 0}, {0xe0, 0xf3, 0}}, /*f0*/
		{{0xe0, 0x74, 0}, {0xe0, 0xf4, 0}}, {{0xe0, 0x75, 0}, {0xe0, 0xf5, 0}}, {{0}, {0}}, {{0xe0, 0x77, 0}, {0xe0, 0xf7, 0}}, /*f4*/
		{{0xe0, 0x78, 0}, {0xe0, 0xf8, 0}}, {{0xe0, 0x79, 0}, {0xe0, 0xf9, 0}}, {{0xe0, 0x7a, 0}, {0xe0, 0xfa, 0}}, {{0xe0, 0x7b, 0}, {0xe0, 0xfb, 0}}, /*f8*/
		{{0xe0, 0x7c, 0}, {0xe0, 0xfc, 0}}, {{0xe0, 0x7d, 0}, {0xe0, 0xfd, 0}}, {{0xe0, 0x7e, 0}, {0xe0, 0xfe, 0}}, {{0xe1, 0x1d, 0x45, 0xe1, 0x9d, 0xc5, 0}, {0}},  /*fc*/
		{{0}, {0}}, {{0xe0, 0x01, 0}, {0xe0, 0x81, 0}}, {{0xe0, 0x02, 0}, {0xe0, 0x82, 0}}, {{0}, {0}},             /*100*/
		{{0}, {0}}, {{0xe0, 0x05, 0}, {0xe0, 0x85, 0}}, {{0xe0, 0x06, 0}, {0xe0, 0x86, 0}}, {{0xe0, 0x07, 0}, {0xe0, 0x87, 0}}, /*104*/
		{{0xe0, 0x71, 0}, {0xe0, 0xf1, 0}}, {{0xe0, 0x72, 0}, {0xe0, 0xf2, 0}}, {{0xe0, 0x7f, 0}, {0xe0, 0xff, 0}}, {{0xe0, 0xe1, 0}, {0}},             /*108*/
		{{0xe0, 0xee, 0}, {0}}, {{0xe0, 0xf1, 0}, {0}}, {{0xe0, 0xfe, 0}, {0}}, {{0xe0, 0xff, 0}, {0}}              /*10c*/
	};

/*272 = 256 + 16 fake interim scancodes for disambiguation purposes.*/
static scancode scancode_set2[272] =
	{
		{{0}, {0}}, {{0x76, 0}, {0xf0, 0x76, 0}}, {{0x16, 0}, {0xf0, 0x16, 0}}, {{0x1e, 0}, {0xf0, 0x1e, 0}},
		{{0x26, 0}, {0xf0, 0x26, 0}}, {{0x25, 0}, {0xf0, 0x25, 0}}, {{0x2e, 0}, {0xf0, 0x2e, 0}}, {{0x36, 0}, {0xf0, 0x36, 0}},
		{{0x3d, 0}, {0xf0, 0x3d, 0}}, {{0x3e, 0}, {0xf0, 0x3e, 0}}, {{0x46, 0}, {0xf0, 0x46, 0}}, {{0x45, 0}, {0xf0, 0x45, 0}},
		{{0x4e, 0}, {0xf0, 0x4e, 0}}, {{0x55, 0}, {0xf0, 0x55, 0}}, {{0x66, 0}, {0xf0, 0x66, 0}}, {{0x0d, 0}, {0xf0, 0x0d, 0}},
		{{0x15, 0}, {0xf0, 0x15, 0}}, {{0x1d, 0}, {0xf0, 0x1d, 0}}, {{0x24, 0}, {0xf0, 0x24, 0}}, {{0x2d, 0}, {0xf0, 0x2d, 0}},
		{{0x2c, 0}, {0xf0, 0x2c, 0}}, {{0x35, 0}, {0xf0, 0x35, 0}}, {{0x3c, 0}, {0xf0, 0x3c, 0}}, {{0x43, 0}, {0xf0, 0x43, 0}},
		{{0x44, 0}, {0xf0, 0x44, 0}}, {{0x4d, 0}, {0xf0, 0x4d, 0}}, {{0x54, 0}, {0xf0, 0x54, 0}}, {{0x5b, 0}, {0xf0, 0x5b, 0}},
		{{0x5a, 0}, {0xf0, 0x5a, 0}}, {{0x14, 0}, {0xf0, 0x14, 0}}, {{0x1c, 0}, {0xf0, 0x1c, 0}}, {{0x1b, 0}, {0xf0, 0x1b, 0}},
		{{0x23, 0}, {0xf0, 0x23, 0}}, {{0x2b, 0}, {0xf0, 0x2b, 0}}, {{0x34, 0}, {0xf0, 0x34, 0}}, {{0x33, 0}, {0xf0, 0x33, 0}},
		{{0x3b, 0}, {0xf0, 0x3b, 0}}, {{0x42, 0}, {0xf0, 0x42, 0}}, {{0x4b, 0}, {0xf0, 0x4b, 0}}, {{0x4c, 0}, {0xf0, 0x4c, 0}},
		{{0x52, 0}, {0xf0, 0x52, 0}}, {{0x0e, 0}, {0xf0, 0x0e, 0}}, {{0x12, 0}, {0xf0, 0x12, 0}}, {{0x5d, 0}, {0xf0, 0x5d, 0}},
		{{0x1a, 0}, {0xf0, 0x1a, 0}}, {{0x22, 0}, {0xf0, 0x22, 0}}, {{0x21, 0}, {0xf0, 0x21, 0}}, {{0x2a, 0}, {0xf0, 0x2a, 0}},
		{{0x32, 0}, {0xf0, 0x32, 0}}, {{0x31, 0}, {0xf0, 0x31, 0}}, {{0x3a, 0}, {0xf0, 0x3a, 0}}, {{0x41, 0}, {0xf0, 0x41, 0}},
		{{0x49, 0}, {0xf0, 0x49, 0}}, {{0x4a, 0}, {0xf0, 0x4a, 0}}, {{0x59, 0}, {0xf0, 0x59, 0}}, {{0x7c, 0}, {0xf0, 0x7c, 0}},
		{{0x11, 0}, {0xf0, 0x11, 0}}, {{0x29, 0}, {0xf0, 0x29, 0}}, {{0x58, 0}, {0xf0, 0x58, 0}}, {{0x05, 0}, {0xf0, 0x05, 0}},
		{{0x06, 0}, {0xf0, 0x06, 0}}, {{0x04, 0}, {0xf0, 0x04, 0}}, {{0x0c, 0}, {0xf0, 0x0c, 0}}, {{0x03, 0}, {0xf0, 0x03, 0}},
		{{0x0b, 0}, {0xf0, 0x0b, 0}}, {{0x83, 0}, {0xf0, 0x83, 0}}, {{0x0a, 0}, {0xf0, 0x0a, 0}}, {{0x01, 0}, {0xf0, 0x01, 0}},
		{{0x09, 0}, {0xf0, 0x09, 0}}, {{0x77, 0}, {0xf0, 0x77, 0}}, {{0x7e, 0}, {0xf0, 0x7e, 0}}, {{0x6c, 0}, {0xf0, 0x6c, 0}},
		{{0x75, 0}, {0xf0, 0x75, 0}}, {{0x7d, 0}, {0xf0, 0x7d, 0}}, {{0x7b, 0}, {0xf0, 0x7b, 0}}, {{0x6b, 0}, {0xf0, 0x6b, 0}},
		{{0x73, 0}, {0xf0, 0x73, 0}}, {{0x74, 0}, {0xf0, 0x74, 0}}, {{0x79, 0}, {0xf0, 0x79, 0}}, {{0x69, 0}, {0xf0, 0x69, 0}},
		{{0x72, 0}, {0xf0, 0x72, 0}}, {{0x7a, 0}, {0xf0, 0x7a, 0}}, {{0x70, 0}, {0xf0, 0x70, 0}}, {{0x71, 0}, {0xf0, 0x71, 0}},
		{{0x84, 0}, {0xf0, 0x84, 0}}, {{0, 0}, {0, 0}}, {{0x61, 0}, {0xf0, 0x61, 0}}, {{0x78, 0}, {0xf0, 0x78, 0}},
		{{0x07, 0}, {0xf0, 0x07, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},

		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0xe0, 0x5a, 0}, {0xe0, 0xf0, 0x5a, 0}}, {{0xe0, 0x14, 0}, {0xe0, 0xf0, 0x14, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0xe0, 0x4a, 0}, {0xe0, 0xf0, 0x4a, 0}}, {{0, 0}, {0, 0}}, {{0xe0, 0x7c, 0}, {0xe0, 0xf0, 0x7c, 0}},
		{{0xe0, 0x11, 0}, {0xe0, 0xf0, 0x11, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0xe0, 0x6c, 0}, {0xe0, 0xf0, 0x6c, 0}},
		{{0xe0, 0x75, 0}, {0xe0, 0xf0, 0x75, 0}}, {{0xe0, 0x7d, 0}, {0xe0, 0xf0, 0x7d, 0}}, {{0, 0}, {0, 0}}, {{0xe0, 0x6b, 0}, {0xe0, 0xf0, 0x6b, 0}},
		{{0, 0}, {0, 0}}, {{0xe0, 0x74, 0}, {0xe0, 0xf0, 0x74, 0}}, {{0, 0}, {0, 0}}, {{0xe0, 0x69, 0}, {0xe0, 0xf0, 0x69, 0}},
		{{0xe0, 0x72, 0}, {0xe0, 0xf0, 0x72, 0}}, {{0xe0, 0x7a, 0}, {0xe0, 0xf0, 0x7a, 0}}, {{0xe0, 0x70, 0}, {0xe0, 0xf0, 0x70, 0}}, {{0xe0, 0x71, 0}, {0xe0, 0xf0, 0x71, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0xe0, 0x1f, 0}, {0xe0, 0xf0, 0x1f, 0}},
		{{0xe0, 0x27, 0}, {0xe0, 0xf0, 0x27, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},

		{{0}, {0}}, {{0xe0, 0x01, 0}, {0xe0, 0xf0, 0x01, 0}}, {{0xe0, 0x02, 0}, {0xe0, 0xf0, 0x02, 0}}, {{0}, {0}},             /*100*/
		{{0}, {0}}, {{0xe0, 0x05, 0}, {0xe0, 0xf0, 0x15, 0}}, {{0xe0, 0x06, 0}, {0xe0, 0xf0, 0x06, 0}}, {{0xe0, 0x07, 0}, {0xe0, 0xf0, 0x07, 0}}, /*104*/
		{{0xe0, 0x71, 0}, {0xe0, 0xf0, 0x71, 0}}, {{0xe0, 0x72, 0}, {0xe0, 0xf0, 0x72, 0}}, {{0xe0, 0x7f, 0}, {0xe0, 0xf0, 0x7f, 0}}, {{0xe0, 0xe1, 0}, {0}},             /*108*/
		{{0xe0, 0xee, 0}, {0}}, {{0xe0, 0xf1, 0}, {0}}, {{0xe0, 0xfe, 0}, {0}}, {{0xe0, 0xff, 0}, {0}}              /*10c*/
	};

/*272 = 256 + 16 fake interim scancodes for disambiguation purposes.*/
static scancode scancode_set3[272] =
	{
		{{0}, {0}}, {{0x76, 0}, {0xf0, 0x76, 0}}, {{0x16, 0}, {0xf0, 0x16, 0}}, {{0x1e, 0}, {0xf0, 0x1e, 0}},
		{{0x26, 0}, {0xf0, 0x26, 0}}, {{0x25, 0}, {0xf0, 0x25, 0}}, {{0x2e, 0}, {0xf0, 0x2e, 0}}, {{0x36, 0}, {0xf0, 0x36, 0}},
		{{0x3d, 0}, {0xf0, 0x3d, 0}}, {{0x3e, 0}, {0xf0, 0x3e, 0}}, {{0x46, 0}, {0xf0, 0x46, 0}}, {{0x45, 0}, {0xf0, 0x45, 0}},
		{{0x4e, 0}, {0xf0, 0x4e, 0}}, {{0x55, 0}, {0xf0, 0x55, 0}}, {{0x66, 0}, {0xf0, 0x66, 0}}, {{0x0d, 0}, {0xf0, 0x0d, 0}},
		{{0x15, 0}, {0xf0, 0x15, 0}}, {{0x1d, 0}, {0xf0, 0x1d, 0}}, {{0x24, 0}, {0xf0, 0x24, 0}}, {{0x2d, 0}, {0xf0, 0x2d, 0}},
		{{0x2c, 0}, {0xf0, 0x2c, 0}}, {{0x35, 0}, {0xf0, 0x35, 0}}, {{0x3c, 0}, {0xf0, 0x3c, 0}}, {{0x43, 0}, {0xf0, 0x43, 0}},
		{{0x44, 0}, {0xf0, 0x44, 0}}, {{0x4d, 0}, {0xf0, 0x4d, 0}}, {{0x54, 0}, {0xf0, 0x54, 0}}, {{0x5b, 0}, {0xf0, 0x5b, 0}},
		{{0x5a, 0}, {0xf0, 0x5a, 0}}, {{0x19, 0}, {0xf0, 0x19, 0}}, {{0x1c, 0}, {0xf0, 0x1c, 0}}, {{0x1b, 0}, {0xf0, 0x1b, 0}},
		{{0x23, 0}, {0xf0, 0x23, 0}}, {{0x2b, 0}, {0xf0, 0x2b, 0}}, {{0x34, 0}, {0xf0, 0x34, 0}}, {{0x33, 0}, {0xf0, 0x33, 0}},
		{{0x3b, 0}, {0xf0, 0x3b, 0}}, {{0x42, 0}, {0xf0, 0x42, 0}}, {{0x4b, 0}, {0xf0, 0x4b, 0}}, {{0x4c, 0}, {0xf0, 0x4c, 0}},
		{{0x52, 0}, {0xf0, 0x52, 0}}, {{0x0e, 0}, {0xf0, 0x0e, 0}}, {{0x12, 0}, {0xf0, 0x12, 0}}, {{0x5c, 0}, {0xf0, 0x5c, 0}},
		{{0x1a, 0}, {0xf0, 0x1a, 0}}, {{0x22, 0}, {0xf0, 0x22, 0}}, {{0x21, 0}, {0xf0, 0x21, 0}}, {{0x2a, 0}, {0xf0, 0x2a, 0}},
		{{0x32, 0}, {0xf0, 0x32, 0}}, {{0x31, 0}, {0xf0, 0x31, 0}}, {{0x3a, 0}, {0xf0, 0x3a, 0}}, {{0x41, 0}, {0xf0, 0x41, 0}},
		{{0x49, 0}, {0xf0, 0x49, 0}}, {{0x4a, 0}, {0xf0, 0x4a, 0}}, {{0x59, 0}, {0xf0, 0x59, 0}}, {{0x7c, 0}, {0xf0, 0x7c, 0}},
		{{0x11, 0}, {0xf0, 0x11, 0}}, {{0x29, 0}, {0xf0, 0x29, 0}}, {{0x14, 0}, {0xf0, 0x14, 0}}, {{0x05, 0}, {0xf0, 0x05, 0}},
		{{0x06, 0}, {0xf0, 0x06, 0}}, {{0x04, 0}, {0xf0, 0x04, 0}}, {{0x0c, 0}, {0xf0, 0x0c, 0}}, {{0x03, 0}, {0xf0, 0x03, 0}},
		{{0x0b, 0}, {0xf0, 0x0b, 0}}, {{0x83, 0}, {0xf0, 0x83, 0}}, {{0x0a, 0}, {0xf0, 0x0a, 0}}, {{0x01, 0}, {0xf0, 0x01, 0}},
		{{0x09, 0}, {0xf0, 0x09, 0}}, {{0x77, 0}, {0xf0, 0x77, 0}}, {{0x7e, 0}, {0xf0, 0x7e, 0}}, {{0x6c, 0}, {0xf0, 0x6c, 0}},
		{{0x75, 0}, {0xf0, 0x75, 0}}, {{0x7d, 0}, {0xf0, 0x7d, 0}}, {{0x7b, 0}, {0xf0, 0x7b, 0}}, {{0x6b, 0}, {0xf0, 0x6b, 0}},
		{{0x73, 0}, {0xf0, 0x73, 0}}, {{0x74, 0}, {0xf0, 0x74, 0}}, {{0x79, 0}, {0xf0, 0x79, 0}}, {{0x69, 0}, {0xf0, 0x69, 0}},
		{{0x72, 0}, {0xf0, 0x72, 0}}, {{0x7a, 0}, {0xf0, 0x7a, 0}}, {{0x70, 0}, {0xf0, 0x70, 0}}, {{0x71, 0}, {0xf0, 0x71, 0}},
		{{0x84, 0}, {0xf0, 0x84, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0x78, 0}, {0xf0, 0x78, 0}},
		{{0x07, 0}, {0xf0, 0x07, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},

		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0x79, 0}, {0xf0, 0x79, 0}}, {{0x58, 0}, {0xf0, 0x58, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0x77, 0}, {0xf0, 0x77, 0}}, {{0, 0}, {0, 0}}, {{0x57, 0}, {0xf0, 0x57, 0}},
		{{0x39, 0}, {0xf0, 0x39, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0x6e, 0}, {0xf0, 0x6e, 0}},
		{{0x63, 0}, {0xf0, 0x63, 0}}, {{0x6f, 0}, {0xf0, 0x6f, 0}}, {{0, 0}, {0, 0}}, {{0x61, 0}, {0xf0, 0x61, 0}},
		{{0, 0}, {0, 0}}, {{0x6a, 0}, {0xf0, 0x6a, 0}}, {{0, 0}, {0, 0}}, {{0x65, 0}, {0xf0, 0x65, 0}},
		{{0x60, 0}, {0xf0, 0x60, 0}}, {{0x6d, 0}, {0xf0, 0x6d, 0}}, {{0x67, 0}, {0xf0, 0x67, 0}}, {{0x64, 0}, {0xf0, 0x64, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0x8b, 0}, {0xf0, 0x8b, 0}},
		{{0x8c, 0}, {0xf0, 0x8c, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},

		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
		{{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}}, {{0, 0}, {0, 0}},
	};

/*XT keyboard has no escape scancodes, and no scancodes beyond 53*/
static scancode scancode_xt[272] =
	{
		{{0}, {0}}, {{0x01, 0}, {0x81, 0}}, {{0x02, 0}, {0x82, 0}}, {{0x03, 0}, {0x83, 0}},
		{{0x04, 0}, {0x84, 0}}, {{0x05, 0}, {0x85, 0}}, {{0x06, 0}, {0x86, 0}}, {{0x07, 0}, {0x87, 0}},
		{{0x08, 0}, {0x88, 0}}, {{0x09, 0}, {0x89, 0}}, {{0x0a, 0}, {0x8a, 0}}, {{0x0b, 0}, {0x8b, 0}},
		{{0x0c, 0}, {0x8c, 0}}, {{0x0d, 0}, {0x8d, 0}}, {{0x0e, 0}, {0x8e, 0}}, {{0x0f, 0}, {0x8f, 0}},
		{{0x10, 0}, {0x90, 0}}, {{0x11, 0}, {0x91, 0}}, {{0x12, 0}, {0x92, 0}}, {{0x13, 0}, {0x93, 0}},
		{{0x14, 0}, {0x94, 0}}, {{0x15, 0}, {0x95, 0}}, {{0x16, 0}, {0x96, 0}}, {{0x17, 0}, {0x97, 0}},
		{{0x18, 0}, {0x98, 0}}, {{0x19, 0}, {0x99, 0}}, {{0x1a, 0}, {0x9a, 0}}, {{0x1b, 0}, {0x9b, 0}},
		{{0x1c, 0}, {0x9c, 0}}, {{0x1d, 0}, {0x9d, 0}}, {{0x1e, 0}, {0x9e, 0}}, {{0x1f, 0}, {0x9f, 0}},
		{{0x20, 0}, {0xa0, 0}}, {{0x21, 0}, {0xa1, 0}}, {{0x22, 0}, {0xa2, 0}}, {{0x23, 0}, {0xa3, 0}},
		{{0x24, 0}, {0xa4, 0}}, {{0x25, 0}, {0xa5, 0}}, {{0x26, 0}, {0xa6, 0}}, {{0x27, 0}, {0xa7, 0}},
		{{0x28, 0}, {0xa8, 0}}, {{0x29, 0}, {0xa9, 0}}, {{0x2a, 0}, {0xaa, 0}}, {{0x2b, 0}, {0xab, 0}},
		{{0x2c, 0}, {0xac, 0}}, {{0x2d, 0}, {0xad, 0}}, {{0x2e, 0}, {0xae, 0}}, {{0x2f, 0}, {0xaf, 0}},
		{{0x30, 0}, {0xb0, 0}}, {{0x31, 0}, {0xb1, 0}}, {{0x32, 0}, {0xb2, 0}}, {{0x33, 0}, {0xb3, 0}},
		{{0x34, 0}, {0xb4, 0}}, {{0x35, 0}, {0xb5, 0}}, {{0x36, 0}, {0xb6, 0}}, {{0x37, 0}, {0xb7, 0}},
		{{0x38, 0}, {0xb8, 0}}, {{0x39, 0}, {0xb9, 0}}, {{0x3a, 0}, {0xba, 0}}, {{0x3b, 0}, {0xbb, 0}},
		{{0x3c, 0}, {0xbc, 0}}, {{0x3d, 0}, {0xbd, 0}}, {{0x3e, 0}, {0xbe, 0}}, {{0x3f, 0}, {0xbf, 0}},
		{{0x40, 0}, {0xc0, 0}}, {{0x41, 0}, {0xc1, 0}}, {{0x42, 0}, {0xc2, 0}}, {{0x43, 0}, {0xc3, 0}},
		{{0x44, 0}, {0xc4, 0}}, {{0x45, 0}, {0xc5, 0}}, {{0x46, 0}, {0xc6, 0}}, {{0x47, 0}, {0xc7, 0}},
		{{0x48, 0}, {0xc8, 0}}, {{0x49, 0}, {0xc9, 0}}, {{0x4a, 0}, {0xca, 0}}, {{0x4b, 0}, {0xcb, 0}},
		{{0x4c, 0}, {0xcc, 0}}, {{0x4d, 0}, {0xcd, 0}}, {{0x4e, 0}, {0xce, 0}}, {{0x4f, 0}, {0xcf, 0}},
		{{0x50, 0}, {0xd0, 0}}, {{0x51, 0}, {0xd1, 0}}, {{0x52, 0}, {0xd2, 0}}, {{0x53, 0}, {0xd3, 0}},
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*54*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*58*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*5c*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*60*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*64*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*68*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*6c*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*70*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*74*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*78*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*7c*/

		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*80*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*84*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*88*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*8c*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*90*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*94*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*98*/
		{{0x1c, 0}, {0x9c, 0}}, {{0x1d, 0}, {0x9d, 0}}, {{0}, {0}}, {{0}, {0}},             /*9c*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*a0*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*a4*/
		{{0}, {0}}, {{0}, {0}}, {{0x2a, 0}, {0xaa, 0}}, {{0}, {0}},             /*a8*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*ac*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*b0*/
		{{0}, {0}}, {{0x35, 0}, {0xb5, 0}}, {{0x36, 0}, {0xb6, 0}}, {{0x37, 0}, {0xb7, 0}}, /*b4*/
		{{0x38, 0}, {0xb8, 0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*b8*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*bc*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*c0*/
		{{0}, {0}}, {{0}, {0}}, {{0x46, 0}, {0xc6, 0}}, {{0x47, 0}, {0xc7, 0}}, /*c4*/
		{{0x48, 0}, {0xc8, 0}}, {{0x49, 0}, {0xc9, 0}}, {{0}, {0}}, {{0x4b, 0}, {0xcb, 0}}, /*c8*/
		{{0}, {0}}, {{0x4d, 0}, {0xcd, 0}}, {{0}, {0}}, {{0x4f, 0}, {0xcf, 0}}, /*cc*/
		{{0x50, 0}, {0xd0, 0}}, {{0x51, 0}, {0xd1, 0}}, {{0x52, 0}, {0xd2, 0}}, {{0x53, 0}, {0xd3, 0}}, /*d0*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*d4*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*d8*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*dc*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*e0*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*e4*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*e8*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*ec*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*f0*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*f4*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*f8*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*fc*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*100*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*104*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*108*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*10c*/
	};

/*Tandy keyboard has slightly different scancodes to XT*/
static scancode scancode_tandy[272] =
	{
		{{0}, {0}}, {{0x01, 0}, {0x81, 0}}, {{0x02, 0}, {0x82, 0}}, {{0x03, 0}, {0x83, 0}},
		{{0x04, 0}, {0x84, 0}}, {{0x05, 0}, {0x85, 0}}, {{0x06, 0}, {0x86, 0}}, {{0x07, 0}, {0x87, 0}},
		{{0x08, 0}, {0x88, 0}}, {{0x09, 0}, {0x89, 0}}, {{0x0a, 0}, {0x8a, 0}}, {{0x0b, 0}, {0x8b, 0}},
		{{0x0c, 0}, {0x8c, 0}}, {{0x0d, 0}, {0x8d, 0}}, {{0x0e, 0}, {0x8e, 0}}, {{0x0f, 0}, {0x8f, 0}},
		{{0x10, 0}, {0x90, 0}}, {{0x11, 0}, {0x91, 0}}, {{0x12, 0}, {0x92, 0}}, {{0x13, 0}, {0x93, 0}},
		{{0x14, 0}, {0x94, 0}}, {{0x15, 0}, {0x95, 0}}, {{0x16, 0}, {0x96, 0}}, {{0x17, 0}, {0x97, 0}},
		{{0x18, 0}, {0x98, 0}}, {{0x19, 0}, {0x99, 0}}, {{0x1a, 0}, {0x9a, 0}}, {{0x1b, 0}, {0x9b, 0}},
		{{0x1c, 0}, {0x9c, 0}}, {{0x1d, 0}, {0x9d, 0}}, {{0x1e, 0}, {0x9e, 0}}, {{0x1f, 0}, {0x9f, 0}},
		{{0x20, 0}, {0xa0, 0}}, {{0x21, 0}, {0xa1, 0}}, {{0x22, 0}, {0xa2, 0}}, {{0x23, 0}, {0xa3, 0}},
		{{0x24, 0}, {0xa4, 0}}, {{0x25, 0}, {0xa5, 0}}, {{0x26, 0}, {0xa6, 0}}, {{0x27, 0}, {0xa7, 0}},
		{{0x28, 0}, {0xa8, 0}}, {{0x29, 0}, {0xa9, 0}}, {{0x2a, 0}, {0xaa, 0}}, {{0x47, 0}, {0xc7, 0}},
		{{0x2c, 0}, {0xac, 0}}, {{0x2d, 0}, {0xad, 0}}, {{0x2e, 0}, {0xae, 0}}, {{0x2f, 0}, {0xaf, 0}},
		{{0x30, 0}, {0xb0, 0}}, {{0x31, 0}, {0xb1, 0}}, {{0x32, 0}, {0xb2, 0}}, {{0x33, 0}, {0xb3, 0}},
		{{0x34, 0}, {0xb4, 0}}, {{0x35, 0}, {0xb5, 0}}, {{0x36, 0}, {0xb6, 0}}, {{0x37, 0}, {0xb7, 0}},
		{{0x38, 0}, {0xb8, 0}}, {{0x39, 0}, {0xb9, 0}}, {{0x3a, 0}, {0xba, 0}}, {{0x3b, 0}, {0xbb, 0}},
		{{0x3c, 0}, {0xbc, 0}}, {{0x3d, 0}, {0xbd, 0}}, {{0x3e, 0}, {0xbe, 0}}, {{0x3f, 0}, {0xbf, 0}},
		{{0x40, 0}, {0xc0, 0}}, {{0x41, 0}, {0xc1, 0}}, {{0x42, 0}, {0xc2, 0}}, {{0x43, 0}, {0xc3, 0}},
		{{0x44, 0}, {0xc4, 0}}, {{0x45, 0}, {0xc5, 0}}, {{0x46, 0}, {0xc6, 0}}, {{0x47, 0}, {0xc7, 0}},
		{{0x48, 0}, {0xc8, 0}}, {{0x49, 0}, {0xc9, 0}}, {{0x4a, 0}, {0xca, 0}}, {{0x4b, 0}, {0xcb, 0}},
		{{0x4c, 0}, {0xcc, 0}}, {{0x4d, 0}, {0xcd, 0}}, {{0x4e, 0}, {0xce, 0}}, {{0x4f, 0}, {0xcf, 0}},
		{{0x50, 0}, {0xd0, 0}}, {{0x51, 0}, {0xd1, 0}}, {{0x52, 0}, {0xd2, 0}}, {{0x56, 0}, {0xd6, 0}},
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*54*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*58*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*5c*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*60*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*64*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*68*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*6c*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*70*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*74*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*78*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*7c*/

		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*80*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*84*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*88*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*8c*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*90*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*94*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*98*/
		{{0x57, 0}, {0xd7, 0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*9c*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*a0*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*a4*/
		{{0}, {0}}, {{0}, {0}}, {{0x2a, 0}, {0xaa, 0}}, {{0}, {0}},             /*a8*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*ac*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*b0*/
		{{0}, {0}}, {{0x35, 0}, {0xb5, 0}}, {{0x36, 0}, {0xb6, 0}}, {{0x37, 0}, {0xb7, 0}}, /*b4*/
		{{0x38, 0}, {0xb8, 0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*b8*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*bc*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*c0*/
		{{0}, {0}}, {{0}, {0}}, {{0x46, 0}, {0xc6, 0}}, {{0x47, 0}, {0xc7, 0}}, /*c4*/
		{{0x29, 0}, {0xa9, 0}}, {{0x49, 0}, {0xc9, 0}}, {{0}, {0}}, {{0x2b, 0}, {0xab, 0}}, /*c8*/
		{{0}, {0}}, {{0x4e, 0}, {0xce, 0}}, {{0}, {0}}, {{0x4f, 0}, {0xcf, 0}}, /*cc*/
		{{0x4a, 0}, {0xca, 0}}, {{0x51, 0}, {0xd1, 0}}, {{0x52, 0}, {0xd2, 0}}, {{0x53, 0}, {0xd3, 0}}, /*d0*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*d4*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*d8*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*dc*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*e0*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*e4*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*e8*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*ec*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*f0*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*f4*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*f8*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*fc*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*100*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*104*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*108*/
		{{0}, {0}}, {{0}, {0}}, {{0}, {0}}, {{0}, {0}},             /*10c*/
	};
static uint8_t oldkey[272];
static uint8_t keydelay[272];

void (*keyboard_send)(uint8_t val);
void (*keyboard_poll)();
int keyboard_scan = 1;

static scancode *at_scancodes;

void keyboard_set_scancode_set(int set) {
	switch (set) {
	case SCANCODE_SET_1:at_scancodes = scancode_set1;
		break;
	case SCANCODE_SET_2:at_scancodes = scancode_set2;
		break;
	case SCANCODE_SET_3:at_scancodes = scancode_set3;
		break;
	default:pclog("Invalid scancode set: %i\n", set);
	}
}

void keyboard_process() {
	int c;
	int d;
	scancode *scancodes = (AT || romset == ROM_XI8088) ? at_scancodes : scancode_xt;
	if (!keyboard_scan)
		return;
	if (TANDY)
		scancodes = scancode_tandy;

	for (c = 0; c < 272; c++) {
		if (pcem_key[c])
			keydelay[c]++;
		else
			keydelay[c] = 0;
	}

	for (c = 0; c < 272; c++) {
		if (pcem_key[c] != oldkey[c]) {
			oldkey[c] = pcem_key[c];
			if (pcem_key[c] && scancodes[c].scancodes_make[0] == 0)
				continue;
			if (!pcem_key[c] && scancodes[c].scancodes_break[0] == 0)
				continue;
//                        pclog("Key %02X start\n", c);
			d = 0;
			if (pcem_key[c]) {
				while (scancodes[c].scancodes_make[d] != 0)
					keyboard_send(scancodes[c].scancodes_make[d++]);
			} else {
				while (scancodes[c].scancodes_break[d] != 0)
					keyboard_send(scancodes[c].scancodes_break[d++]);
			}
		}
	}

	for (c = 0; c < 272; c++) {
		if (keydelay[c] >= 30) {
			keydelay[c] -= 10;
			if (scancodes[c].scancodes_make[0] == 0)
				continue;

			d = 0;

			while (scancodes[c].scancodes_make[d] != 0)
				keyboard_send(scancodes[c].scancodes_make[d++]);
		}
	}
}

void keyboard_send_scancode(int code, int is_break) {
	scancode *scancodes = (AT || romset == ROM_XI8088) ? at_scancodes : scancode_xt;
	int d = 0;

	if (!keyboard_scan)
		return;

	if (!is_break) {
		while (scancodes[code].scancodes_make[d] != 0)
			keyboard_send(scancodes[code].scancodes_make[d++]);
	} else {
		while (scancodes[code].scancodes_break[d] != 0)
			keyboard_send(scancodes[code].scancodes_break[d++]);
	}
}
