/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.google.inject.Inject;
import java.io.File;
import java.util.Date;
import org.limewire.bittorrent.Torrent;
import org.limewire.bittorrent.TorrentManager;
import org.limewire.bittorrent.TorrentPeer;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;

public class TorrentDHTScheduler
implements Runnable {
    private static final Log LOG = LogFactory.getLog(TorrentDHTScheduler.class);
    private static final String LAST_DHT_START_TIME = "lastDHTStartTime";
    private static final String DHT_ENABLED = "dhtEnabled";
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private final TorrentManager torrentManager;

    @Inject
    public TorrentDHTScheduler(TorrentManager torrentManager) {
        this.torrentManager = torrentManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Running DHT Checks: {0}", (Object)new Date());
        }
        this.torrentManager.getLock().lock();
        try {
            boolean dhtStarted = this.torrentManager.isDHTStarted();
            boolean dhtEnabled = false;
            for (Torrent torrent : this.torrentManager.getTorrents()) {
                if (this.dhtEnabled(torrent) && this.shouldDisableDHT(torrent)) {
                    torrent.setProperty(DHT_ENABLED, Boolean.FALSE);
                    dhtEnabled |= false;
                    LOG.debugf("Disabling DHT for torrent: {0}", (Object)torrent.getName());
                    continue;
                }
                if (this.needsDHTConnections(torrent) && this.shouldTryDHT(torrent)) {
                    torrent.setProperty(LAST_DHT_START_TIME, new Long(System.currentTimeMillis()));
                    torrent.setProperty(DHT_ENABLED, Boolean.TRUE);
                    dhtEnabled |= true;
                    LOG.debugf("Enabling DHT for torrent: {0}", (Object)torrent.getName());
                    continue;
                }
                if (this.dhtEnabled(torrent)) {
                    dhtEnabled |= true;
                    LOG.debugf("Keeping DHT Enabled for torrent: {0}", (Object)torrent.getName());
                    continue;
                }
                LOG.debugf("Keeping DHT Disabled for torrent: {0}", (Object)torrent.getName());
            }
            File dhtStateFile = this.torrentManager.getTorrentManagerSettings().getDHTStateFile();
            if (!dhtStarted && dhtEnabled) {
                this.torrentManager.startDHT(dhtStateFile);
                LOG.debugf("DHT Started", new Object[0]);
            } else if (dhtStarted && !dhtEnabled) {
                this.torrentManager.saveDHTState(dhtStateFile);
                this.torrentManager.stopDHT();
                LOG.debugf("DHT Stopped", new Object[0]);
            } else if (LOG.isDebugEnabled()) {
                LOG.debugf("DHT Kept: {0}", (Object)(dhtStarted ? "on" : "off"));
            }
        }
        finally {
            this.torrentManager.getLock().unlock();
        }
    }

    private boolean dhtEnabled(Torrent torrent) {
        Boolean dhtEnabled = torrent.getProperty(DHT_ENABLED, Boolean.FALSE);
        return dhtEnabled;
    }

    private boolean shouldDisableDHT(Torrent torrent) {
        long runningTimeOfTorrent = this.getTorrentRunningTime(torrent);
        if (!torrent.isStarted() || torrent.isFinished() || torrent.isPrivate() || runningTimeOfTorrent < 60000L) {
            return true;
        }
        Long lastDHTStartTime = torrent.getProperty(LAST_DHT_START_TIME, null);
        if (this.dhtEnabled(torrent) && lastDHTStartTime != null) {
            long runningTimeMillis = this.getTimeSinceLastDHTStartForTorrent(lastDHTStartTime);
            long runningTimeMinutes = runningTimeMillis / 60000L;
            if (LOG.isDebugEnabled()) {
                LOG.debugf("DHT Running for torrent: {0} for {1} minutes.", (Object)torrent.getName(), (Object)runningTimeMinutes);
            }
            if (runningTimeMinutes > 30L) {
                return true;
            }
            if (runningTimeMinutes % 5L == 0L) {
                int numDHTNonTrackerPeers = 0;
                int numTotalPeers = 0;
                int numNonDHTPeers = 0;
                for (TorrentPeer peer : torrent.getTorrentPeers()) {
                    ++numTotalPeers;
                    if (peer.isFromDHT() && !peer.isFromTracker()) {
                        ++numDHTNonTrackerPeers;
                        continue;
                    }
                    ++numNonDHTPeers;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debugf("Torrent: {0} has {1} total peers.", (Object)torrent.getName(), (Object)numTotalPeers);
                    LOG.debugf("Torrent: {0} has {1} DHT non tracker peers.", (Object)torrent.getName(), (Object)numDHTNonTrackerPeers);
                    LOG.debugf("Torrent: {0} has {1} non DHT peers.", (Object)torrent.getName(), (Object)numNonDHTPeers);
                }
                return numTotalPeers > 0 && (double)((float)numNonDHTPeers / (float)numTotalPeers) > 0.5;
            }
        }
        return false;
    }

    private boolean shouldTryDHT(Torrent torrent) {
        Boolean dhtEnabled = torrent.getProperty(DHT_ENABLED, null);
        Long lastDHTStartTime = torrent.getProperty(LAST_DHT_START_TIME, null);
        if (dhtEnabled == null || lastDHTStartTime == null) {
            return true;
        }
        long timeSinceLastDHTStart = this.getTimeSinceLastDHTStartForTorrent(lastDHTStartTime);
        return timeSinceLastDHTStart > 3600000L;
    }

    private boolean needsDHTConnections(Torrent torrent) {
        if (!torrent.isPaused()) {
            return torrent.getNumConnections() < 5;
        }
        return false;
    }

    private long getTimeSinceLastDHTStartForTorrent(Long lastDHTStartTime) {
        long timeSinceLastDHTStart = System.currentTimeMillis() - lastDHTStartTime;
        return timeSinceLastDHTStart;
    }

    private long getTorrentRunningTime(Torrent torrent) {
        long runningTimeOfTorrent = System.currentTimeMillis() - torrent.getStartTime();
        return runningTimeOfTorrent;
    }
}

