/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Provider;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.limewire.io.GUID;

public class BypassedResultsCache {
    static int MAX_BYPASSED_RESULTS = 150;
    private final Provider<? extends ActivityCallback> _callback;
    private final DownloadManager _downloadManager;
    private final Map<GUID, Set<GUESSEndpoint>> _bypassedResults = Collections.synchronizedMap(new HashMap());

    public BypassedResultsCache(Provider<? extends ActivityCallback> callback, DownloadManager downloadManager) {
        this._callback = callback;
        this._downloadManager = downloadManager;
    }

    void queryKilled(GUID guid) {
        if (!this._downloadManager.isGuidForQueryDownloading(guid)) {
            this._bypassedResults.remove(guid);
        }
    }

    void downloadFinished(GUID guid) {
        if (!this.isGUIDOfInterest(guid)) {
            this._bypassedResults.remove(guid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<GUESSEndpoint> getQueryLocs(GUID guid) {
        HashSet<GUESSEndpoint> clone = new HashSet<GUESSEndpoint>();
        Map<GUID, Set<GUESSEndpoint>> map = this._bypassedResults;
        synchronized (map) {
            Set<GUESSEndpoint> eps = this._bypassedResults.get(guid);
            if (eps != null) {
                clone.addAll(eps);
            }
        }
        return clone;
    }

    private boolean isGUIDOfInterest(GUID guid) {
        return this._callback.get().isQueryAlive(guid) || this._downloadManager.isGuidForQueryDownloading(guid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addBypassedSource(GUID guid, GUESSEndpoint endpoint) {
        if (!this.isGUIDOfInterest(guid)) {
            return false;
        }
        Map<GUID, Set<GUESSEndpoint>> map = this._bypassedResults;
        synchronized (map) {
            Set<GUESSEndpoint> eps = this._bypassedResults.get(guid);
            if (eps == null) {
                eps = new HashSet<GUESSEndpoint>();
                this._bypassedResults.put(guid, eps);
            }
            if (eps.size() < MAX_BYPASSED_RESULTS) {
                return eps.add(endpoint);
            }
            return false;
        }
    }
}

