/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.BandwidthCollectorDriver;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.NodeAssigner;
import com.limegroup.gnutella.SearchServices;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.statistics.TcpBandwidthStatistics;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.core.settings.ApplicationSettings;
import org.limewire.core.settings.ConnectionSettings;
import org.limewire.core.settings.DHTSettings;
import org.limewire.core.settings.UltrapeerSettings;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.util.OSUtils;

@EagerSingleton
class NodeAssignerImpl
implements NodeAssigner,
Service {
    private static final Log LOG = LogFactory.getLog(NodeAssignerImpl.class);
    private static final boolean ULTRAPEER_OS = OSUtils.isHighLoadOS();
    static final int TIMER_DELAY = 1000;
    private long startTime = 0L;
    private volatile boolean _isTooGoodUltrapeerToPassUp = false;
    private volatile long _lastUltrapeerAttempt = 0L;
    private int _ultrapeerTries = 0;
    private boolean _isHardcoreCapable;
    private ScheduledFuture<?> timer;
    private final Provider<ConnectionManager> connectionManager;
    private final NetworkManager networkManager;
    private final SearchServices searchServices;
    private final Provider<DHTManager> dhtManager;
    private final ScheduledExecutorService backgroundExecutor;
    private final Executor unlimitedExecutor;
    private final ConnectionServices connectionServices;
    private final TcpBandwidthStatistics tcpBandwidthStatistics;
    private final NetworkInstanceUtils networkInstanceUtils;
    private final BandwidthCollectorDriver bandwidthCollector;

    @Inject
    public NodeAssignerImpl(Provider<ConnectionManager> connectionManager, NetworkManager networkManager, SearchServices searchServices, Provider<DHTManager> dhtManager, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, @Named(value="unlimitedExecutor") Executor unlimitedExecutor, ConnectionServices connectionServices, TcpBandwidthStatistics tcpBandwidthStatistics, NetworkInstanceUtils networkInstanceUtils, BandwidthCollectorDriver bandwidthCollector) {
        this.connectionManager = connectionManager;
        this.networkManager = networkManager;
        this.searchServices = searchServices;
        this.dhtManager = dhtManager;
        this.backgroundExecutor = backgroundExecutor;
        this.connectionServices = connectionServices;
        this.unlimitedExecutor = unlimitedExecutor;
        this.tcpBandwidthStatistics = tcpBandwidthStatistics;
        this.networkInstanceUtils = networkInstanceUtils;
        this.bandwidthCollector = bandwidthCollector;
    }

    @Override
    public void start() {
        this.startTime = System.currentTimeMillis();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                NodeAssignerImpl.this.bandwidthCollector.collectBandwidthData();
                NodeAssignerImpl.this.setHardcoreCapable();
                NodeAssignerImpl.this.assignUltrapeerNode();
                NodeAssignerImpl.this.assignDHTMode();
            }
        };
        this.timer = this.backgroundExecutor.scheduleWithFixedDelay(task, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        if (this.timer != null) {
            this.timer.cancel(true);
        }
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("Ultrapeer/DHT Management");
    }

    @Override
    public void initialize() {
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    private void setHardcoreCapable() {
        int maxUpstreamKiloBytesPerSec = this.bandwidthCollector.getMaxMeasuredTotalUploadBandwidth();
        int maxDownstreamKiloBytesPerSec = this.bandwidthCollector.getMaxMeasuredTotalDownloadBandwidth();
        boolean bl = this._isHardcoreCapable = (maxUpstreamKiloBytesPerSec >= UltrapeerSettings.MIN_UPSTREAM_REQUIRED.getValue() || maxDownstreamKiloBytesPerSec >= UltrapeerSettings.MIN_DOWNSTREAM_REQUIRED.getValue()) && ConnectionSettings.EVER_ACCEPTED_INCOMING.getValue() && ULTRAPEER_OS && !this.networkInstanceUtils.isPrivate();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Hardcore capable: " + this._isHardcoreCapable);
        }
        if (!this._isHardcoreCapable && LOG.isTraceEnabled()) {
            if (maxUpstreamKiloBytesPerSec < UltrapeerSettings.MIN_UPSTREAM_REQUIRED.getValue()) {
                LOG.trace("not enough upstream: " + maxUpstreamKiloBytesPerSec);
            }
            if (maxDownstreamKiloBytesPerSec < UltrapeerSettings.MIN_DOWNSTREAM_REQUIRED.getValue()) {
                LOG.trace("not enough downstream: " + maxDownstreamKiloBytesPerSec);
            }
            if (!ConnectionSettings.EVER_ACCEPTED_INCOMING.getValue()) {
                LOG.trace("not accepted incoming ever");
            }
            if (!ULTRAPEER_OS) {
                LOG.trace("not an ultrapeer os");
            }
            if (this.networkInstanceUtils.isPrivate()) {
                LOG.trace("private address: " + NetworkUtils.ip2string(this.networkManager.getAddress()));
            }
        }
    }

    private void assignUltrapeerNode() {
        boolean isUltrapeerCapable;
        if (UltrapeerSettings.DISABLE_ULTRAPEER_MODE.getValue()) {
            LOG.debug("Ultrapeer mode disabled");
            UltrapeerSettings.EVER_ULTRAPEER_CAPABLE.setValue(false);
            return;
        }
        if (this.connectionServices.isSupernode()) {
            LOG.debug("Already an ultrapeer, exiting");
            return;
        }
        boolean avgUptimePasses = ApplicationSettings.AVERAGE_UPTIME.getValue() >= (long)UltrapeerSettings.MIN_AVG_UPTIME.getValue();
        boolean curUptimePasses = this.getCurrentUptime() >= (long)UltrapeerSettings.MIN_INITIAL_UPTIME.getValue();
        boolean uptimePasses = avgUptimePasses | curUptimePasses;
        boolean bl = isUltrapeerCapable = this._isHardcoreCapable && uptimePasses && this.networkManager.isGUESSCapable();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Node is ultrapeer capable: " + isUltrapeerCapable + "(hc: " + this._isHardcoreCapable + ", up: " + uptimePasses + ", gc: " + this.networkManager.isGUESSCapable());
        }
        long curTime = System.currentTimeMillis();
        boolean bl2 = this._isTooGoodUltrapeerToPassUp = isUltrapeerCapable && this.networkManager.acceptedIncomingConnection() && curTime - this.searchServices.getLastQueryTime() > 300000L && this.tcpBandwidthStatistics.getAverageHttpUpstream() < 1.0;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Node is " + (this._isTooGoodUltrapeerToPassUp ? "" : "NOT") + " to good to pass up");
        }
        if (isUltrapeerCapable) {
            UltrapeerSettings.EVER_ULTRAPEER_CAPABLE.setValue(true);
        }
        if (this._isTooGoodUltrapeerToPassUp && this.shouldTryToBecomeAnUltrapeer(curTime) && this.switchFromActiveDHTNodeToUltrapeer()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Node WILL try to become an ultrapeer");
            }
            ++this._ultrapeerTries;
            final int demotes = 4 * this._ultrapeerTries;
            Runnable ultrapeerRunner = new Runnable(){

                @Override
                public void run() {
                    ((ConnectionManager)NodeAssignerImpl.this.connectionManager.get()).tryToBecomeAnUltrapeer(demotes);
                }
            };
            this.unlimitedExecutor.execute(ultrapeerRunner);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Node will not try to become an ultrapeer");
        }
    }

    private boolean shouldTryToBecomeAnUltrapeer(long curTime) {
        if (curTime - this._lastUltrapeerAttempt < (long)UltrapeerSettings.UP_RETRY_TIME.getValue()) {
            return false;
        }
        this._lastUltrapeerAttempt = curTime;
        return true;
    }

    private boolean switchFromActiveDHTNodeToUltrapeer() {
        if (this.dhtManager.get().getDHTMode() != DHTManager.DHTMode.ACTIVE) {
            return true;
        }
        if (DHTSettings.EXCLUDE_ULTRAPEERS.getValue() && this.acceptUltrapeer()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Randomly switching from DHT node to ultrapeer!");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isTooGoodUltrapeerToPassUp() {
        return this._isTooGoodUltrapeerToPassUp;
    }

    private DHTManager.DHTMode assignDHTMode() {
        DHTManager.DHTMode current = this.dhtManager.get().getDHTMode();
        assert (current != null) : "Current DHTMode is null, fix your DHTManager-Stub!";
        DHTManager.DHTMode mode = DHTManager.DHTMode.INACTIVE;
        if (!this.dhtManager.get().isEnabled()) {
            if (current != mode) {
                this.switchDHTMode(current, mode);
            }
            return mode;
        }
        boolean isUltrapeer = this.connectionServices.isActiveSuperNode();
        if (isUltrapeer && this.isPassiveDHTCapable()) {
            mode = DHTManager.DHTMode.PASSIVE;
        }
        if (!isUltrapeer || !DHTSettings.EXCLUDE_ULTRAPEERS.getValue()) {
            assert (DHTSettings.MIN_ACTIVE_DHT_INITIAL_UPTIME.getValue() / 1000L > (long)UltrapeerSettings.MIN_CONNECT_TIME.getValue()) : "Wrong minimum initial uptime";
            long averageTime = Math.max(this.connectionManager.get().getCurrentAverageUptime(), ApplicationSettings.AVERAGE_CONNECTION_TIME.getValue());
            boolean passiveCapable = this.isPassiveLeafDHTCapable();
            boolean activeCapable = this.isActiveDHTCapable();
            if (LOG.isDebugEnabled()) {
                long currentUptime = this.getCurrentUptime();
                if (passiveCapable && !activeCapable) {
                    LOG.debug("Node is passive DHT capable\n average time: " + averageTime + "\n currentUptime: " + currentUptime);
                } else if (activeCapable) {
                    LOG.debug("Node is active DHT capable\n average time: " + averageTime + "\n currentUptime: " + currentUptime);
                } else {
                    LOG.debug("Node is NOT DHT capable\n average time: " + averageTime + "\n currentUptime: " + currentUptime);
                }
            }
            if (passiveCapable && !isUltrapeer) {
                mode = DHTManager.DHTMode.PASSIVE_LEAF;
            }
            if (activeCapable) {
                mode = DHTManager.DHTMode.ACTIVE;
            }
        }
        if (mode == DHTManager.DHTMode.PASSIVE && !DHTSettings.ENABLE_PASSIVE_DHT_MODE.getValue()) {
            mode = DHTManager.DHTMode.INACTIVE;
        } else if (mode == DHTManager.DHTMode.PASSIVE_LEAF && !DHTSettings.ENABLE_PASSIVE_LEAF_DHT_MODE.getValue()) {
            mode = DHTManager.DHTMode.INACTIVE;
        }
        if (DHTSettings.FORCE_DHT_CONNECT.getValue()) {
            mode = DHTManager.DHTMode.ACTIVE;
        }
        if (mode != current && (isUltrapeer || this.acceptDHTNode()) || current != DHTManager.DHTMode.INACTIVE && mode == DHTManager.DHTMode.INACTIVE) {
            this.switchDHTMode(current, mode);
        }
        return mode;
    }

    private void switchDHTMode(DHTManager.DHTMode from, final DHTManager.DHTMode to) {
        Runnable init = new Runnable(){

            @Override
            public void run() {
                if (to != DHTManager.DHTMode.INACTIVE) {
                    ((DHTManager)NodeAssignerImpl.this.dhtManager.get()).start(to);
                } else {
                    ((DHTManager)NodeAssignerImpl.this.dhtManager.get()).stop();
                }
                DHTSettings.DHT_MODE.set(to.toString());
            }
        };
        this.unlimitedExecutor.execute(init);
    }

    private boolean isPassiveDHTCapable() {
        long averageTime = this.getAverageTime();
        return ULTRAPEER_OS && averageTime >= DHTSettings.MIN_PASSIVE_DHT_AVERAGE_UPTIME.getValue() && this.getCurrentUptime() >= DHTSettings.MIN_PASSIVE_DHT_INITIAL_UPTIME.getValue() / 1000L && this.networkManager.canReceiveSolicited();
    }

    private boolean isPassiveLeafDHTCapable() {
        long averageTime = this.getAverageTime();
        return ULTRAPEER_OS && averageTime >= DHTSettings.MIN_PASSIVE_LEAF_DHT_AVERAGE_UPTIME.getValue() && this.getCurrentUptime() >= DHTSettings.MIN_PASSIVE_LEAF_DHT_INITIAL_UPTIME.getValue() / 1000L && this.networkManager.canReceiveSolicited();
    }

    private boolean isActiveDHTCapable() {
        long averageTime = this.getAverageTime();
        if (!this._isHardcoreCapable) {
            LOG.trace("not hardcore capable");
            return false;
        }
        if (averageTime < DHTSettings.MIN_ACTIVE_DHT_AVERAGE_UPTIME.getValue()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("not long enough average uptime: " + averageTime);
            }
            return false;
        }
        long currentUptime = this.getCurrentUptime();
        if (currentUptime < DHTSettings.MIN_ACTIVE_DHT_INITIAL_UPTIME.getValue() / 1000L) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("not long enough current uptime: " + currentUptime);
            }
            return false;
        }
        if (!this.networkManager.isGUESSCapable()) {
            LOG.trace("not guess capable: can't receive both unsolicted and solicted udp");
            return false;
        }
        return true;
    }

    private long getAverageTime() {
        return Math.max(this.connectionManager.get().getCurrentAverageUptime(), ApplicationSettings.AVERAGE_CONNECTION_TIME.getValue());
    }

    private boolean acceptDHTNode() {
        return Math.random() < (double)DHTSettings.DHT_ACCEPT_PROBABILITY.getValue();
    }

    private boolean acceptUltrapeer() {
        return Math.random() < (double)DHTSettings.SWITCH_TO_ULTRAPEER_PROBABILITY.getValue();
    }

    private long getCurrentUptime() {
        if (this.startTime == 0L) {
            return 0L;
        }
        return (System.currentTimeMillis() - this.startTime) / 1000L;
    }
}

