/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointCache;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.PushEndpointImpl;
import com.limegroup.gnutella.SelfEndpoint;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.messages.BadPacketException;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Set;
import java.util.StringTokenizer;
import org.limewire.collection.BitNumbers;
import org.limewire.io.Connectable;
import org.limewire.io.GUID;
import org.limewire.io.InvalidDataException;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;

@Singleton
public class PushEndpointFactoryImpl
implements PushEndpointFactory {
    private static final Log LOG = LogFactory.getLog(PushEndpointFactoryImpl.class);
    private final Provider<PushEndpointCache> pushEndpointCache;
    private final Provider<SelfEndpoint> selfProvider;
    private final NetworkInstanceUtils networkInstanceUtils;
    private final Provider<IPFilter> hostileFilter;

    @Inject
    public PushEndpointFactoryImpl(Provider<PushEndpointCache> pushEndpointCache, Provider<SelfEndpoint> selfProvider, NetworkInstanceUtils networkInstanceUtils, @Named(value="hostileFilter") Provider<IPFilter> hostileFilter) {
        this.pushEndpointCache = pushEndpointCache;
        this.selfProvider = selfProvider;
        this.networkInstanceUtils = networkInstanceUtils;
        this.hostileFilter = hostileFilter;
    }

    @Override
    public PushEndpoint createPushEndpoint(byte[] guid) {
        return this.createPushEndpoint(guid, IpPort.EMPTY_SET);
    }

    @Override
    public PushEndpoint createPushEndpoint(byte[] guid, Set<? extends IpPort> proxies) {
        return this.createPushEndpoint(guid, proxies, (byte)0, 0);
    }

    @Override
    public PushEndpoint createPushEndpoint(byte[] guid, Set<? extends IpPort> proxies, byte features, int version) {
        return this.createPushEndpoint(guid, proxies, features, version, null);
    }

    @Override
    public PushEndpoint createPushEndpoint(byte[] guid, Set<? extends IpPort> proxies, byte features, int version, IpPort addr) {
        return new PushEndpointImpl(guid, proxies, features, version, addr, this.pushEndpointCache.get(), this.networkInstanceUtils);
    }

    @Override
    public PushEndpoint createPushEndpoint(String httpString) throws IOException {
        byte[] guid;
        if (httpString.length() < 32 || httpString.indexOf(";") > 32) {
            throw new IOException("http string does not contain valid guid");
        }
        String guidS = httpString.substring(0, 32);
        httpString = httpString.substring(32);
        try {
            guid = GUID.fromHexString(guidS);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException(iae.getMessage());
        }
        StringTokenizer tok = new StringTokenizer(httpString, ";");
        IpPortSet proxies = new IpPortSet();
        int fwtVersion = 0;
        Object addr = null;
        BitNumbers tlsProxies = null;
        while (tok.hasMoreTokens()) {
            String current = tok.nextToken().trim();
            if (current.startsWith("fwt")) {
                fwtVersion = (int)HTTPUtils.parseFeatureToken(current);
                continue;
            }
            if (proxies.size() == 0 && current.startsWith("pptls")) {
                String value = HTTPUtils.parseValue(current);
                if (value == null) continue;
                try {
                    tlsProxies = new BitNumbers(value);
                    continue;
                }
                catch (IllegalArgumentException invalid) {
                    throw (IOException)new IOException().initCause(invalid);
                }
            }
            if (proxies.size() < 4) {
                boolean tlsCapable = tlsProxies != null && tlsProxies.isSet(proxies.size());
                try {
                    Connectable ipp = NetworkUtils.parseIpPort(current, tlsCapable);
                    if (this.isGoodPushProxy(ipp)) {
                        proxies.add(ipp);
                    }
                }
                catch (IOException ohWell) {
                    tlsProxies = null;
                }
            }
            if (addr != null) continue;
            try {
                IpPort ipp = NetworkUtils.parsePortIp(current);
                if (this.networkInstanceUtils.isPrivateAddress(ipp.getInetAddress())) continue;
                addr = ipp;
            }
            catch (IOException notBad) {}
        }
        if (addr == null || !this.networkInstanceUtils.isValidExternalIpPort((IpPort)addr) || addr.equals("1.1.1.1")) {
            fwtVersion = 0;
            addr = null;
        }
        return this.createPushEndpoint(guid, proxies, (byte)(proxies.size() | fwtVersion << 3), fwtVersion, (IpPort)addr);
    }

    @Override
    public PushEndpoint createFromBytes(DataInputStream dais) throws BadPacketException, IOException {
        byte[] guid = new byte[16];
        IpPortSet proxies = new IpPortSet();
        IpPort addr = null;
        byte header = (byte)(dais.read() & 0xFF);
        int number = header & 7;
        byte features = (byte)(header & 0xFFFFFFE0);
        byte version = (byte)((header & 0x18) >> 3);
        dais.readFully(guid);
        if (version > 0) {
            byte[] host = new byte[6];
            dais.readFully(host);
            try {
                addr = NetworkUtils.getIpPort(host, ByteOrder.LITTLE_ENDIAN);
            }
            catch (InvalidDataException ide) {
                throw new BadPacketException(ide);
            }
            if (addr.getAddress().equals("1.1.1.1")) {
                addr = null;
                version = 0;
            }
        }
        BitNumbers bn = null;
        if ((features & 0xFFFFFF80) != 0) {
            byte[] tlsIndexes = new byte[1];
            dais.readFully(tlsIndexes);
            bn = new BitNumbers(tlsIndexes);
        }
        byte[] tmp = new byte[6];
        for (int i = 0; i < number; ++i) {
            dais.readFully(tmp);
            try {
                boolean tlsCapable = bn != null && bn.isSet(i);
                Connectable ipp = NetworkUtils.getConnectable(tmp, ByteOrder.LITTLE_ENDIAN, tlsCapable);
                if (!this.isGoodPushProxy(ipp)) continue;
                proxies.add(ipp);
                continue;
            }
            catch (InvalidDataException ide) {
                throw new BadPacketException(ide);
            }
        }
        PushEndpoint pe = this.createPushEndpoint(guid, proxies, features, version, addr);
        return pe;
    }

    @Override
    public PushEndpoint createForSelf() {
        return this.selfProvider.get();
    }

    boolean isGoodPushProxy(Connectable connectable) {
        if (this.networkInstanceUtils.isPrivateAddress(connectable.getInetAddress())) {
            LOG.debugf("push proxy not public: {0}", (Object)connectable);
            return false;
        }
        if (!this.hostileFilter.get().allow(connectable)) {
            LOG.debugf("push proxy hostile: {0}", (Object)connectable);
            return false;
        }
        return true;
    }
}

