/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.inject.Inject;
import com.limegroup.gnutella.messages.QueryRequest;
import java.util.ArrayList;
import java.util.List;
import org.limewire.core.api.Category;
import org.limewire.core.api.file.CategoryManager;

public class QueryCategoryFilterer {
    private final CategoryManager categoryManager;

    @Inject
    public QueryCategoryFilterer(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public List<Category> getRequestedCategories(QueryRequest query) {
        if (query.desiresAll()) {
            return null;
        }
        ArrayList<Category> categories = new ArrayList<Category>();
        if (query.desiresLinuxOSXPrograms() || query.desiresWindowsPrograms()) {
            categories.add(Category.PROGRAM);
        }
        if (query.desiresDocuments()) {
            categories.add(Category.DOCUMENT);
        }
        if (query.desiresAudio()) {
            categories.add(Category.AUDIO);
        }
        if (query.desiresVideo()) {
            categories.add(Category.VIDEO);
        }
        if (query.desiresImages()) {
            categories.add(Category.IMAGE);
        }
        return categories;
    }

    public Predicate<String> getPredicateForQuery(QueryRequest query) {
        if (query.desiresAll()) {
            return Predicates.alwaysTrue();
        }
        ArrayList<Predicate<String>> predicates = new ArrayList<Predicate<String>>();
        if (query.desiresLinuxOSXPrograms()) {
            predicates.add(this.categoryManager.getOsxAndLinuxProgramsFilter());
        }
        if (query.desiresWindowsPrograms()) {
            predicates.add(this.categoryManager.getWindowsProgramsFilter());
        }
        if (query.desiresDocuments()) {
            predicates.add(this.categoryManager.getExtensionFilterForCategory(Category.DOCUMENT));
        }
        if (query.desiresAudio()) {
            predicates.add(this.categoryManager.getExtensionFilterForCategory(Category.AUDIO));
        }
        if (query.desiresVideo()) {
            predicates.add(this.categoryManager.getExtensionFilterForCategory(Category.VIDEO));
        }
        if (query.desiresImages()) {
            predicates.add(this.categoryManager.getExtensionFilterForCategory(Category.IMAGE));
        }
        return Predicates.or(predicates);
    }
}

