/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.DownloadServices;
import com.limegroup.gnutella.UploadServices;
import com.limegroup.gnutella.connection.ConnectionCheckerListener;
import com.limegroup.gnutella.connection.UDPConnectionChecker;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IOUtils;
import org.limewire.net.SocketsManager;
import org.limewire.nio.observer.ConnectObserver;
import org.limewire.util.OSUtils;

public class ConnectionChecker {
    private static final Log LOG = LogFactory.getLog(ConnectionChecker.class);
    private volatile boolean connected;
    private int unsuccessfulAttempts;
    private boolean triedSP2Workaround;
    private final ConnectionServices connectionServices;
    private final UploadServices uploadServices;
    private final SocketsManager socketsManager;
    private final AtomicInteger numWorkarounds;
    private final UDPConnectionChecker udpConnectionChecker;
    private final DownloadServices downloadServices;
    private final List<String> hostList;

    public ConnectionChecker(AtomicInteger numWorkarounds, String[] hosts, ConnectionServices connectionServices, UploadServices uploadServices, DownloadServices downloadServices, SocketsManager socketsManager, UDPConnectionChecker udpConnectionChecker) {
        this.numWorkarounds = numWorkarounds;
        this.hostList = new ArrayList<String>(Arrays.asList(hosts));
        this.connectionServices = connectionServices;
        this.uploadServices = uploadServices;
        this.downloadServices = downloadServices;
        this.socketsManager = socketsManager;
        this.udpConnectionChecker = udpConnectionChecker;
    }

    public synchronized void run(ConnectionCheckerListener connectionCheckerListener) {
        Collections.shuffle(this.hostList);
        for (String curHost : this.hostList) {
            this.connectToHost(curHost);
            if (this.connected) {
                LOG.debug("Connection exists.");
                if (this.triedSP2Workaround && !this.connectionServices.isConnected() && !this.connectionServices.isConnecting()) {
                    LOG.debug("Reconnecting RouterService");
                    this.connectionServices.connect();
                }
                connectionCheckerListener.connected();
                return;
            }
            if (this.unsuccessfulAttempts <= 2) continue;
            LOG.debug("Failed connection check more than twice.");
            if (this.triedSP2Workaround || !this.shouldTrySP2Workaround() || this.hasNoTransfers() && this.udpConnectionChecker.udpIsDead()) break;
            this.triedSP2Workaround = true;
            this.trySP2Workaround();
        }
        connectionCheckerListener.noInternetConnection();
    }

    boolean shouldTrySP2Workaround() {
        return OSUtils.isSocketChallengedWindows();
    }

    void trySP2Workaround() {
        this.connectionServices.disconnect();
        this.numWorkarounds.incrementAndGet();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.unsuccessfulAttempts = 0;
    }

    private boolean hasNoTransfers() {
        return !this.downloadServices.hasActiveDownloads() && !this.uploadServices.hasActiveUploads();
    }

    public boolean hasConnected() {
        return this.connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectToHost(String host) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking for connection with host: " + host);
        }
        try {
            Observer observer;
            InetAddress.getByName(host);
            Observer observer2 = observer = new Observer();
            synchronized (observer2) {
                Socket s = this.socketsManager.connect(new InetSocketAddress(host, 80), 6000, observer);
                LOG.debug("Waiting for callback...");
                try {
                    observer.wait(12000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!observer.hasResponse()) {
                    LOG.debug("No response!");
                    if (this.socketsManager.removeConnectObserver(observer)) {
                        LOG.debug("Removed observer");
                        ++this.unsuccessfulAttempts;
                        IOUtils.close(s);
                    }
                }
            }
        }
        catch (IOException bad) {
            LOG.debug("failed to resolve name", bad);
            ++this.unsuccessfulAttempts;
        }
    }

    private class Observer
    implements ConnectObserver {
        boolean response = false;

        private Observer() {
        }

        @Override
        public void handleIOException(IOException iox) {
        }

        @Override
        public synchronized void handleConnect(Socket socket) throws IOException {
            if (!this.response) {
                LOG.debug("Socket connected OK");
                this.response = true;
                ConnectionChecker.this.connected = true;
                this.notify();
                IOUtils.close(socket);
            }
        }

        @Override
        public synchronized void shutdown() {
            if (!this.response) {
                LOG.debug("Socket failed to connect");
                this.response = true;
                ConnectionChecker.this.unsuccessfulAttempts++;
                this.notify();
            }
        }

        public boolean hasResponse() {
            return this.response;
        }
    }
}

