/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.daap;

import com.google.inject.name.Named;
import de.kapsi.net.daap.DaapConfig;
import de.kapsi.net.daap.Library;
import de.kapsi.net.daap.nio.DaapConnectionNIO;
import de.kapsi.net.daap.nio.DaapServerNIO;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IOUtils;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.SocketFactory;
import org.limewire.nio.channel.ChannelReadObserver;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.channel.NIOMultiplexor;
import org.limewire.nio.observer.AcceptObserver;

public class LimeDaapServerNIO
extends DaapServerNIO {
    private static final Log LOG = LogFactory.getLog(LimeDaapServerNIO.class);
    private final Map<DaapConnectionNIO, DaapController> allConnections = new HashMap<DaapConnectionNIO, DaapController>();
    private ServerSocket serverSocket;
    private final ScheduledExecutorService backgroundExecutor;

    public LimeDaapServerNIO(Library library, DaapConfig config, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor) {
        super(library, config);
        this.backgroundExecutor = backgroundExecutor;
        this.scheduleServices();
    }

    private void scheduleServices() {
        this.backgroundExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        LimeDaapServerNIO limeDaapServerNIO = LimeDaapServerNIO.this;
                        synchronized (limeDaapServerNIO) {
                            if (!LimeDaapServerNIO.this.running) {
                                return;
                            }
                        }
                        LimeDaapServerNIO.this.processTimeout();
                    }
                });
            }
        }, 30000L, 30000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void bind() throws IOException {
        InetSocketAddress bindAddr = this.config.getInetSocketAddress();
        int backlog = this.config.getBacklog();
        this.serverSocket = SocketFactory.newServerSocket(new DaapDispatcher());
        this.serverSocket.setReuseAddress(false);
        try {
            this.serverSocket.bind(bindAddr, backlog);
        }
        catch (SocketException err) {
            throw new BindException(err.getMessage());
        }
    }

    @Override
    public synchronized void run() {
        this.running = true;
    }

    @Override
    protected void cancelConnection(final DaapConnectionNIO connection) {
        NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                SocketChannel channel = connection.getChannel();
                try {
                    channel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void disconnectAll() {
        NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (DaapConnectionNIO next : LimeDaapServerNIO.this.allConnections.keySet()) {
                    SocketChannel channel = next.getChannel();
                    try {
                        channel.close();
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                    LimeDaapServerNIO limeDaapServerNIO = LimeDaapServerNIO.this;
                    synchronized (limeDaapServerNIO) {
                        LimeDaapServerNIO.this.libraryQueue.clear();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.disconnectAll();
        LimeDaapServerNIO limeDaapServerNIO = this;
        synchronized (limeDaapServerNIO) {
            this.running = false;
        }
    }

    @Override
    protected void update() {
        NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LimeDaapServerNIO limeDaapServerNIO = LimeDaapServerNIO.this;
                synchronized (limeDaapServerNIO) {
                    for (DaapConnectionNIO connection : LimeDaapServerNIO.this.getDaapConnections()) {
                        for (Library aLibraryQueue : LimeDaapServerNIO.this.libraryQueue) {
                            connection.enqueueLibrary(aLibraryQueue);
                        }
                        SocketChannel channel = connection.getChannel();
                        try {
                            connection.update();
                            DaapController controller = (DaapController)LimeDaapServerNIO.this.allConnections.get(connection);
                            controller.setOps();
                        }
                        catch (IOException ignored) {
                            try {
                                channel.close();
                            }
                            catch (IOException ignoredToo) {}
                        }
                    }
                    LimeDaapServerNIO.this.libraryQueue.clear();
                }
            }
        });
    }

    @Override
    public synchronized boolean isRunning() {
        return this.running;
    }

    private class DaapController
    implements ChannelReadObserver,
    ChannelWriter {
        private DaapConnectionNIO conn;
        private InterestReadableByteChannel readChannel;
        private InterestWritableByteChannel writeChannel;
        private boolean shutdown;

        DaapController(DaapConnectionNIO dcn) {
            this.conn = dcn;
        }

        @Override
        public void handleRead() throws IOException {
            if (!this.conn.read()) {
                throw new IOException("finished");
            }
            this.setOps();
        }

        @Override
        public void handleIOException(IOException iox) {
        }

        @Override
        public InterestReadableByteChannel getReadChannel() {
            return this.readChannel;
        }

        @Override
        public void setReadChannel(InterestReadableByteChannel newChannel) {
            this.readChannel = newChannel;
            this.conn.setReadChannel(newChannel);
            this.setOps();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() {
            DaapController daapController = this;
            synchronized (daapController) {
                if (this.shutdown) {
                    return;
                }
                this.shutdown = true;
            }
            this.conn.close();
            LimeDaapServerNIO.this.allConnections.remove(this.conn);
            try {
                LimeDaapServerNIO.this.removeConnection(this.conn);
            }
            catch (IllegalStateException ise) {
                LOG.error("ISE", ise);
            }
        }

        @Override
        public InterestWritableByteChannel getWriteChannel() {
            return this.writeChannel;
        }

        @Override
        public void setWriteChannel(InterestWritableByteChannel newChannel) {
            this.conn.setWriteChannel(newChannel);
            this.writeChannel = newChannel;
            this.setOps();
        }

        @Override
        public boolean handleWrite() throws IOException {
            if (!this.conn.write()) {
                throw new IOException("finished");
            }
            return this.setOps();
        }

        private boolean setOps() {
            int ops = this.conn.interrestOps();
            boolean moreToWrite = false;
            if (this.writeChannel != null) {
                boolean write;
                moreToWrite = write = (ops & 4) != 0;
                this.writeChannel.interestWrite(this, write);
            }
            if (this.readChannel != null) {
                boolean read = (ops & 1) != 0;
                this.readChannel.interestRead(read);
            }
            return moreToWrite;
        }
    }

    private class DaapDispatcher
    implements AcceptObserver {
        private DaapDispatcher() {
        }

        @Override
        public void handleIOException(IOException iox) {
        }

        @Override
        public void shutdown() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleAccept(Socket socket) throws IOException {
            DaapDispatcher daapDispatcher = this;
            synchronized (daapDispatcher) {
                if (!LimeDaapServerNIO.this.running) {
                    IOUtils.close(socket);
                    return;
                }
            }
            DaapConnectionNIO connection = new DaapConnectionNIO(LimeDaapServerNIO.this, socket.getChannel());
            DaapController cont = new DaapController(connection);
            socket.setSoTimeout(0);
            LimeDaapServerNIO.this.allConnections.put(connection, cont);
            LimeDaapServerNIO.this.addPendingConnection(connection);
            ((NIOMultiplexor)((Object)socket)).setReadObserver(cont);
            ((NIOMultiplexor)((Object)socket)).setWriteObserver(cont);
        }
    }
}

