/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.messages;

import com.limegroup.gnutella.dht.messages.FindNodeRequestWireImpl;
import com.limegroup.gnutella.dht.messages.FindNodeResponseWireImpl;
import com.limegroup.gnutella.dht.messages.FindValueRequestWireImpl;
import com.limegroup.gnutella.dht.messages.FindValueResponseWireImpl;
import com.limegroup.gnutella.dht.messages.PingRequestWireImpl;
import com.limegroup.gnutella.dht.messages.PingResponseWireImpl;
import com.limegroup.gnutella.dht.messages.StatsRequestWireImpl;
import com.limegroup.gnutella.dht.messages.StatsResponseWireImpl;
import com.limegroup.gnutella.dht.messages.StoreRequestWireImpl;
import com.limegroup.gnutella.dht.messages.StoreResponseWireImpl;
import java.io.IOException;
import java.math.BigInteger;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.FindNodeRequest;
import org.limewire.mojito.messages.FindNodeResponse;
import org.limewire.mojito.messages.FindValueRequest;
import org.limewire.mojito.messages.FindValueResponse;
import org.limewire.mojito.messages.MessageFactory;
import org.limewire.mojito.messages.MessageFormatException;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.messages.PingRequest;
import org.limewire.mojito.messages.PingResponse;
import org.limewire.mojito.messages.StatsRequest;
import org.limewire.mojito.messages.StatsResponse;
import org.limewire.mojito.messages.StoreRequest;
import org.limewire.mojito.messages.StoreResponse;
import org.limewire.mojito.routing.Contact;
import org.limewire.security.SecurityToken;

public class MessageFactoryWire
implements MessageFactory {
    private final MessageFactory delegate;

    public MessageFactoryWire(MessageFactory delegate) {
        if (delegate == null) {
            throw new NullPointerException("Delegate is null");
        }
        if (delegate instanceof MessageFactoryWire) {
            throw new IllegalArgumentException("Recursive delegation");
        }
        this.delegate = delegate;
    }

    @Override
    public MessageID createMessageID(SocketAddress dst) {
        return this.delegate.createMessageID(dst);
    }

    @Override
    public DHTMessage createMessage(SocketAddress src, ByteBuffer ... data) throws MessageFormatException, IOException {
        DHTMessage msg = this.delegate.createMessage(src, data);
        if (msg instanceof PingRequest) {
            return new PingRequestWireImpl((PingRequest)msg);
        }
        if (msg instanceof PingResponse) {
            return new PingResponseWireImpl((PingResponse)msg);
        }
        if (msg instanceof FindNodeRequest) {
            return new FindNodeRequestWireImpl((FindNodeRequest)msg);
        }
        if (msg instanceof FindNodeResponse) {
            return new FindNodeResponseWireImpl((FindNodeResponse)msg);
        }
        if (msg instanceof FindValueRequest) {
            return new FindValueRequestWireImpl((FindValueRequest)msg);
        }
        if (msg instanceof FindValueResponse) {
            return new FindValueResponseWireImpl((FindValueResponse)msg);
        }
        if (msg instanceof StoreRequest) {
            return new StoreRequestWireImpl((StoreRequest)msg);
        }
        if (msg instanceof StoreResponse) {
            return new StoreResponseWireImpl((StoreResponse)msg);
        }
        if (msg instanceof StatsRequest) {
            return new StatsRequestWireImpl((StatsRequest)msg);
        }
        if (msg instanceof StatsResponse) {
            return new StatsResponseWireImpl((StatsResponse)msg);
        }
        throw new IOException(msg.getClass() + " is unhandled");
    }

    @Override
    public ByteBuffer writeMessage(SocketAddress dst, DHTMessage message) throws IOException {
        return this.delegate.writeMessage(dst, message);
    }

    @Override
    public FindNodeRequest createFindNodeRequest(Contact src, SocketAddress dst, KUID lookupId) {
        return new FindNodeRequestWireImpl(this.delegate.createFindNodeRequest(src, dst, lookupId));
    }

    @Override
    public FindNodeResponse createFindNodeResponse(Contact src, Contact dst, MessageID messageId, Collection<? extends Contact> nodes) {
        return new FindNodeResponseWireImpl(this.delegate.createFindNodeResponse(src, dst, messageId, nodes));
    }

    @Override
    public FindValueRequest createFindValueRequest(Contact src, SocketAddress dst, KUID lookupId, Collection<KUID> keys, DHTValueType valueType) {
        return new FindValueRequestWireImpl(this.delegate.createFindValueRequest(src, dst, lookupId, keys, valueType));
    }

    @Override
    public FindValueResponse createFindValueResponse(Contact src, Contact dst, MessageID messageId, float requestLoad, Collection<? extends DHTValueEntity> entities, Collection<KUID> secondaryKeys) {
        return new FindValueResponseWireImpl(this.delegate.createFindValueResponse(src, dst, messageId, requestLoad, entities, secondaryKeys));
    }

    @Override
    public PingRequest createPingRequest(Contact src, SocketAddress dst) {
        return new PingRequestWireImpl(this.delegate.createPingRequest(src, dst));
    }

    @Override
    public PingResponse createPingResponse(Contact src, Contact dst, MessageID messageId, SocketAddress externalAddress, BigInteger estimatedSize) {
        return new PingResponseWireImpl(this.delegate.createPingResponse(src, dst, messageId, externalAddress, estimatedSize));
    }

    @Override
    public StatsRequest createStatsRequest(Contact src, SocketAddress dst, StatsRequest.StatisticType stats) {
        return new StatsRequestWireImpl(this.delegate.createStatsRequest(src, dst, stats));
    }

    @Override
    public StatsResponse createStatsResponse(Contact src, Contact dst, MessageID messageId, byte[] statistics) {
        return new StatsResponseWireImpl(this.delegate.createStatsResponse(src, dst, messageId, statistics));
    }

    @Override
    public StoreRequest createStoreRequest(Contact src, SocketAddress dst, SecurityToken securityToken, Collection<? extends DHTValueEntity> values) {
        return new StoreRequestWireImpl(this.delegate.createStoreRequest(src, dst, securityToken, values));
    }

    @Override
    public StoreResponse createStoreResponse(Contact src, Contact dst, MessageID messageId, Collection<StoreResponse.StoreStatusCode> status) {
        return new StoreResponseWireImpl(this.delegate.createStoreResponse(src, dst, messageId, status));
    }
}

