/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.DownloadCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.DiskController;
import com.limegroup.gnutella.downloader.DownloadWorkerFactory;
import com.limegroup.gnutella.downloader.DownloaderType;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.MagnetDownloader;
import com.limegroup.gnutella.downloader.ManagedDownloaderImpl;
import com.limegroup.gnutella.downloader.PushList;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.downloader.RequeryManagerFactory;
import com.limegroup.gnutella.downloader.SourceRanker;
import com.limegroup.gnutella.downloader.SourceRankerFactory;
import com.limegroup.gnutella.downloader.VerifyingFileFactory;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import com.limegroup.gnutella.downloader.serial.MagnetDownloadMemento;
import com.limegroup.gnutella.downloader.serial.MagnetDownloadMementoImpl;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.guess.OnDemandUnicaster;
import com.limegroup.gnutella.library.FileCollection;
import com.limegroup.gnutella.library.GnutellaFiles;
import com.limegroup.gnutella.library.Library;
import com.limegroup.gnutella.library.UrnCache;
import com.limegroup.gnutella.malware.DangerousFileChecker;
import com.limegroup.gnutella.malware.VirusScanner;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.spam.SpamManager;
import com.limegroup.gnutella.tigertree.HashTreeCache;
import com.limegroup.gnutella.util.QueryUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.limewire.activation.api.ActivationManager;
import org.limewire.concurrent.ListeningExecutorService;
import org.limewire.core.api.download.SaveLocationManager;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.api.network.BandwidthCollector;
import org.limewire.io.InvalidDataException;
import org.limewire.net.SocketsManager;

class MagnetDownloaderImpl
extends ManagedDownloaderImpl
implements MagnetDownloader {
    private static final Log LOG = LogFactory.getLog(MagnetDownloaderImpl.class);
    private MagnetOptions magnet;

    @Inject
    MagnetDownloaderImpl(SaveLocationManager saveLocationManager, DownloadManager downloadManager, @GnutellaFiles FileCollection gnutellaFileCollection, IncompleteFileManager incompleteFileManager, DownloadCallback downloadCallback, NetworkManager networkManager, AlternateLocationFactory alternateLocationFactory, RequeryManagerFactory requeryManagerFactory, QueryRequestFactory queryRequestFactory, OnDemandUnicaster onDemandUnicaster, DownloadWorkerFactory downloadWorkerFactory, AltLocManager altLocManager, ContentManager contentManager, SourceRankerFactory sourceRankerFactory, UrnCache urnCache, VerifyingFileFactory verifyingFileFactory, DiskController diskController, IPFilter ipFilter, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Provider<MessageRouter> messageRouter, Provider<HashTreeCache> tigerTreeCache, ApplicationServices applicationServices, RemoteFileDescFactory remoteFileDescFactory, Provider<PushList> pushListProvider, SocketsManager socketsManager, @Named(value="downloadStateProcessingQueue") ListeningExecutorService downloadStateProcessingQueue, DangerousFileChecker dangerousFileChecker, VirusScanner virusScanner, SpamManager spamManager, Library library, CategoryManager categoryManager, BandwidthCollector bandwidthCollector, ActivationManager activationManager) {
        super(saveLocationManager, downloadManager, gnutellaFileCollection, incompleteFileManager, downloadCallback, networkManager, alternateLocationFactory, requeryManagerFactory, queryRequestFactory, onDemandUnicaster, downloadWorkerFactory, altLocManager, contentManager, sourceRankerFactory, urnCache, verifyingFileFactory, diskController, ipFilter, backgroundExecutor, messageRouter, tigerTreeCache, applicationServices, remoteFileDescFactory, pushListProvider, socketsManager, downloadStateProcessingQueue, dangerousFileChecker, virusScanner, spamManager, library, categoryManager, bandwidthCollector, activationManager);
    }

    @Override
    public void initialize() {
        long size;
        MagnetOptions magnet = this.getMagnet();
        assert (magnet != null);
        URN sha1 = magnet.getSHA1Urn();
        if (sha1 != null) {
            this.setSha1Urn(sha1);
        }
        if ((size = magnet.getFileSize()) != -1L) {
            this.setContentLength(size);
        }
        super.initialize();
        this.requeryManager.activate();
    }

    @Override
    public synchronized MagnetOptions getMagnet() {
        return this.magnet;
    }

    @Override
    public synchronized void setMagnet(MagnetOptions magnet) {
        if (this.getMagnet() != null) {
            throw new IllegalStateException("magnet already set!");
        }
        this.magnet = magnet;
    }

    @Override
    protected Downloader.DownloadState initializeDownload() {
        SourceRanker ranker;
        boolean hasMore;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing magnet download for: " + this.magnet);
        }
        boolean bl = hasMore = (ranker = this.getSourceRanker()) != null && ranker.hasMore();
        if (!this.hasRFD() && !hasMore) {
            MagnetOptions magnet = this.getMagnet();
            String[] defaultURLs = magnet.getDefaultURLs();
            boolean foundSource = false;
            long fileSize = magnet.getFileSize();
            for (int i = 0; i < defaultURLs.length; ++i) {
                try {
                    RemoteFileDesc rfd = this.createRemoteFileDesc(defaultURLs[i], this.getSaveFile().getName(), magnet.getSHA1Urn(), fileSize);
                    fileSize = rfd.getSize();
                    this.initPropertiesMap(rfd);
                    this.addDownloadForced(rfd, true);
                    continue;
                }
                catch (IOException e) {
                    LOG.warn("error", e);
                    continue;
                }
                catch (HttpException e) {
                    LOG.warn("error", e);
                    continue;
                }
                catch (URISyntaxException e) {
                    LOG.warn("error", e);
                    continue;
                }
                catch (InterruptedException e) {
                    LOG.warn("error", e);
                }
            }
            if (!foundSource) {
                return Downloader.DownloadState.GAVE_UP;
            }
        }
        return super.initializeDownload();
    }

    private RemoteFileDesc createRemoteFileDesc(String defaultURL, String filename, URN urn, long fileSize) throws IOException, HttpException, InterruptedException, URISyntaxException {
        return this.remoteFileDescFactory.createUrlRemoteFileDesc(new URL(defaultURL), filename, urn, fileSize);
    }

    @Override
    public QueryRequest newRequery() throws CantResumeException {
        MagnetOptions magnet = this.getMagnet();
        String textQuery = magnet.getQueryString();
        if (textQuery != null) {
            String q = QueryUtils.createQueryString(textQuery);
            return this.queryRequestFactory.createQuery(q);
        }
        String q = QueryUtils.createQueryString(this.getSaveFile().getName());
        return this.queryRequestFactory.createQuery(q);
    }

    @Override
    protected boolean allowAddition(RemoteFileDesc other) {
        URN otherSHA1 = other.getSHA1Urn();
        if (this.getSha1Urn() != null && otherSHA1 != null) {
            return this.getSha1Urn().equals(otherSHA1);
        }
        return false;
    }

    @Override
    protected synchronized boolean addDownloadForced(RemoteFileDesc rfd, boolean cache) {
        if (!this.hasRFD()) {
            this.initPropertiesMap(rfd);
        }
        return super.addDownloadForced(rfd, cache);
    }

    @Override
    protected boolean canSendRequeryNow() {
        return this.getSha1Urn() != null ? super.canSendRequeryNow() : false;
    }

    @Override
    protected void initializeIncompleteFile() throws IOException {
        if (this.getContentLength() != -1L) {
            super.initializeIncompleteFile();
        }
    }

    @Override
    public DownloaderType getDownloadType() {
        return DownloaderType.MAGNET;
    }

    @Override
    public synchronized void initFromMemento(DownloadMemento memento) throws InvalidDataException {
        super.initFromMemento(memento);
        MagnetDownloadMemento mmem = (MagnetDownloadMemento)memento;
        this.setMagnet(mmem.getMagnet());
    }

    @Override
    protected void fillInMemento(DownloadMemento memento) {
        super.fillInMemento(memento);
        MagnetDownloadMemento mmem = (MagnetDownloadMemento)memento;
        mmem.setMagnet(this.getMagnet());
    }

    @Override
    protected DownloadMemento createMemento() {
        return new MagnetDownloadMementoImpl();
    }
}

