/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.DownloadCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.downloader.DiskController;
import com.limegroup.gnutella.downloader.DownloadWorkerFactory;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.ManagedDownloaderImpl;
import com.limegroup.gnutella.downloader.PushList;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.downloader.RequeryManagerFactory;
import com.limegroup.gnutella.downloader.ResumeDownloader;
import com.limegroup.gnutella.downloader.SourceRankerFactory;
import com.limegroup.gnutella.downloader.VerifyingFileFactory;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.guess.OnDemandUnicaster;
import com.limegroup.gnutella.library.FileCollection;
import com.limegroup.gnutella.library.GnutellaFiles;
import com.limegroup.gnutella.library.Library;
import com.limegroup.gnutella.library.UrnCache;
import com.limegroup.gnutella.malware.DangerousFileChecker;
import com.limegroup.gnutella.malware.VirusScanner;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.spam.SpamManager;
import com.limegroup.gnutella.tigertree.HashTreeCache;
import java.io.File;
import java.util.concurrent.ScheduledExecutorService;
import org.limewire.activation.api.ActivationManager;
import org.limewire.concurrent.ListeningExecutorService;
import org.limewire.core.api.download.SaveLocationManager;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.api.network.BandwidthCollector;
import org.limewire.net.SocketsManager;
import org.limewire.util.Objects;

class ResumeDownloaderImpl
extends ManagedDownloaderImpl
implements ResumeDownloader {
    @Inject
    ResumeDownloaderImpl(SaveLocationManager saveLocationManager, DownloadManager downloadManager, @GnutellaFiles FileCollection gnutellaFileCollection, IncompleteFileManager incompleteFileManager, DownloadCallback downloadCallback, NetworkManager networkManager, AlternateLocationFactory alternateLocationFactory, RequeryManagerFactory requeryManagerFactory, QueryRequestFactory queryRequestFactory, OnDemandUnicaster onDemandUnicaster, DownloadWorkerFactory downloadWorkerFactory, AltLocManager altLocManager, ContentManager contentManager, SourceRankerFactory sourceRankerFactory, UrnCache urnCache, VerifyingFileFactory verifyingFileFactory, DiskController diskController, IPFilter ipFilter, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Provider<MessageRouter> messageRouter, Provider<HashTreeCache> tigerTreeCache, ApplicationServices applicationServices, RemoteFileDescFactory remoteFileDescFactory, Provider<PushList> pushListProvider, SocketsManager socketsManager, @Named(value="downloadStateProcessingQueue") ListeningExecutorService downloadStateProcessingQueue, DangerousFileChecker dangerousFileChecker, VirusScanner virusScanner, SpamManager spamManager, Library library, CategoryManager categoryManager, BandwidthCollector bandwidthCollector, ActivationManager activationManager) {
        super(saveLocationManager, downloadManager, gnutellaFileCollection, incompleteFileManager, downloadCallback, networkManager, alternateLocationFactory, requeryManagerFactory, queryRequestFactory, onDemandUnicaster, downloadWorkerFactory, altLocManager, contentManager, sourceRankerFactory, urnCache, verifyingFileFactory, diskController, ipFilter, backgroundExecutor, messageRouter, tigerTreeCache, applicationServices, remoteFileDescFactory, pushListProvider, socketsManager, downloadStateProcessingQueue, dangerousFileChecker, virusScanner, spamManager, library, categoryManager, bandwidthCollector, activationManager);
    }

    @Override
    public void initIncompleteFile(File incompleteFile, long size) {
        this.setIncompleteFile(Objects.nonNull(incompleteFile, "incompleteFile"));
        this.setContentLength(size);
        URN sha1 = this.incompleteFileManager.getCompletedHash(incompleteFile);
        if (sha1 != null) {
            this.setSha1Urn(sha1);
        }
    }

    @Override
    public void initialize() {
        super.initialize();
    }
}

