/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader.serial.conversion;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import com.limegroup.gnutella.downloader.serial.DownloadSerializeSettings;
import com.limegroup.gnutella.downloader.serial.DownloadSerializer;
import com.limegroup.gnutella.downloader.serial.OldDownloadConverter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadUpgradeTask {
    private static final Log LOG = LogFactory.getLog(DownloadUpgradeTask.class);
    private final OldDownloadConverter oldDownloadConverter;
    private final DownloadSerializeSettings oldDownloadSettings;
    private final DownloadSerializeSettings newSettings;
    private final DownloadSerializer downloadSerializer;

    @Inject
    public DownloadUpgradeTask(OldDownloadConverter oldDownloadConverter, @Named(value="oldDownloadSettings") DownloadSerializeSettings oldDownloadSettings, DownloadSerializeSettings newSettings, DownloadSerializer downloadSerializer) {
        this.oldDownloadConverter = oldDownloadConverter;
        this.oldDownloadSettings = oldDownloadSettings;
        this.newSettings = newSettings;
        this.downloadSerializer = downloadSerializer;
    }

    public void upgrade() {
        File newSaveBackup = this.newSettings.getBackupFile();
        File newSave = this.newSettings.getSaveFile();
        if (!newSaveBackup.exists() && !newSave.exists()) {
            try {
                List<DownloadMemento> mementos = this.readAndConvertOldFormat();
                if (this.downloadSerializer.writeToDisk(mementos)) {
                    this.oldDownloadSettings.getSaveFile().delete();
                    this.oldDownloadSettings.getBackupFile().delete();
                }
            }
            catch (IOException iox) {
                LOG.warn("Unable to read old file or write to backup!", iox);
            }
        }
    }

    private List<DownloadMemento> readAndConvertOldFormat() throws IOException {
        try {
            return this.oldDownloadConverter.readAndConvertOldDownloads(this.oldDownloadSettings.getSaveFile());
        }
        catch (Throwable ignored) {
            LOG.warn("Error trying to convert old normal file.", ignored);
            try {
                return this.oldDownloadConverter.readAndConvertOldDownloads(this.oldDownloadSettings.getBackupFile());
            }
            catch (Throwable ignored2) {
                LOG.warn("Error trying to convert old normal file.", ignored2);
                throw new IOException("Unable to read old files!");
            }
        }
    }
}

