/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters.response;

import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.filters.response.ResponseFilter;
import com.limegroup.gnutella.messages.QueryReply;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class CompoundResponseFilter
implements ResponseFilter {
    private static final Log LOG = LogFactory.getLog(CompoundResponseFilter.class);
    private final List<ResponseFilter> blackListFilters;
    private final List<ResponseFilter> whiteListFilters;

    CompoundResponseFilter(Collection<? extends ResponseFilter> blackListFilters, Collection<? extends ResponseFilter> whiteListFilters) {
        this.blackListFilters = new ArrayList<ResponseFilter>(blackListFilters);
        this.whiteListFilters = new ArrayList<ResponseFilter>(whiteListFilters);
    }

    @Override
    public boolean allow(QueryReply qr, Response response) {
        for (ResponseFilter blackFilter : this.blackListFilters) {
            if (blackFilter.allow(qr, response)) continue;
            for (ResponseFilter whiteFilter : this.whiteListFilters) {
                if (!whiteFilter.allow(qr, response)) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Response whitelisted by " + whiteFilter.getClass().getSimpleName() + "\n" + response);
                }
                return true;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Response blacklisted by " + blackFilter.getClass().getSimpleName() + "\n" + response);
            }
            return false;
        }
        LOG.trace("Response not blacklisted or whitelisted");
        return true;
    }
}

