/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HandshakeSupport;
import com.limegroup.gnutella.handshaking.NoGnutellaOkException;
import com.limegroup.gnutella.http.ReadHeadersIOState;
import java.io.IOException;
import org.limewire.core.settings.ConnectionSettings;

abstract class ReadHandshakeState
extends ReadHeadersIOState {
    protected ReadHandshakeState(HandshakeSupport support) {
        super(support, null, ConnectionSettings.MAX_HANDSHAKE_HEADERS.getValue(), ConnectionSettings.MAX_HANDSHAKE_LINE_SIZE.getValue());
    }

    static class ReadResponseState
    extends ReadHandshakeState {
        ReadResponseState(HandshakeSupport support) {
            super(support);
        }

        @Override
        protected void processConnectLine() throws IOException {
            if (((HandshakeSupport)this.support).getReadHandshakeResponse().isCrawler()) {
                throw new IOException("crawler");
            }
            if (!((HandshakeSupport)this.support).isConnectLineValid(this.connectLine)) {
                throw new IOException("Bad connect string");
            }
        }

        @Override
        protected void processHeaders() throws IOException {
            HandshakeResponse theirResponse = ((HandshakeSupport)this.support).createRemoteResponse(this.connectLine);
            switch (theirResponse.getStatusCode()) {
                case 200: {
                    break;
                }
                default: {
                    throw NoGnutellaOkException.createServerUnknown(theirResponse.getStatusCode());
                }
            }
        }
    }

    static class ReadRequestState
    extends ReadHandshakeState {
        ReadRequestState(HandshakeSupport support) {
            super(support);
        }

        @Override
        protected void processConnectLine() throws IOException {
            if (!((HandshakeSupport)this.support).notLessThan06(this.connectLine)) {
                throw new IOException("not a valid connect string!");
            }
        }

        @Override
        protected void processHeaders() throws IOException {
        }
    }
}

