/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.QueryCategoryFilterer;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.ResponseFactory;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.library.CreationTimeCache;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.FileDescChangeEvent;
import com.limegroup.gnutella.library.FileView;
import com.limegroup.gnutella.library.FileViewChangeEvent;
import com.limegroup.gnutella.library.GnutellaFiles;
import com.limegroup.gnutella.library.IncompleteFileDesc;
import com.limegroup.gnutella.library.IncompleteFiles;
import com.limegroup.gnutella.library.Library;
import com.limegroup.gnutella.library.LibraryStatusEvent;
import com.limegroup.gnutella.library.SharedFilesKeywordIndex;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.util.QueryUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.limewire.collection.Function;
import org.limewire.collection.IdentityHashSet;
import org.limewire.collection.IntSet;
import org.limewire.collection.MultiIterator;
import org.limewire.collection.StringTrie;
import org.limewire.core.api.Category;
import org.limewire.core.settings.SearchSettings;
import org.limewire.core.settings.SharingSettings;
import org.limewire.inject.EagerSingleton;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.InspectableForSize;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.util.FileUtils;
import org.limewire.util.I18NConvert;
import org.limewire.util.StringUtils;

@EagerSingleton
class SharedFilesKeywordIndexImpl
implements SharedFilesKeywordIndex {
    @InspectableForSize(value="size of keyword trie", category=DataCategory.USAGE)
    private final StringTrie<IntSet> keywordTrie = new StringTrie(true);
    @InspectableForSize(value="size of incomplete keyword trie", category=DataCategory.USAGE)
    private final StringTrie<IntSet> incompleteKeywordTrieV2 = new StringTrie(true);
    private final Provider<CreationTimeCache> creationTimeCache;
    private final Provider<ResponseFactory> responseFactory;
    private final Library library;
    private final FileView gnutellaFileView;
    private final FileView incompleteFileView;
    private final Provider<SchemaReplyCollectionMapper> schemaReplyCollectionMapper;
    private final ActivityCallback activityCallback;
    private final Provider<LimeXMLSchemaRepository> schemaRepository;
    private final QueryCategoryFilterer mediaTypeAggregator;

    @Inject
    public SharedFilesKeywordIndexImpl(Library library, Provider<CreationTimeCache> creationTimeCache, Provider<ResponseFactory> responseFactory, Provider<SchemaReplyCollectionMapper> schemaReplyCollectionMapper, ActivityCallback activityCallback, Provider<LimeXMLSchemaRepository> schemaRepository, @GnutellaFiles FileView gnutellaFileView, @IncompleteFiles FileView incompleteFileView, QueryCategoryFilterer mediaTypeAggregator) {
        this.library = library;
        this.creationTimeCache = creationTimeCache;
        this.responseFactory = responseFactory;
        this.schemaReplyCollectionMapper = schemaReplyCollectionMapper;
        this.activityCallback = activityCallback;
        this.schemaRepository = schemaRepository;
        this.incompleteFileView = incompleteFileView;
        this.gnutellaFileView = gnutellaFileView;
        this.mediaTypeAggregator = mediaTypeAggregator;
    }

    @Inject
    void register(ServiceRegistry registry, final ListenerSupport<FileDescChangeEvent> fileDescSupport) {
        registry.register(new Service(){

            @Override
            public String getServiceName() {
                return "P2P Network Keyword Library";
            }

            @Override
            public void initialize() {
                fileDescSupport.addListener(new EventListener<FileDescChangeEvent>(){

                    @Override
                    public void handleEvent(FileDescChangeEvent event) {
                        SharedFilesKeywordIndexImpl.this.handleFileDescEvent(event);
                    }
                });
                SharedFilesKeywordIndexImpl.this.library.addManagedListStatusListener(new EventListener<LibraryStatusEvent>(){

                    @Override
                    public void handleEvent(LibraryStatusEvent event) {
                        SharedFilesKeywordIndexImpl.this.handleManagedListStatusEvent(event);
                    }
                });
                SharedFilesKeywordIndexImpl.this.gnutellaFileView.addListener(new EventListener<FileViewChangeEvent>(){

                    @Override
                    public void handleEvent(FileViewChangeEvent event) {
                        SharedFilesKeywordIndexImpl.this.handleFileListEvent(event, true);
                    }
                });
                SharedFilesKeywordIndexImpl.this.incompleteFileView.addListener(new EventListener<FileViewChangeEvent>(){

                    @Override
                    public void handleEvent(FileViewChangeEvent event) {
                        SharedFilesKeywordIndexImpl.this.handleFileListEvent(event, false);
                    }
                });
            }

            @Override
            public void start() {
            }

            @Override
            public void stop() {
            }
        });
    }

    @Override
    public Response[] query(QueryRequest request) {
        Set<Response> responses = QueryProcessor.processQuery(request, this);
        this.incrementHitCount(responses);
        return responses.toArray(new Response[responses.size()]);
    }

    private void incrementHitCount(Set<Response> matches) {
        for (Response resp : matches) {
            long index = resp.getIndex();
            FileDesc desc = this.library.getFileDescForIndex((int)index);
            if (desc == null) continue;
            desc.incrementHitCount();
        }
    }

    private Set<Response> queryMetaData(QueryRequest request) {
        Set<Object> documents = Collections.emptySet();
        LimeXMLDocument doc = request.getRichQuery();
        if (doc != null) {
            documents = this.queryMetaDataWithRequestXml(doc);
        } else if (SearchSettings.INCLUDE_METADATA_IN_PLAINTEXT_SEARCH.getValue()) {
            documents = this.queryMetaDataWithPlaintext(request);
        }
        return this.createResponses(documents, request);
    }

    private Set<Response> queryFileNames(QueryRequest request) {
        String str = request.getQuery();
        boolean includeXML = request.shouldIncludeXMLInResponse();
        str = this.keywordTrie.canonicalCase(str);
        IntSet matches = this.search(str, null, request.desiresPartialResults());
        if (request.getQueryUrns().size() > 0) {
            matches = this.urnSearch(request.getQueryUrns(), matches);
        }
        if (matches == null) {
            return Collections.emptySet();
        }
        HashSet<Response> responses = new HashSet<Response>();
        Predicate<String> filter = this.mediaTypeAggregator.getPredicateForQuery(request);
        LimeXMLDocument doc = request.getRichQuery();
        boolean includeNMs1Urn = request.desiresNMS1Urn();
        IntSet.IntSetIterator iter = matches.iterator();
        while (iter.hasNext()) {
            int i = iter.next();
            FileDesc desc = this.gnutellaFileView.getFileDescForIndex(i);
            if (desc == null) {
                desc = this.incompleteFileView.getFileDescForIndex(i);
            }
            if (desc == null || !filter.apply(FileUtils.getFileExtension(desc.getFileName()))) continue;
            this.activityCallback.handleSharedFileUpdate(desc.getFile());
            Response resp = this.responseFactory.get().createResponse(desc, includeNMs1Urn);
            if (includeXML) {
                if (doc != null && resp.getDocument() != null && !SharedFilesKeywordIndexImpl.isValidXMLMatch(resp, doc)) {
                    continue;
                }
            } else {
                resp.setDocument(null);
            }
            responses.add(resp);
        }
        if (responses.size() == 0) {
            return Collections.emptySet();
        }
        return responses;
    }

    private static boolean isValidXMLMatch(Response r, LimeXMLDocument doc) {
        return LimeXMLUtils.match(r.getDocument(), doc, true);
    }

    private IntSet urnSearch(Iterable<URN> urnsIter, IntSet priors) {
        IntSet ret = priors;
        for (URN urn : urnsIter) {
            List<FileDesc> fds = this.gnutellaFileView.getFileDescsMatching(urn);
            for (FileDesc fd : fds) {
                if (ret == null) {
                    ret = new IntSet();
                }
                ret.add(fd.getIndex());
            }
        }
        return ret;
    }

    private Set<Response> queryWhatsNew(QueryRequest request) {
        boolean includeXML = request.shouldIncludeXMLInResponse();
        boolean includeNMs1Urn = request.desiresNMS1Urn();
        Collection<URN> urnList = this.creationTimeCache.get().getFiles(request, 3);
        if (urnList.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<Response> resps = new HashSet<Response>(urnList.size());
        for (URN urn : urnList) {
            FileDesc desc = this.gnutellaFileView.getFileDesc(urn);
            if (desc == null || desc instanceof IncompleteFileDesc) {
                throw new RuntimeException("Bad Rep - No IFDs allowed!");
            }
            Response r = this.responseFactory.get().createResponse(desc, includeNMs1Urn);
            if (!includeXML) {
                r.setDocument(null);
            }
            resps.add(r);
        }
        return resps;
    }

    private void clear(boolean complete) {
        if (complete) {
            this.keywordTrie.clear();
        } else {
            this.incompleteKeywordTrieV2.clear();
        }
    }

    private void handleFileListEvent(FileViewChangeEvent evt, boolean complete) {
        switch (evt.getType()) {
            case FILE_ADDED: {
                this.addFileDesc(evt.getFileDesc(), complete);
                break;
            }
            case FILE_CHANGED: {
                this.removeFileDesc(evt.getOldValue(), complete);
                this.addFileDesc(evt.getFileDesc(), complete);
                break;
            }
            case FILE_REMOVED: {
                this.removeFileDesc(evt.getFileDesc(), complete);
                break;
            }
            case FILES_CLEARED: {
                this.clear(complete);
                break;
            }
        }
    }

    private void handleManagedListStatusEvent(LibraryStatusEvent evt) {
        switch (evt.getType()) {
            case LOAD_COMPLETE: {
                this.trim();
            }
        }
    }

    private void handleFileDescEvent(FileDescChangeEvent evt) {
        FileDesc fd = (FileDesc)evt.getSource();
        switch ((FileDescChangeEvent.Type)((Object)evt.getType())) {
            case TT_ROOT_ADDED: {
                if (!(fd instanceof IncompleteFileDesc)) break;
                IncompleteFileDesc ifd = (IncompleteFileDesc)fd;
                if (!SharingSettings.ALLOW_PARTIAL_SHARING.getValue() || !SharingSettings.LOAD_PARTIAL_KEYWORDS.getValue() || !ifd.hasUrnsAndPartialData()) break;
                this.addFileDesc(fd, false);
            }
        }
    }

    private void removeFileDesc(FileDesc fileDesc, boolean complete) {
        if (complete) {
            this.removeKeywords(this.keywordTrie, fileDesc);
        } else {
            this.removeKeywords(this.incompleteKeywordTrieV2, fileDesc);
        }
    }

    private void addFileDesc(FileDesc fileDesc, boolean complete) {
        if (!complete) {
            boolean indexIncompleteFiles = SharingSettings.ALLOW_PARTIAL_SHARING.getValue() && SharingSettings.LOAD_PARTIAL_KEYWORDS.getValue();
            IncompleteFileDesc ifd = (IncompleteFileDesc)fileDesc;
            if (indexIncompleteFiles && ifd.hasUrnsAndPartialData()) {
                this.loadKeywords(this.incompleteKeywordTrieV2, fileDesc);
            }
        } else {
            this.loadKeywords(this.keywordTrie, fileDesc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadKeywords(StringTrie<IntSet> trie, FileDesc fd) {
        String[] keywords;
        for (String keyword : keywords = SharedFilesKeywordIndexImpl.extractKeywords(fd)) {
            StringTrie<IntSet> stringTrie = trie;
            synchronized (stringTrie) {
                IntSet indices = trie.get(keyword);
                if (indices == null) {
                    indices = new IntSet();
                    trie.add(keyword, indices);
                }
                indices.add(fd.getIndex());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeKeywords(StringTrie<IntSet> trie, FileDesc fd) {
        String[] keywords;
        for (String keyword : keywords = SharedFilesKeywordIndexImpl.extractKeywords(fd)) {
            StringTrie<IntSet> stringTrie = trie;
            synchronized (stringTrie) {
                IntSet indices = trie.get(keyword);
                if (indices != null) {
                    indices.remove(fd.getIndex());
                    if (indices.size() == 0) {
                        trie.remove(keyword);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IntSet search(String query, IntSet priors, boolean partial) {
        IntSet ret = priors;
        int i = 0;
        while (i < query.length()) {
            StringTrie<IntSet> stringTrie;
            Iterator<IntSet> iter;
            int j;
            if (QueryUtils.isDelimiter(query.charAt(i))) {
                ++i;
                continue;
            }
            for (j = i + 1; j < query.length() && !QueryUtils.isDelimiter(query.charAt(j)); ++j) {
            }
            StringTrie<IntSet> stringTrie2 = this.keywordTrie;
            synchronized (stringTrie2) {
                iter = this.keywordTrie.getPrefixedBy(query, i, j);
            }
            if (SharingSettings.ALLOW_PARTIAL_SHARING.getValue() && SharingSettings.ALLOW_PARTIAL_RESPONSES.getValue() && partial) {
                Iterator<IntSet> incompleteIndices;
                stringTrie = this.incompleteKeywordTrieV2;
                synchronized (stringTrie) {
                    incompleteIndices = this.incompleteKeywordTrieV2.getPrefixedBy(query, i, j);
                }
                iter = new MultiIterator<IntSet>(iter, incompleteIndices);
            }
            stringTrie2 = this.keywordTrie;
            synchronized (stringTrie2) {
                stringTrie = this.incompleteKeywordTrieV2;
                synchronized (stringTrie) {
                    if (iter.hasNext()) {
                        IntSet matches = null;
                        while (iter.hasNext()) {
                            IntSet s = iter.next();
                            if (matches == null) {
                                if (i == 0 && j == query.length() && !iter.hasNext()) {
                                    return s;
                                }
                                matches = new IntSet();
                            }
                            matches.addAll(s);
                        }
                        if (ret == null) {
                            ret = matches;
                        } else {
                            ret.retainAll(matches);
                        }
                    } else {
                        return null;
                    }
                    if (ret.size() == 0) {
                        return null;
                    }
                    i = j;
                }
            }
        }
        if (ret == null || ret.size() == 0) {
            return null;
        }
        return ret;
    }

    private static String[] extractKeywords(FileDesc fd) {
        return StringUtils.split(I18NConvert.instance().getNorm(fd.getPath()), " -._+/*()\\,");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trim() {
        StringTrie[] arr$ = new StringTrie[]{this.keywordTrie, this.incompleteKeywordTrieV2};
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StringTrie trie;
            StringTrie stringTrie = trie = arr$[i$];
            synchronized (stringTrie) {
                trie.trim(new Function<IntSet, IntSet>(){

                    @Override
                    public IntSet apply(IntSet intSet) {
                        intSet.trim();
                        return intSet;
                    }
                });
                continue;
            }
        }
    }

    private Set<LimeXMLDocument> queryMetaDataWithRequestXml(LimeXMLDocument queryDoc) {
        String schema = queryDoc.getSchemaURI();
        LimeXMLReplyCollection replyCol = this.schemaReplyCollectionMapper.get().getReplyCollection(schema);
        if (replyCol == null) {
            return Collections.emptySet();
        }
        return replyCol.getMatchingDocuments(queryDoc);
    }

    private Set<LimeXMLDocument> queryMetaDataWithPlaintext(QueryRequest request) {
        Collection<LimeXMLReplyCollection> schemas = this.getReplyCollections(request);
        IdentityHashSet<LimeXMLDocument> documents = new IdentityHashSet<LimeXMLDocument>();
        for (LimeXMLReplyCollection schemaCol : schemas) {
            documents.addAll(schemaCol.getMatchingDocuments(request.getQuery()));
        }
        return documents;
    }

    private Collection<LimeXMLReplyCollection> getReplyCollections(QueryRequest request) {
        List<Category> categoriesRequested = this.mediaTypeAggregator.getRequestedCategories(request);
        SchemaReplyCollectionMapper mapper = this.schemaReplyCollectionMapper.get();
        if (categoriesRequested == null) {
            return mapper.getCollections();
        }
        ArrayList<LimeXMLReplyCollection> collections = new ArrayList<LimeXMLReplyCollection>(categoriesRequested.size());
        for (Category category : categoriesRequested) {
            LimeXMLReplyCollection col = mapper.getReplyCollection(this.getSchemaUriFromMimeType(category.getSchemaName()));
            if (col == null) continue;
            collections.add(col);
        }
        return collections;
    }

    private String getSchemaUriFromMimeType(String mimeType) {
        Collection<LimeXMLSchema> schemas = this.schemaRepository.get().getAvailableSchemas();
        for (LimeXMLSchema schema : schemas) {
            if (!schema.getDescription().equals(mimeType)) continue;
            return schema.getSchemaURI();
        }
        return "";
    }

    private Set<Response> createResponses(Set<LimeXMLDocument> documents, QueryRequest request) {
        HashSet<Response> responses = new HashSet<Response>(documents.size());
        boolean includeNMs1Urn = request.desiresNMS1Urn();
        for (LimeXMLDocument currDoc : documents) {
            File file = currDoc.getIdentifier();
            Response res = null;
            assert (file != null);
            FileDesc fd = this.gnutellaFileView.getFileDesc(file);
            if (fd == null || fd.getSHA1Urn() == null) continue;
            res = this.responseFactory.get().createResponse(fd, includeNMs1Urn);
            res.setDocument(null);
            this.activityCallback.handleSharedFileUpdate(fd.getFile());
            res.setDocument(currDoc);
            responses.add(res);
        }
        return responses;
    }

    private static class QueryProcessingContext {
        private boolean isTerminal = false;
        private final Set<Response> responses = new HashSet<Response>();

        QueryProcessingContext() {
        }

        boolean isFinishedProcessing() {
            return this.isTerminal;
        }

        Set<Response> getResponses() {
            return this.responses;
        }

        void addQueryResponses(Set<Response> responses) {
            this.responses.addAll(responses);
        }

        void setFinishedProcessing() {
            this.isTerminal = true;
        }
    }

    private static enum QueryProcessor {
        WHATS_NEW{

            @Override
            void processQueryStage(QueryRequest request, QueryProcessingContext context, SharedFilesKeywordIndexImpl keywordIndex) {
                Set responses = keywordIndex.queryWhatsNew(request);
                context.addQueryResponses(responses);
                context.setFinishedProcessing();
            }

            @Override
            boolean shouldProcess(QueryRequest request) {
                return request.isWhatIsNewRequest();
            }
        }
        ,
        SPECIAL_CASE_EMPTY_RESPONSE{

            @Override
            void processQueryStage(QueryRequest request, QueryProcessingContext context, SharedFilesKeywordIndexImpl keywordIndex) {
                context.setFinishedProcessing();
            }

            @Override
            boolean shouldProcess(QueryRequest request) {
                String str = request.getQuery();
                return str.equals("    ") || str.equals("*.*");
            }
        }
        ,
        FILE_SEARCH{

            @Override
            void processQueryStage(QueryRequest request, QueryProcessingContext context, SharedFilesKeywordIndexImpl keywordIndex) {
                Set responses = keywordIndex.queryFileNames(request);
                context.addQueryResponses(responses);
            }

            @Override
            boolean shouldProcess(QueryRequest request) {
                return true;
            }
        }
        ,
        METADATA_SEARCH{

            @Override
            void processQueryStage(QueryRequest request, QueryProcessingContext context, SharedFilesKeywordIndexImpl keywordIndex) {
                Set responses = keywordIndex.queryMetaData(request);
                context.addQueryResponses(responses);
                context.setFinishedProcessing();
            }

            @Override
            boolean shouldProcess(QueryRequest request) {
                return request.shouldIncludeXMLInResponse();
            }
        };


        abstract void processQueryStage(QueryRequest var1, QueryProcessingContext var2, SharedFilesKeywordIndexImpl var3);

        abstract boolean shouldProcess(QueryRequest var1);

        public static Set<Response> processQuery(QueryRequest request, SharedFilesKeywordIndexImpl keywordIndex) {
            QueryProcessingContext contextObj = new QueryProcessingContext();
            for (QueryProcessor queryProcessor : QueryProcessor.values()) {
                if (!queryProcessor.shouldProcess(request)) continue;
                queryProcessor.processQueryStage(request, contextObj, keywordIndex);
                if (contextObj.isFinishedProcessing()) break;
            }
            return contextObj.getResponses();
        }
    }
}

