/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.ResponseFactory;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryReplyFactory;
import com.limegroup.gnutella.messages.QueryReplyImpl;
import com.limegroup.gnutella.util.DataUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.limewire.io.BadGGEPBlockException;
import org.limewire.io.GGEP;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.security.SecurityToken;
import org.limewire.util.ByteUtils;

@Singleton
public class QueryReplyFactoryImpl
implements QueryReplyFactory {
    private final ResponseFactory responseFactory;
    private final NetworkManager networkManager;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public QueryReplyFactoryImpl(NetworkManager networkManager, NetworkInstanceUtils networkInstanceUtils, ResponseFactory responseFactory) {
        this.networkManager = networkManager;
        this.networkInstanceUtils = networkInstanceUtils;
        this.responseFactory = responseFactory;
    }

    @Override
    public QueryReply createQueryReply(byte[] guid, byte ttl, int port, byte[] ip, long speed, Response[] responses, byte[] clientGUID, boolean isMulticastReply) {
        return this.createInternal(guid, ttl, port, ip, speed, responses, clientGUID, DataUtils.EMPTY_BYTE_ARRAY, false, false, false, false, false, false, true, isMulticastReply, false, IpPort.EMPTY_SET, null);
    }

    @Override
    public QueryReply createQueryReply(byte[] guid, byte ttl, int port, byte[] ip, long speed, Response[] responses, byte[] clientGUID, boolean needsPush, boolean isBusy, boolean finishedUpload, boolean measuredSpeed, boolean supportsChat, boolean isMulticastReply) {
        return this.createInternal(guid, ttl, port, ip, speed, responses, clientGUID, DataUtils.EMPTY_BYTE_ARRAY, true, needsPush, isBusy, finishedUpload, measuredSpeed, supportsChat, true, isMulticastReply, false, IpPort.EMPTY_SET, null);
    }

    @Override
    public QueryReply createQueryReply(byte[] guid, byte ttl, int port, byte[] ip, long speed, Response[] responses, byte[] clientGUID, byte[] xmlBytes, boolean needsPush, boolean isBusy, boolean finishedUpload, boolean measuredSpeed, boolean supportsChat, boolean isMulticastReply) throws IllegalArgumentException {
        return this.createQueryReply(guid, ttl, port, ip, speed, responses, clientGUID, xmlBytes, needsPush, isBusy, finishedUpload, measuredSpeed, supportsChat, isMulticastReply, IpPort.EMPTY_SET);
    }

    @Override
    public QueryReply createQueryReply(byte[] guid, byte ttl, int port, byte[] ip, long speed, Response[] responses, byte[] clientGUID, byte[] xmlBytes, boolean needsPush, boolean isBusy, boolean finishedUpload, boolean measuredSpeed, boolean supportsChat, boolean isMulticastReply, Set<? extends IpPort> proxies) throws IllegalArgumentException {
        return this.createInternal(guid, ttl, port, ip, speed, responses, clientGUID, xmlBytes, true, needsPush, isBusy, finishedUpload, measuredSpeed, supportsChat, true, isMulticastReply, false, proxies, null);
    }

    @Override
    public QueryReply createQueryReply(byte[] guid, byte ttl, int port, byte[] ip, long speed, Response[] responses, byte[] clientGUID, byte[] xmlBytes, boolean needsPush, boolean isBusy, boolean finishedUpload, boolean measuredSpeed, boolean supportsChat, boolean isMulticastReply, Set<? extends IpPort> proxies, SecurityToken securityToken) throws IllegalArgumentException {
        return this.createInternal(guid, ttl, port, ip, speed, responses, clientGUID, xmlBytes, true, needsPush, isBusy, finishedUpload, measuredSpeed, supportsChat, true, isMulticastReply, false, proxies, securityToken);
    }

    @Override
    public QueryReply createQueryReply(byte[] guid, byte ttl, int port, byte[] ip, long speed, Response[] responses, byte[] clientGUID, byte[] xmlBytes, boolean needsPush, boolean isBusy, boolean finishedUpload, boolean measuredSpeed, boolean supportsChat, boolean isMulticastReply, boolean supportsFWTransfer, Set<? extends IpPort> proxies) throws IllegalArgumentException {
        return this.createInternal(guid, ttl, port, ip, speed, responses, clientGUID, xmlBytes, true, needsPush, isBusy, finishedUpload, measuredSpeed, supportsChat, true, isMulticastReply, supportsFWTransfer, proxies, null);
    }

    @Override
    public QueryReply createQueryReply(byte[] guid, byte ttl, int port, byte[] ip, long speed, Response[] responses, byte[] clientGUID, byte[] xmlBytes, boolean needsPush, boolean isBusy, boolean finishedUpload, boolean measuredSpeed, boolean supportsChat, boolean isMulticastReply, boolean supportsFWTransfer, Set<? extends IpPort> proxies, SecurityToken securityToken) throws IllegalArgumentException {
        return this.createInternal(guid, ttl, port, ip, speed, responses, clientGUID, xmlBytes, true, needsPush, isBusy, finishedUpload, measuredSpeed, supportsChat, true, isMulticastReply, supportsFWTransfer, proxies, securityToken);
    }

    @Override
    public QueryReply createFromNetwork(byte[] guid, byte ttl, byte hops, byte[] payload) throws BadPacketException {
        return this.createFromNetwork(guid, ttl, hops, payload, Message.Network.UNKNOWN);
    }

    @Override
    public QueryReply createQueryReply(byte[] guid, QueryReply reply) {
        try {
            return this.createFromNetwork(guid, reply.getTTL(), reply.getHops(), reply.getPayload());
        }
        catch (BadPacketException bpe) {
            throw new IllegalArgumentException("Invalid QR", bpe);
        }
    }

    @Override
    public QueryReply createWithNewAddress(byte[] ip, QueryReply reply) {
        if (Arrays.equals(ip, reply.getIPBytes())) {
            return reply;
        }
        byte[] payload = (byte[])reply.getPayload().clone();
        System.arraycopy(ip, 0, payload, 3, 4);
        try {
            return this.createFromNetwork(reply.getGUID(), reply.getTTL(), reply.getHops(), payload);
        }
        catch (BadPacketException bpe) {
            throw new IllegalArgumentException("Invalid QR", bpe);
        }
    }

    QueryReply createWithNewGGEP(QueryReplyImpl original, byte[] ggep) {
        int qhdOffset = original.getQHDOffset();
        if (qhdOffset == -1) {
            return original;
        }
        byte[] payload = original.getPayload();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(original.getPayload(), 0, qhdOffset);
        int length = ByteUtils.ubyte2int(payload[qhdOffset]);
        if (length == 1) {
            baos.write(2);
            byte flag = payload[qhdOffset + 1];
            flag = (byte)(flag | 0x20);
            baos.write(flag);
            baos.write(flag);
        } else {
            baos.write(length);
            byte control = (byte)(payload[qhdOffset + 1] | 0x20);
            byte flags = (byte)(payload[qhdOffset + 2] | 0x20);
            baos.write(control);
            baos.write(flags);
            baos.write(payload, qhdOffset + 3, length - 2);
        }
        try {
            baos.write(ggep);
        }
        catch (IOException impossible) {
            return original;
        }
        if (original.getGGEPEnd() != -1) {
            baos.write(payload, original.getGGEPEnd(), payload.length - original.getGGEPEnd());
        } else {
            baos.write(payload, payload.length - 16, 16);
        }
        byte[] newPayload = baos.toByteArray();
        try {
            return this.createFromNetwork(original.getGUID(), original.getTTL(), original.getHops(), newPayload, original.getNetwork());
        }
        catch (BadPacketException bad) {
            throw new RuntimeException(bad);
        }
    }

    @Override
    public QueryReply createWithReturnPathInfo(QueryReply query, IpPort me, IpPort source) {
        GGEP toAdd;
        QueryReplyImpl original = (QueryReplyImpl)query;
        byte[] payload = original.getPayload();
        if (original.getGGEPStart() != -1 && original.getGGEPEnd() != -1) {
            try {
                toAdd = new GGEP(payload, original.getGGEPStart());
            }
            catch (BadGGEPBlockException bad) {
                return original;
            }
        } else {
            toAdd = new GGEP();
        }
        this.addReturnPathInfo(me, source, original.getHops(), original.getTTL(), toAdd);
        return this.createWithNewGGEP(original, toAdd.toByteArray());
    }

    private void addReturnPathInfo(IpPort me, IpPort source, byte hops, byte ttl, GGEP ggep) {
        String suffix = this.getReturnPathSuffix(ggep);
        if (suffix == null) {
            return;
        }
        if (me != null) {
            byte[] myAddr = new byte[6];
            System.arraycopy(me.getInetAddress().getAddress(), 0, myAddr, 0, 4);
            ByteUtils.short2beb((short)me.getPort(), myAddr, 4);
            ggep.put("RPI" + suffix, myAddr);
        }
        byte[] theirAddr = new byte[6];
        System.arraycopy(source.getInetAddress().getAddress(), 0, theirAddr, 0, 4);
        ByteUtils.short2beb((short)source.getPort(), theirAddr, 4);
        ggep.put("RPS" + suffix, theirAddr);
        ggep.put("RPH" + suffix, hops);
        ggep.put("RPT" + suffix, ttl);
    }

    private String getReturnPathSuffix(GGEP ggep) {
        for (int i = 0; i < 100000; ++i) {
            if (ggep.hasKey("RPI" + i) || ggep.hasKey("RPS" + i) || ggep.hasKey("RPH" + i) || ggep.hasKey("RPT" + i)) continue;
            return String.valueOf(i);
        }
        return null;
    }

    @Override
    public QueryReply createFromNetwork(byte[] guid, byte ttl, byte hops, byte[] payload, Message.Network network) throws BadPacketException {
        return new QueryReplyImpl(guid, ttl, hops, payload, network, this.networkInstanceUtils, this.networkManager, this.responseFactory);
    }

    protected QueryReply createInternal(byte[] guid, byte ttl, int port, byte[] ip, long speed, Response[] responses, byte[] clientGUID, byte[] xmlBytes, boolean includeQHD, boolean needsPush, boolean isBusy, boolean finishedUpload, boolean measuredSpeed, boolean supportsChat, boolean supportsBH, boolean isMulticastReply, boolean supportsFWTransfer, Set<? extends IpPort> proxies, SecurityToken securityToken) {
        return new QueryReplyImpl(guid, ttl, port, ip, speed, responses, clientGUID, xmlBytes, includeQHD, needsPush, isBusy, finishedUpload, measuredSpeed, supportsChat, supportsBH, isMulticastReply, supportsFWTransfer, proxies, securityToken, this.networkInstanceUtils, this.networkManager, this.responseFactory);
    }
}

