/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.RoutableGGEPMessage;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.GGEP;

public class AdvancedStatsToggle
extends RoutableGGEPMessage {
    private static final int VERSION = 1;
    static final String TIME_KEY = "T";
    static final String OFF_KEY = "OFF";
    private final int time;

    public AdvancedStatsToggle(byte[] guid, byte ttl, byte hops, int version, byte[] payload, Message.Network network) throws BadPacketException {
        super(guid, ttl, hops, F_LIME_VENDOR_ID, 32, version, payload, network);
        try {
            this.time = this.ggep.hasKey(OFF_KEY) ? -1 : this.ggep.getInt(TIME_KEY);
        }
        catch (BadGGEPPropertyException bad) {
            throw new BadPacketException();
        }
    }

    public AdvancedStatsToggle(RoutableGGEPMessage.GGEPSigner signer, long version, int time) {
        super(F_LIME_VENDOR_ID, 32, 1, signer, AdvancedStatsToggle.deriveGGEP(version, time));
        this.time = time;
    }

    private static GGEP deriveGGEP(long version, int time) {
        GGEP g = new GGEP();
        if (time >= 0) {
            g.put(TIME_KEY, time);
        } else {
            g.put(OFF_KEY);
        }
        if (version >= 0L) {
            g.put("V", version);
        }
        return g;
    }

    public boolean shutOffNow() {
        return this.time < 0;
    }

    public int getTime() {
        return this.time;
    }
}

