/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.audio.writer;

import com.limegroup.gnutella.metadata.audio.AudioMetaData;
import com.limegroup.gnutella.metadata.audio.writer.AudioDataEditor;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.id3.AbstractTag;
import org.jaudiotagger.tag.id3.ID3v11Tag;
import org.jaudiotagger.tag.id3.ID3v1Tag;
import org.jaudiotagger.tag.id3.ID3v23Tag;

public class MP3DataEditor
extends AudioDataEditor {
    @Override
    protected Tag createTag(AudioFile audioFile, AudioMetaData audioData) {
        if (audioFile.getTag() == null) {
            return new ID3v23Tag();
        }
        MP3File mp3File = (MP3File)audioFile;
        if (mp3File.hasID3v2Tag()) {
            return mp3File.getID3v2Tag();
        }
        if (mp3File.hasID3v1Tag()) {
            ID3v1Tag tag = mp3File.getID3v1Tag();
            if (audioData.getLicense() != null && !audioData.getLicense().equals("")) {
                return new ID3v23Tag((AbstractTag)tag);
            }
            if (tag instanceof ID3v11Tag) {
                return tag;
            }
            return new ID3v11Tag((AbstractTag)tag);
        }
        return new ID3v23Tag();
    }

    @Override
    public String[] getSupportedExtensions() {
        return new String[]{"mp3"};
    }
}

