/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.video.reader;

import com.limegroup.gnutella.metadata.MetaReader;
import com.limegroup.gnutella.metadata.video.VideoMetaData;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.limewire.io.IOUtils;
import org.limewire.util.ByteUtils;

public class RIFFMetaData
implements MetaReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VideoMetaData parse(File f) throws IOException {
        VideoMetaData videoMetaData;
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            DataInputStream dis = new DataInputStream(is);
            VideoMetaData videoData = new VideoMetaData();
            this.readRIFFHeader(videoData, dis);
            videoMetaData = videoData;
        }
        catch (Throwable throwable) {
            IOUtils.close(is);
            throw throwable;
        }
        IOUtils.close(is);
        return videoMetaData;
    }

    private void readRIFFHeader(VideoMetaData videoData, DataInputStream dis) throws IOException {
        byte[] dword = new byte[4];
        dis.readFully(dword);
        if (dword[0] != 82 || dword[1] != 73 || dword[2] != 70 || dword[3] != 70) {
            return;
        }
        IOUtils.ensureSkip(dis, 4L);
        dis.readFully(dword);
        if (dword[0] != 65 || dword[1] != 86 || dword[2] != 73 || dword[3] != 32) {
            return;
        }
        IOUtils.ensureSkip(dis, 12L);
        IOUtils.ensureSkip(dis, 8L);
        dis.readFully(dword);
        int microsPerFrame = ByteUtils.leb2int(dword, 0, 4);
        IOUtils.ensureSkip(dis, 12L);
        dis.readFully(dword);
        int totalFrames = ByteUtils.leb2int(dword, 0, 4);
        videoData.setLength((short)(1L * (long)microsPerFrame * (long)totalFrames / 1000L / 1000L));
        IOUtils.ensureSkip(dis, 4L);
        dis.readFully(dword);
        IOUtils.ensureSkip(dis, 4L);
        dis.readFully(dword);
        videoData.setWidth(ByteUtils.leb2int(dword, 0, 4));
        dis.readFully(dword);
        videoData.setHeight(ByteUtils.leb2int(dword, 0, 4));
        IOUtils.ensureSkip(dis, 16L);
    }

    @Override
    public String[] getSupportedExtensions() {
        return new String[]{"avi"};
    }
}

