/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree;

import com.google.inject.Singleton;
import com.limegroup.gnutella.security.Tiger;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.HashTreeNodeManager;
import com.limegroup.gnutella.tigertree.HashTreeUtils;
import java.util.ArrayList;
import java.util.List;
import org.limewire.collection.FixedsizeForgetfulHashMap;

@Singleton
class HashTreeNodeManagerImpl
implements HashTreeNodeManager {
    private static final int MAX_NODES = 500;
    private FixedsizeForgetfulHashMap<HashTree, List<List<byte[]>>> MAP = new FixedsizeForgetfulHashMap(250);
    private int _currentNodes = 0;

    HashTreeNodeManagerImpl() {
    }

    @Override
    public List<List<byte[]>> getAllNodes(HashTree tree) {
        int depth = tree.getDepth();
        if (tree.getDepth() == 0) {
            ArrayList<List<byte[]>> outer = new ArrayList<List<byte[]>>(1);
            outer.add(tree.getNodes());
            return outer;
        }
        if (depth < 2 || depth >= 7) {
            return HashTreeUtils.createAllParentNodes(tree.getNodes(), new Tiger());
        }
        return this.getAllNodesImpl(tree);
    }

    @Override
    public void register(HashTree tree, List<List<byte[]>> nodes) {
        int depth = tree.getDepth();
        if (depth > 2 && depth < 7 && !this.MAP.containsKey(tree)) {
            this.insertEntry(tree, nodes);
        }
    }

    private synchronized List<List<byte[]>> getAllNodesImpl(HashTree tree) {
        List<List<byte[]>> nodes = (List<List<byte[]>>)this.MAP.get(tree);
        if (nodes != null) {
            this.MAP.put(tree, nodes);
            return nodes;
        }
        nodes = HashTreeUtils.createAllParentNodes(tree.getNodes(), new Tiger());
        this.insertEntry(tree, nodes);
        return nodes;
    }

    private synchronized void insertEntry(HashTree tree, List<List<byte[]>> nodes) {
        int size = HashTreeNodeManagerImpl.calculateSize(nodes);
        while (this._currentNodes + size > 500) {
            if (this.MAP.isEmpty()) {
                throw new IllegalStateException("current: " + this._currentNodes + ", size: " + size);
            }
            this.purgeLRU();
        }
        this._currentNodes += size;
        this.MAP.put(tree, nodes);
    }

    private synchronized void purgeLRU() {
        List<List<byte[]>> nodes = this.MAP.removeLRUEntry().getValue();
        this._currentNodes -= HashTreeNodeManagerImpl.calculateSize(nodes);
    }

    private static int calculateSize(List<List<byte[]>> nodes) {
        int size = 0;
        for (List<byte[]> next : nodes) {
            size += next.size();
        }
        return size;
    }
}

