/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.xml.SchemaFieldInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class LimeXMLSchemaFieldExtractor {
    private Map<String, List<SchemaFieldInfoPair>> _nameSchemaFieldInfoListMap = new HashMap<String, List<SchemaFieldInfoPair>>();
    private static final String DUMMY = "DUMMY";
    private static final String DUMMY_SIMPLETYPE = "DUMMY_SIMPLETYPE";
    private static final Set<String> PRIMITIVE_TYPES = new HashSet<String>();
    private int _uniqueCount = 1;
    private String _lastUniqueComplexTypeName = "";
    private SchemaFieldInfo _lastFieldInfoObject = null;
    private Set<String> _referencedNames = new HashSet<String>();

    LimeXMLSchemaFieldExtractor() {
    }

    public List<SchemaFieldInfo> getFields(Document document) {
        if (document == null) {
            throw new NullPointerException("null document");
        }
        Element root = document.getDocumentElement();
        this.traverse(root);
        String rootElementName = this.getRootElementName();
        LinkedList<SchemaFieldInfo> fieldNames = new LinkedList<SchemaFieldInfo>();
        this.fillWithFieldNames(fieldNames, this._nameSchemaFieldInfoListMap.get(rootElementName), rootElementName);
        return fieldNames;
    }

    private void fillWithFieldNames(List<? super SchemaFieldInfo> fieldNames, List<? extends SchemaFieldInfoPair> fieldInfoList, String prefix) {
        for (SchemaFieldInfoPair schemaFieldInfoPair : fieldInfoList) {
            List<SchemaFieldInfoPair> newSchemaFieldInfoList = this._nameSchemaFieldInfoListMap.get(schemaFieldInfoPair.getSchemaFieldInfo().getType());
            String field = schemaFieldInfoPair.getField();
            SchemaFieldInfo fieldInfo = schemaFieldInfoPair.getSchemaFieldInfo();
            if (newSchemaFieldInfoList == null) {
                if (!this.isDummy(field)) {
                    fieldInfo.setCanonicalizedFieldName(prefix + "__" + field);
                } else {
                    fieldInfo.setCanonicalizedFieldName(prefix);
                }
                fieldNames.add(fieldInfo);
                continue;
            }
            if (!this.isDummy(field)) {
                this.fillWithFieldNames(fieldNames, newSchemaFieldInfoList, prefix + "__" + field);
                continue;
            }
            this.fillWithFieldNames(fieldNames, newSchemaFieldInfoList, prefix);
        }
    }

    private boolean isDummy(String field) {
        return field.trim().equals(DUMMY);
    }

    private String getRootElementName() {
        HashSet<String> possibleRoots = new HashSet<String>(this._nameSchemaFieldInfoListMap.keySet());
        for (String string : this._referencedNames) {
            possibleRoots.remove(string);
        }
        return (String)possibleRoots.iterator().next();
    }

    private void traverse(Node n) {
        String name = n.getNodeName();
        if (LimeXMLSchemaFieldExtractor.isElementTag(name)) {
            this.processElementTag(n);
            NodeList children = n.getChildNodes();
            int numChildren = children.getLength();
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                this.traverse(child);
            }
        } else if (this.isComplexTypeTag(name)) {
            this.processComplexTypeTag(n);
        } else if (this.isSimpleTypeTag(name)) {
            LimeXMLSchemaFieldExtractor.processSimpleTypeForEnumeration(n, this._lastFieldInfoObject);
        } else {
            this.traverseChildren(n);
        }
    }

    private void processComplexTypeTag(Node n) {
        String name = this._lastUniqueComplexTypeName;
        NamedNodeMap attributes = n.getAttributes();
        Node nameAttribute = attributes.getNamedItem("name");
        if (nameAttribute != null) {
            name = nameAttribute.getNodeValue();
        }
        LinkedList<SchemaFieldInfoPair> fieldInfoList = new LinkedList<SchemaFieldInfoPair>();
        NodeList children = n.getChildNodes();
        int numChildren = children.getLength();
        for (int i = 0; i < numChildren; ++i) {
            Node child = children.item(i);
            this.processChildOfComplexType(child, fieldInfoList);
        }
        this._nameSchemaFieldInfoListMap.put(name, fieldInfoList);
        this._referencedNames.add(name);
    }

    private void processChildOfComplexType(Node n, List<SchemaFieldInfoPair> fieldInfoList) {
        String nodeName = n.getNodeName();
        if (LimeXMLSchemaFieldExtractor.isElementTag(nodeName)) {
            this.processChildElementTag(n, fieldInfoList);
        } else if (this.isAttributeTag(nodeName)) {
            this.processChildAttributeTag(n, fieldInfoList);
        } else {
            NodeList children = n.getChildNodes();
            int numChildren = children.getLength();
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                this.processChildOfComplexType(child, fieldInfoList);
            }
        }
    }

    private void processChildElementTag(Node n, List<SchemaFieldInfoPair> fieldInfoList) {
        NamedNodeMap attributes = n.getAttributes();
        SchemaFieldInfo schemaFieldInfo = null;
        Node nameAttribute = attributes.getNamedItem("name");
        if (nameAttribute == null) {
            Node refAttribute = attributes.getNamedItem("ref");
            if (refAttribute == null) {
                return;
            }
            String refName = refAttribute.getNodeValue();
            schemaFieldInfo = new SchemaFieldInfo(refName);
            fieldInfoList.add(new SchemaFieldInfoPair(refName, schemaFieldInfo));
            this._referencedNames.add(refName);
        } else {
            String typeName;
            String name = nameAttribute.getNodeValue();
            Node typeAttribute = attributes.getNamedItem("type");
            if (typeAttribute != null) {
                typeName = typeAttribute.getNodeValue();
            } else {
                this._lastUniqueComplexTypeName = typeName = this.getUniqueComplexTypeName();
            }
            schemaFieldInfo = new SchemaFieldInfo(this.removeNameSpace(typeName));
            fieldInfoList.add(new SchemaFieldInfoPair(name, schemaFieldInfo));
            this._lastFieldInfoObject = schemaFieldInfo;
            this.traverseChildren(n);
        }
    }

    private String removeNameSpace(String typeName) {
        if (typeName.indexOf(58) == -1) {
            return typeName;
        }
        return typeName.substring(typeName.indexOf(58) + 1);
    }

    private void processChildAttributeTag(Node n, List<SchemaFieldInfoPair> fieldInfoList) {
        Node widthAttribute;
        Node defaultVizAttribute;
        Node invisibleAttribute;
        Node hiddenAttribute;
        NamedNodeMap attributes = n.getAttributes();
        Node nameAttribute = attributes.getNamedItem("name");
        if (nameAttribute == null) {
            return;
        }
        String name = nameAttribute.getNodeValue() + "__";
        Node typeAttribute = attributes.getNamedItem("type");
        String typeName = typeAttribute == null ? DUMMY_SIMPLETYPE : typeAttribute.getNodeValue();
        SchemaFieldInfo fieldInfo = new SchemaFieldInfo(this.removeNameSpace(typeName));
        Node editableAttribute = attributes.getNamedItem("editable");
        if (editableAttribute != null && editableAttribute.getNodeValue().equalsIgnoreCase("false")) {
            fieldInfo.setEditable(false);
        }
        if ((hiddenAttribute = attributes.getNamedItem("hidden")) != null && hiddenAttribute.getNodeValue().equalsIgnoreCase("true")) {
            fieldInfo.setHidden(true);
        }
        if ((invisibleAttribute = attributes.getNamedItem("invisible")) != null && invisibleAttribute.getNodeValue().equalsIgnoreCase("true")) {
            fieldInfo.setInvisible(true);
        }
        if ((defaultVizAttribute = attributes.getNamedItem("defaultViz")) != null && defaultVizAttribute.getNodeValue().equalsIgnoreCase("true")) {
            fieldInfo.setDefaultVisibility(true);
        }
        if ((widthAttribute = attributes.getNamedItem("width")) != null) {
            try {
                int i = Integer.parseInt(widthAttribute.getNodeValue());
                fieldInfo.setDefaultWidth(i);
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        LimeXMLSchemaFieldExtractor.processSimpleTypeForEnumeration(n, fieldInfo);
        this.addAttributeSchemaFieldInfoPair(new SchemaFieldInfoPair(name, fieldInfo), fieldInfoList);
    }

    private void addAttributeSchemaFieldInfoPair(SchemaFieldInfoPair schemaFieldInfoPair, List<SchemaFieldInfoPair> fieldInfoList) {
        int attributeCount = 0;
        for (SchemaFieldInfoPair nextElement : fieldInfoList) {
            if (!this.isAttribute(nextElement.getField())) break;
            ++attributeCount;
        }
        fieldInfoList.add(attributeCount, schemaFieldInfoPair);
    }

    private static void processSimpleTypeForEnumeration(Node n, SchemaFieldInfo fieldInfo) {
        NodeList children = n.getChildNodes();
        int numChildren = children.getLength();
        for (int i = 0; i < numChildren; ++i) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (!LimeXMLSchemaFieldExtractor.isEnumerationTag(nodeName)) {
                LimeXMLSchemaFieldExtractor.processSimpleTypeForEnumeration(child, fieldInfo);
                continue;
            }
            Node nameAttribute = child.getAttributes().getNamedItem("name");
            Node valueAttribute = child.getAttributes().getNamedItem("value");
            String name = null;
            String value = null;
            if (nameAttribute != null) {
                name = nameAttribute.getNodeValue();
            }
            if (valueAttribute != null) {
                value = valueAttribute.getNodeValue();
            }
            if (value == null || value.equals("")) continue;
            if (name == null || name.equals("")) {
                fieldInfo.addEnumerationNameValue(value, value);
                continue;
            }
            fieldInfo.addEnumerationNameValue(name, value);
        }
    }

    private void traverseChildren(Node n) {
        NodeList children = n.getChildNodes();
        int numChildren = children.getLength();
        for (int i = 0; i < numChildren; ++i) {
            Node child = children.item(i);
            this.traverse(child);
        }
    }

    private boolean isComplexTypeTag(String tag) {
        return tag.trim().equals("complexType") || tag.trim().equals("xsd:complexType");
    }

    private boolean isSimpleTypeTag(String tag) {
        return tag.trim().equals("simpleType") || tag.trim().equals("xsd:simpleType");
    }

    private boolean isAttributeTag(String tag) {
        return tag.trim().equals("attribute") || tag.trim().equals("xsd:attribute");
    }

    private void processElementTag(Node n) {
        String typeName;
        NamedNodeMap attributes = n.getAttributes();
        Node nameAttribute = attributes.getNamedItem("name");
        if (nameAttribute == null) {
            return;
        }
        String name = nameAttribute.getNodeValue();
        Node typeAttribute = attributes.getNamedItem("type");
        if (typeAttribute != null) {
            typeName = typeAttribute.getNodeValue();
        } else {
            this._lastUniqueComplexTypeName = typeName = this.getUniqueComplexTypeName();
        }
        this.addToSchemaFieldInfoListMap(name, typeName);
    }

    private String getUniqueComplexTypeName() {
        return "COMPLEXTYPE___" + this._uniqueCount++;
    }

    private void addToSchemaFieldInfoListMap(String field, String typeName) {
        LinkedList<SchemaFieldInfoPair> fieldInfoList = new LinkedList<SchemaFieldInfoPair>();
        fieldInfoList.add(new SchemaFieldInfoPair(DUMMY, new SchemaFieldInfo(this.removeNameSpace(typeName))));
        this._nameSchemaFieldInfoListMap.put(field, fieldInfoList);
        this._referencedNames.add(this.removeNameSpace(typeName));
    }

    private static boolean isElementTag(String tag) {
        return tag.trim().equals("element") || tag.trim().equals("xsd:element");
    }

    private static boolean isEnumerationTag(String tag) {
        return tag.trim().equals("enumeration") || tag.trim().equals("xsd:enumeration");
    }

    public boolean isAttribute(String field) {
        return field.endsWith("__");
    }

    static {
        PRIMITIVE_TYPES.add("xsi:string");
        PRIMITIVE_TYPES.add("string");
        PRIMITIVE_TYPES.add("xsi:boolean");
        PRIMITIVE_TYPES.add("boolean");
        PRIMITIVE_TYPES.add("xsi:float");
        PRIMITIVE_TYPES.add("float");
        PRIMITIVE_TYPES.add("xsi:double");
        PRIMITIVE_TYPES.add("double");
        PRIMITIVE_TYPES.add("xsi:decimal");
        PRIMITIVE_TYPES.add("decimal");
        PRIMITIVE_TYPES.add("xsi:timeDuration");
        PRIMITIVE_TYPES.add("timeDuration");
        PRIMITIVE_TYPES.add("xsi:recurringDuration");
        PRIMITIVE_TYPES.add("recurringDuration");
        PRIMITIVE_TYPES.add("xsi:binary");
        PRIMITIVE_TYPES.add("binary");
        PRIMITIVE_TYPES.add("xsi:uriReference");
        PRIMITIVE_TYPES.add("uriReference");
        PRIMITIVE_TYPES.add("xsi:ID");
        PRIMITIVE_TYPES.add("ID");
        PRIMITIVE_TYPES.add("xsi:IDREF");
        PRIMITIVE_TYPES.add("IDREF");
        PRIMITIVE_TYPES.add("xsi:ENTITY");
        PRIMITIVE_TYPES.add("ENTITY");
        PRIMITIVE_TYPES.add("xsi:NUMTOKEN");
        PRIMITIVE_TYPES.add("NUMTOKEN");
        PRIMITIVE_TYPES.add("xsi:Qname");
        PRIMITIVE_TYPES.add("Qname");
    }

    private static class SchemaFieldInfoPair {
        private String _field;
        private SchemaFieldInfo _fieldInfo;

        public SchemaFieldInfoPair(String field, SchemaFieldInfo fieldInfo) {
            this._field = field;
            this._fieldInfo = fieldInfo;
        }

        public String getField() {
            return this._field;
        }

        public SchemaFieldInfo getSchemaFieldInfo() {
            return this._fieldInfo;
        }

        public String toString() {
            return "[" + this._field + ":" + this._fieldInfo + "]";
        }
    }
}

