/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.DaapResponseWriter;
import de.kapsi.net.daap.DaapServer;
import de.kapsi.net.daap.DaapSession;
import de.kapsi.net.daap.DaapUtil;
import de.kapsi.net.daap.Library;
import de.kapsi.net.daap.SessionId;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DaapConnection {
    private static final Log LOG = LogFactory.getLog(DaapConnection.class);
    public static final int TIMEOUT = 3000;
    public static final int LIBRARY_TIMEOUT = 30000;
    protected final DaapResponseWriter writer;
    protected DaapServer server;
    protected DaapSession session;
    protected ConnectionType type = ConnectionType.UNDEF;
    protected int protocolVersion = 0;
    protected String nonce;
    protected List<Library> libraryQueue;
    protected boolean locked = false;

    public DaapConnection(DaapServer server) {
        this.server = server;
        this.writer = new DaapResponseWriter();
        this.libraryQueue = new LinkedList<Library>();
    }

    public abstract void update() throws IOException;

    public boolean write() throws IOException {
        return !this.writer.write() || !this.isAudioStream();
    }

    public void close() {
        this.writer.clear();
        if (this.session != null) {
            this.session.invalidate();
            this.session = null;
        }
    }

    public DaapServer getServer() {
        return this.server;
    }

    protected void setConnectionType(ConnectionType type) {
        this.type = type;
    }

    protected void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public boolean isAudioStream() {
        return ConnectionType.AUDIO.equals((Object)this.type);
    }

    public boolean isDaapConnection() {
        return ConnectionType.DAAP.equals((Object)this.type);
    }

    public boolean isUndef() {
        return ConnectionType.UNDEF.equals((Object)this.type);
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public DaapSession getSession(boolean create) {
        if (this.session == null && create) {
            this.session = new DaapSession(this.server.createSessionId());
        }
        return this.session;
    }

    public SessionId getSessionId(boolean create) {
        SessionId sessionId = SessionId.INVALID;
        DaapSession session = this.getSession(create);
        if (session != null) {
            sessionId = session.getSessionId();
        }
        return sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLibraryQueue() {
        List<Library> list = this.libraryQueue;
        synchronized (list) {
            this.libraryQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueLibrary(Library library) {
        List<Library> list = this.libraryQueue;
        synchronized (list) {
            this.libraryQueue.add(library);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Library getFirstInQueue() {
        List<Library> list = this.libraryQueue;
        synchronized (list) {
            if (!this.libraryQueue.isEmpty()) {
                return this.libraryQueue.get(0);
            }
            return this.server.getLibrary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Library getLastInQueue() {
        List<Library> list = this.libraryQueue;
        synchronized (list) {
            if (!this.libraryQueue.isEmpty()) {
                return this.libraryQueue.get(this.libraryQueue.size() - 1);
            }
            return this.server.getLibrary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Library nextLibrary(DaapRequest request) {
        List<Library> list = this.libraryQueue;
        synchronized (list) {
            int delta = request.getDelta();
            if (delta == 0 || this.libraryQueue.isEmpty()) {
                return this.server.getLibrary();
            }
            Library first = this.libraryQueue.get(0);
            if (first.getRevision() != request.getRevisionNumber()) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Client doesn't request the current revision: " + delta + "/" + request.getRevisionNumber() + "/" + first.getRevision());
                }
                this.clearLibraryQueue();
                return null;
            }
            if (delta > first.getRevision()) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Client is ahead of us: " + delta + "/" + first.getRevision());
                }
                this.clearLibraryQueue();
                return null;
            }
            if (first.getRevision() == delta) {
                this.libraryQueue.remove(0);
                if (this.libraryQueue.isEmpty()) {
                    return this.server.getLibrary();
                }
                if (request.getRevisionNumber() != delta) {
                    return this.nextLibrary(request);
                }
                return this.nextLibrary(new DaapRequest(this, this.getSessionId(false), request.getRevisionNumber() + 1, delta));
            }
            return first;
        }
    }

    protected synchronized void lock() {
        this.locked = true;
    }

    protected synchronized void unlock() {
        this.locked = false;
    }

    protected synchronized boolean isLocked() {
        return this.locked;
    }

    synchronized String getNonce() {
        return this.nonce;
    }

    synchronized String createNonce() {
        this.nonce = DaapUtil.nonce();
        return this.nonce;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ConnectionType {
        UNDEF,
        DAAP,
        AUDIO;

    }
}

