/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.bio;

import de.kapsi.net.daap.DaapConfig;
import de.kapsi.net.daap.DaapConnection;
import de.kapsi.net.daap.DaapServer;
import de.kapsi.net.daap.DaapThreadFactory;
import de.kapsi.net.daap.Library;
import de.kapsi.net.daap.SessionId;
import de.kapsi.net.daap.bio.DaapConnectionBIO;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaapServerBIO
extends DaapServer<DaapConnectionBIO> {
    private static final Log LOG = LogFactory.getLog(DaapServerBIO.class);
    private int threadNo = 0;
    private DaapThreadFactory threadFactory = new DaapThreadFactoryImpl();
    private ServerSocket ssocket;

    public DaapServerBIO(Library library) {
        this(library, new DaapConfig());
    }

    public DaapServerBIO(Library library, DaapConfig config) {
        super(library, config);
    }

    @Override
    public synchronized void setThreadFactory(DaapThreadFactory factory) {
        this.threadFactory = factory == null ? new DaapThreadFactoryImpl() : factory;
    }

    @Override
    public synchronized void bind() throws IOException {
        if (this.isRunning()) {
            return;
        }
        InetSocketAddress bindAddr = this.config.getInetSocketAddress();
        int backlog = this.config.getBacklog();
        this.ssocket = new ServerSocket();
        this.ssocket.bind(bindAddr, backlog);
        if (LOG.isInfoEnabled()) {
            LOG.info("DaapServerBIO bound to " + bindAddr);
        }
    }

    @Override
    public synchronized void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.running = false;
        try {
            if (this.ssocket != null) {
                this.ssocket.close();
            }
        }
        catch (IOException err) {
            LOG.error(err);
        }
        this.disconnectAll();
    }

    @Override
    public synchronized void disconnectAll() {
        for (DaapConnectionBIO connection : this.connections) {
            connection.disconnect();
        }
        this.clear();
    }

    @Override
    protected synchronized void update() {
        for (DaapConnectionBIO conn : this.connections) {
            for (int i = 0; i < this.libraryQueue.size(); ++i) {
                conn.enqueueLibrary((Library)this.libraryQueue.get(i));
            }
            try {
                conn.update();
            }
            catch (IOException err) {
                LOG.error(err);
            }
        }
        this.libraryQueue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.threadNo = 0;
        this.running = true;
        try {
            while (this.running) {
                Socket socket = this.ssocket.accept();
                try {
                    DaapServerBIO daapServerBIO = this;
                    synchronized (daapServerBIO) {
                        if (this.running && this.accept(socket.getInetAddress())) {
                            socket.setSoTimeout(3000);
                            DaapConnectionBIO connection = new DaapConnectionBIO(this, socket);
                            this.addPendingConnection(connection);
                            Thread connThread = this.threadFactory.createDaapThread(connection, "DaapConnectionThread-" + ++this.threadNo);
                            connThread.start();
                        } else {
                            socket.close();
                        }
                    }
                }
                catch (IOException err) {
                    LOG.error(err);
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException err) {
            LOG.error(err);
        }
        catch (SocketException err) {
            if (this.running) {
                LOG.error(err);
            }
        }
        catch (IOException err) {
            LOG.error(err);
        }
        finally {
            this.stop();
        }
    }

    @Override
    protected synchronized DaapConnectionBIO getAudioConnection(SessionId sessionId) {
        return (DaapConnectionBIO)super.getAudioConnection(sessionId);
    }

    @Override
    protected synchronized DaapConnectionBIO getDaapConnection(SessionId sessionId) {
        return (DaapConnectionBIO)super.getDaapConnection(sessionId);
    }

    @Override
    protected synchronized boolean isSessionIdValid(SessionId sessionId) {
        return super.isSessionIdValid(sessionId);
    }

    @Override
    protected synchronized void removeConnection(DaapConnection connection) {
        super.removeConnection(connection);
    }

    @Override
    protected synchronized boolean updateConnection(DaapConnectionBIO connection) {
        if (!this.isRunning()) {
            return false;
        }
        return super.updateConnection(connection);
    }

    private static class DaapThreadFactoryImpl
    implements DaapThreadFactory {
        private DaapThreadFactoryImpl() {
        }

        public Thread createDaapThread(Runnable runnable, String name) {
            Thread thread = new Thread(runnable, name);
            thread.setDaemon(true);
            return thread;
        }
    }
}

