/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil;

import eu.medsea.mimeutil.MimeException;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtilMimeDetectorRegistry;
import eu.medsea.mimeutil.detector.MimeDetector;
import eu.medsea.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MimeUtil {
    private static Log log = LogFactory.getLog(MimeUtil.class);
    public static final MimeType DIRECTORY_MIME_TYPE = new MimeType("application/directory");
    public static final MimeType UNKNOWN_MIME_TYPE = new MimeType("application/octet-stream");
    private static final Pattern mimeSplitter = Pattern.compile("[/;]++");
    private static Map mimeTypes = new HashMap();
    private static MimeUtilMimeDetectorRegistry mimeUtilMimeDetector = new MimeUtilMimeDetectorRegistry();
    private static ByteOrder nativeByteOrder = ByteOrder.nativeOrder();

    public static void addKnownMimeType(MimeType mimeType) {
        MimeUtil.addKnownMimeType(mimeType.toString());
    }

    public static void addKnownMimeType(String string) {
        try {
            String string2 = MimeUtil.getMediaType(string);
            TreeSet<String> treeSet = (TreeSet<String>)mimeTypes.get(string2);
            if (treeSet == null) {
                treeSet = new TreeSet<String>();
            }
            treeSet.add(MimeUtil.getSubType(string));
            mimeTypes.put(string2, treeSet);
        }
        catch (MimeException mimeException) {
            // empty catch block
        }
    }

    public static void addMimeDetector(MimeDetector mimeDetector) {
        mimeUtilMimeDetector.addMimeDetector(mimeDetector);
    }

    public static String getExtension(File file) {
        return MimeUtil.getExtension(file.getName());
    }

    public static String getExtension(String string) {
        File file = new File(string);
        String string2 = file.getName();
        if (string2 == null || string2.indexOf(".") < 0) {
            return "";
        }
        return string2.substring(string2.indexOf(".") + 1);
    }

    public static MimeType getFirstMimeType(String string) {
        if (string != null && string.trim().length() != 0) {
            return new MimeType(string.split(",")[0].trim());
        }
        return null;
    }

    public static String getMediaType(String string) throws MimeException {
        return new MimeType(string).getMediaType();
    }

    public static double getMimeQuality(String string) throws MimeException {
        if (string == null) {
            throw new MimeException("Invalid MimeType [" + string + "].");
        }
        String[] stringArray = mimeSplitter.split(string);
        if (stringArray.length < 2) {
            throw new MimeException("Invalid MimeType [" + string + "].");
        }
        if (stringArray.length > 2) {
            for (int i = 2; i < stringArray.length; ++i) {
                if (!stringArray[i].trim().startsWith("q=")) continue;
                try {
                    double d = Double.parseDouble(stringArray[i].split("=")[1].trim());
                    return d > 1.0 ? 1.0 : d;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MimeException("Invalid Mime quality indicator [" + stringArray[i].trim() + "]. Must be a valid double between 0 and 1");
                }
                catch (Exception exception) {
                    throw new MimeException("Error parsing Mime quality indicator.", exception);
                }
            }
        }
        if (stringArray[0].contains("*")) {
            return 0.01;
        }
        if (stringArray[1].contains("*")) {
            return 0.02;
        }
        return 1.0;
    }

    public static MimeDetector getMimeDetector(String string) {
        return mimeUtilMimeDetector.getMimeDetector(string);
    }

    public static Collection getMimeTypes(byte[] byArray) throws MimeException {
        return MimeUtil.getMimeTypes(byArray, UNKNOWN_MIME_TYPE);
    }

    public static Collection getMimeTypes(byte[] byArray, MimeType mimeType) throws MimeException {
        if (log.isDebugEnabled()) {
            try {
                log.debug("Getting mime types for byte array [" + StringUtil.getHexString(byArray) + "].");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new MimeException(unsupportedEncodingException);
            }
        }
        return mimeUtilMimeDetector.getMimeTypes(byArray, mimeType);
    }

    public static Collection getMimeTypes(File file) throws MimeException {
        return MimeUtil.getMimeTypes(file, UNKNOWN_MIME_TYPE);
    }

    public static Collection getMimeTypes(File file, MimeType mimeType) throws MimeException {
        if (log.isDebugEnabled()) {
            log.debug("Getting mime types for file [" + file.getAbsolutePath() + "].");
        }
        return mimeUtilMimeDetector.getMimeTypes(file, mimeType);
    }

    public static Collection getMimeTypes(InputStream inputStream) throws MimeException {
        return MimeUtil.getMimeTypes(inputStream, UNKNOWN_MIME_TYPE);
    }

    public static Collection getMimeTypes(InputStream inputStream, MimeType mimeType) throws MimeException {
        if (log.isDebugEnabled()) {
            log.debug("Getting mime types for InputSteam [" + inputStream + "].");
        }
        if (!inputStream.markSupported()) {
            throw new MimeException("InputStream does not support mark and reset!");
        }
        return mimeUtilMimeDetector.getMimeTypes(inputStream, mimeType);
    }

    public static Collection getMimeTypes(String string) throws MimeException {
        return MimeUtil.getMimeTypes(string, UNKNOWN_MIME_TYPE);
    }

    public static Collection getMimeTypes(String string, MimeType mimeType) throws MimeException {
        if (log.isDebugEnabled()) {
            log.debug("Getting mime types for file name [" + string + "].");
        }
        return mimeUtilMimeDetector.getMimeTypes(string, mimeType);
    }

    public static Collection getMimeTypes(URLConnection uRLConnection) throws MimeException {
        return MimeUtil.getMimeTypes(uRLConnection, UNKNOWN_MIME_TYPE);
    }

    public static Collection getMimeTypes(URLConnection uRLConnection, MimeType mimeType) throws MimeException {
        if (log.isDebugEnabled()) {
            log.debug("Getting mime types for URL [" + uRLConnection + "].");
        }
        try {
            return mimeUtilMimeDetector.getMimeTypes(new BufferedInputStream(uRLConnection.getInputStream()), mimeType);
        }
        catch (Exception exception) {
            throw new MimeException(exception);
        }
    }

    public static ByteOrder getNativeOrder() {
        return nativeByteOrder;
    }

    public static MimeType getPreferedMimeType(String string, String string2) {
        if (string2 == null || string2.trim().length() == 0) {
            throw new MimeException("Must specify at least one mime type that can be provided.");
        }
        if (string == null || string.trim().length() == 0) {
            string = "*/*";
        }
        if (string.indexOf(":") > 0) {
            string = string.substring(string.indexOf(":") + 1);
        }
        string = string.replaceAll(" ", "");
        return MimeUtil.getBestMatch(string, MimeUtil.getList(string2));
    }

    public static MimeType getMostSpecificMimeType(Collection collection) {
        MimeType mimeType = null;
        int n = 0;
        for (MimeType mimeType2 : collection) {
            if (mimeType2.getSpecificity() <= n) continue;
            mimeType = mimeType2;
        }
        return mimeType;
    }

    public static String getSubType(String string) throws MimeException {
        return new MimeType(string).getSubType();
    }

    public static boolean isMimeTypeKnown(MimeType mimeType) {
        try {
            Set set = (Set)mimeTypes.get(mimeType.getMediaType());
            if (set == null) {
                return false;
            }
            return set.contains(mimeType.getSubType());
        }
        catch (MimeException mimeException) {
            return false;
        }
    }

    public static boolean isMimeTypeKnown(String string) {
        return MimeUtil.isMimeTypeKnown(new MimeType(string));
    }

    public static MimeDetector removeMimeDetector(MimeDetector mimeDetector) {
        return mimeUtilMimeDetector.removeMimeDetector(mimeDetector);
    }

    public static double getQuality(String string) throws MimeException {
        if (string == null || string.trim().length() == 0) {
            return 0.0;
        }
        String[] stringArray = mimeSplitter.split(string);
        if (stringArray.length > 2) {
            for (int i = 2; i < stringArray.length; ++i) {
                if (!stringArray[i].trim().startsWith("q=")) continue;
                try {
                    double d = Double.parseDouble(stringArray[i].split("=")[1].trim());
                    return d > 1.0 ? 1.0 : d;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MimeException("Invalid Mime quality indicator [" + stringArray[i].trim() + "]. Must be a valid double between 0 and 1");
                }
                catch (Exception exception) {
                    throw new MimeException("Error parsing Mime quality indicator.", exception);
                }
            }
        }
        if (stringArray[0].contains("*")) {
            return 0.01;
        }
        if (stringArray[1].contains("*")) {
            return 0.02;
        }
        return 1.0;
    }

    private static MimeType getBestMatch(String string, List list) {
        if (list.size() == 1) {
            return new MimeType((String)list.get(0));
        }
        Map map = MimeUtil.normaliseWantedMap(string, list);
        MimeType mimeType = null;
        double d = 0.0;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            List list2 = (List)map.get(iterator.next());
            for (String string2 : list2) {
                double d2 = MimeUtil.getMimeQuality(string2);
                String string3 = MimeUtil.getMediaType(string2);
                String string4 = MimeUtil.getSubType(string2);
                if (!(d2 > d)) continue;
                d = d2;
                mimeType = new MimeType(string3 + "/" + string4);
            }
        }
        return mimeType;
    }

    private static List getList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i].trim());
        }
        return arrayList;
    }

    private static Map normaliseWantedMap(String string, List list) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            List<String> list2;
            String string2 = stringArray[i].trim();
            String string3 = MimeUtil.getMediaType(string2);
            String string4 = MimeUtil.getSubType(string2);
            double d = MimeUtil.getMimeQuality(string2);
            if (string3.contains("*")) {
                for (String string5 : list) {
                    list2 = (ArrayList<String>)linkedHashMap.get(MimeUtil.getMediaType(string5));
                    if (list2 == null) {
                        list2 = new ArrayList<String>();
                    }
                    list2.add(string5 + ";q=" + d);
                    linkedHashMap.put(MimeUtil.getMediaType(string5), list2);
                }
                continue;
            }
            if (string4.contains("*")) {
                for (String string5 : list) {
                    if (!MimeUtil.getMediaType(string5).equals(string3)) continue;
                    list2 = (List)linkedHashMap.get(string3);
                    if (list2 == null) {
                        list2 = new ArrayList();
                    }
                    list2.add(string3 + "/" + MimeUtil.getSubType(string5) + ";q=" + d);
                    linkedHashMap.put(string3, list2);
                }
                continue;
            }
            if (!list.contains(string3 + "/" + string4)) continue;
            List<String> list3 = (List)linkedHashMap.get(string3);
            if (list3 == null) {
                list3 = new ArrayList<String>();
            }
            list3.add(string3 + "/" + string4 + ";q=" + d);
            linkedHashMap.put(string3, list3);
        }
        return linkedHashMap;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("java -jar mime-util-<version>.jar <file> [<file> ...]");
            System.exit(-1);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(stringArray[i]);
            System.out.println("File:[" + file.getAbsolutePath() + "] - " + MimeUtil.getMimeTypes(stringArray[i]));
        }
    }

    static {
        InputStream inputStream = MimeUtil.class.getResourceAsStream("/MimeDetectors");
        if (inputStream != null) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.trim().startsWith("#")) continue;
                    Class.forName(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

