/*
 * Decompiled with CFR 0.152.
 */
package javax.media;

import javax.media.Format;

public class Buffer {
    protected long timeStamp = -1L;
    protected long duration = -1L;
    protected Format format;
    protected int flags = 0;
    protected Object data;
    protected Object header;
    protected int length = 0;
    protected int offset = 0;
    protected long sequenceNumber = 0x7FFFFFFFFFFFFFFEL;
    public static final int FLAG_EOM = 1;
    public static final int FLAG_DISCARD = 2;
    public static final int FLAG_SILENCE = 4;
    public static final int FLAG_SID = 8;
    public static final int FLAG_KEY_FRAME = 16;
    public static final int FLAG_NO_DROP = 32;
    public static final int FLAG_NO_WAIT = 64;
    public static final int FLAG_NO_SYNC = 96;
    public static final int FLAG_SYSTEM_TIME = 128;
    public static final int FLAG_RELATIVE_TIME = 256;
    public static final int FLAG_FLUSH = 512;
    public static final int FLAG_SYSTEM_MARKER = 1024;
    public static final int FLAG_RTP_MARKER = 2048;
    public static final int FLAG_RTP_TIME = 4096;
    public static final int FLAG_BUF_OVERFLOWN = 8192;
    public static final int FLAG_BUF_UNDERFLOWN = 16384;
    public static final int FLAG_LIVE_DATA = 32768;
    public static final long TIME_UNKNOWN = -1L;
    public static final long SEQUENCE_UNKNOWN = 0x7FFFFFFFFFFFFFFEL;

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public boolean isEOM() {
        return (this.flags & 1) != 0;
    }

    public void setEOM(boolean eom) {
        this.flags = eom ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public boolean isDiscard() {
        return (this.flags & 2) != 0;
    }

    public void setDiscard(boolean discard) {
        this.flags = discard ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object getHeader() {
        return this.header;
    }

    public void setHeader(Object header) {
        this.header = header;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setSequenceNumber(long number) {
        this.sequenceNumber = number;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void copy(Buffer buffer) {
        this.copy(buffer, false);
    }

    public void copy(Buffer buffer, boolean swapData) {
        this.duration = buffer.duration;
        this.flags = buffer.flags;
        this.format = buffer.format;
        this.header = buffer.header;
        this.length = buffer.length;
        this.offset = buffer.offset;
        this.sequenceNumber = buffer.sequenceNumber;
        this.timeStamp = buffer.timeStamp;
        this.data = swapData ? Buffer.dupData(buffer.data, false) : buffer.data;
    }

    public Object clone() {
        Buffer result = new Buffer();
        result.duration = this.duration;
        result.flags = this.flags;
        result.format = this.format;
        result.header = Buffer.dupData(this.header, true);
        result.length = this.length;
        result.offset = this.offset;
        result.sequenceNumber = this.sequenceNumber;
        result.timeStamp = this.timeStamp;
        result.data = Buffer.dupData(this.data, true);
        return result;
    }

    private static Object dupData(Object data, boolean standardTypesOnly) {
        Object[] result;
        int len;
        if (data == null) {
            return null;
        }
        if (!data.getClass().isArray()) {
            throw new IllegalArgumentException();
        }
        if (data.getClass() == byte[].class) {
            len = ((byte[])data).length;
            result = new byte[len];
        } else if (data.getClass() == int[].class) {
            len = ((int[])data).length;
            result = new int[len];
        } else if (data.getClass() == short[].class) {
            len = ((short[])data).length;
            result = new short[len];
        } else if (!standardTypesOnly && data.getClass() == float[].class) {
            len = ((float[])data).length;
            result = new float[len];
        } else if (!standardTypesOnly && data.getClass() == double[].class) {
            len = ((double[])data).length;
            result = new double[len];
        } else if (!standardTypesOnly && data.getClass() == boolean[].class) {
            len = ((boolean[])data).length;
            result = new boolean[len];
        } else if (!standardTypesOnly && data.getClass() == long[].class) {
            len = ((long[])data).length;
            result = new long[len];
        } else if (!standardTypesOnly && data.getClass() == char[].class) {
            len = ((char[])data).length;
            result = new char[len];
        } else {
            return data;
        }
        System.arraycopy(data, 0, result, 0, len);
        return result;
    }
}

