/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.media.codec.audio.speex;

import com.ibm.media.codec.audio.AudioCodec;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.xiph.speex.SpeexEncoder;

public class JavaEncoder
extends AudioCodec {
    private Format lastFormat = null;
    private int numberOfChannels = 0;
    private static int FRAME_SIZE = 320;
    private SpeexEncoder encoder = null;

    public JavaEncoder() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1)};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("speex/rtp")};
        this.PLUGIN_NAME = "pcm to speex converter";
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        AudioFormat af = (AudioFormat)in;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("speex/rtp", af.getSampleRate(), 8, af.getChannels(), af.getEndian(), af.getSigned())};
        return this.supportedOutputFormats;
    }

    public void open() throws ResourceUnavailableException {
    }

    public void close() {
    }

    private void initConverter(AudioFormat inFormat) {
        this.lastFormat = inFormat;
        this.numberOfChannels = inFormat.getChannels();
        this.encoder = new SpeexEncoder();
        this.encoder.init(0, 4, (int)inFormat.getSampleRate(), 1);
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        Format newFormat = inputBuffer.getFormat();
        if (this.lastFormat != newFormat) {
            this.initConverter((AudioFormat)newFormat);
        }
        int inpLength = inputBuffer.getLength();
        byte[] inpData = (byte[])inputBuffer.getData();
        int inOffset = inputBuffer.getOffset();
        if (inpLength == 0) {
            return 4;
        }
        if (inpLength - inOffset >= FRAME_SIZE) {
            this.encoder.processData(inpData, inOffset, FRAME_SIZE);
            byte[] buff = new byte[this.encoder.getProcessedDataByteSize()];
            this.encoder.getProcessedData(buff, 0);
            byte[] outData = this.validateByteArraySize(outputBuffer, buff.length);
            System.arraycopy(buff, 0, outData, outputBuffer.getOffset(), buff.length);
            this.updateOutput(outputBuffer, this.outputFormat, outData.length, 0);
            if (inpLength - inOffset > FRAME_SIZE) {
                inputBuffer.setOffset(inOffset + FRAME_SIZE);
                return 2;
            }
            return 0;
        }
        return 4;
    }
}

