/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.filtergraph;

import java.util.logging.Level;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import net.sf.fmj.filtergraph.InputPin;
import net.sf.fmj.filtergraph.Node;
import net.sf.fmj.filtergraph.OutputPin;
import net.sf.fmj.utility.LoggingStringUtils;

public class CodecNode
extends Node {
    private final Codec codec;

    public CodecNode(Codec codec, Format inputFormat) {
        super(codec, 1, 1);
        this.setInputPin(0, new InputPin(this));
        this.setOutputPin(0, new OutputPin(this));
        this.getInputPin(0).setFormat(inputFormat);
        this.codec = codec;
    }

    public int getPlugInType() {
        return 2;
    }

    Format setPlugInInputFormat(InputPin pin, Format format) {
        return this.codec.setInputFormat(format);
    }

    Format setPlugInOutputFormat(OutputPin pin, Format format) {
        return this.codec.setOutputFormat(format);
    }

    public Node duplicate() {
        return this.propagateDuplicate(new CodecNode(this.getCodec(), this.getInputFormat()));
    }

    public Format getInputFormat() {
        return this.getInputPin(0).getFormat();
    }

    public Codec getCodec() {
        return this.codec;
    }

    public int process(Buffer input, int sourceTrackNumber, int destTrackNumber, int flags) {
        int processResult;
        if (input.getLength() == 0 && input.getData() == null) {
            logger.warning("Skipping processing of codec input buffer with length 0 and null buffer");
            return 4;
        }
        if (input.getFormat() == null) {
            input.setFormat(this.getInputFormat());
        }
        if (this.getOutputBuffer(0) == null) {
            this.setOutputBuffer(0, new Buffer());
        }
        Buffer buffer1 = this.getOutputBuffer(0);
        buffer1.setLength(0);
        buffer1.setTimeStamp(input.getTimeStamp());
        buffer1.setFlags(input.getFlags());
        if (buffer1.getFormat() == null) {
            buffer1.setFormat(this.getDestLink(0).getDestNode().getInputFormat());
        }
        buffer1.setSequenceNumber(input.getSequenceNumber());
        try {
            processResult = this.getCodec().process(input, buffer1);
        }
        catch (NullPointerException e) {
            logger.severe(LoggingStringUtils.bufferToStr(input));
            logger.severe(LoggingStringUtils.bufferToStr(buffer1));
            logger.log(Level.SEVERE, "" + e, e);
            throw e;
        }
        if (processResult != 0) {
            if (processResult == 4) {
                logger.finer("Codec process result for " + this.getCodec() + ": " + processResult);
            } else if (processResult == 2) {
                logger.finer("Codec process result for " + this.getCodec() + ": " + processResult);
            } else {
                logger.warning("Codec process result for " + this.getCodec() + ": " + LoggingStringUtils.plugInResultToStr(processResult));
            }
        }
        return processResult;
    }
}

