/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Track;
import net.sf.fmj.utility.LoggerSingleton;

public class TrackInputStream
extends InputStream {
    private static final Logger logger = LoggerSingleton.logger;
    private final Track track;
    private Buffer buffer;

    public TrackInputStream(Track track) {
        this.track = track;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    private void fillBuffer() {
        if (this.buffer == null) {
            this.buffer = new Buffer();
            this.buffer.setFormat(this.track.getFormat());
        }
        do {
            if (this.buffer.isEOM()) {
                return;
            }
            if (this.buffer.getLength() > 0) {
                return;
            }
            this.track.readFrame(this.buffer);
            logger.fine("Read buffer from track: " + this.buffer.getLength());
        } while (this.buffer.isDiscard());
    }

    public int read() throws IOException {
        this.fillBuffer();
        if (this.buffer.getLength() == 0 && this.buffer.isEOM()) {
            return -1;
        }
        byte[] data = (byte[])this.buffer.getData();
        int result = data[this.buffer.getOffset()] & 0xFF;
        this.buffer.setOffset(this.buffer.getOffset() + 1);
        this.buffer.setLength(this.buffer.getLength() - 1);
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.fillBuffer();
        if (this.buffer.getLength() == 0 && this.buffer.isEOM()) {
            return -1;
        }
        byte[] data = (byte[])this.buffer.getData();
        int lengthToCopy = this.buffer.getLength() < len ? this.buffer.getLength() : len;
        System.arraycopy(data, this.buffer.getOffset(), b, off, lengthToCopy);
        this.buffer.setOffset(this.buffer.getOffset() + lengthToCopy);
        this.buffer.setLength(this.buffer.getLength() - lengthToCopy);
        return lengthToCopy;
    }
}

