/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.datasink.file;

import com.lti.utils.synchronization.CloseableThread;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.IncompatibleSourceException;
import javax.media.datasink.EndOfStreamEvent;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceTransferHandler;
import net.sf.fmj.media.AbstractDataSink;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.URLUtils;

public class Handler
extends AbstractDataSink {
    private static final Logger logger = LoggerSingleton.logger;
    private PushDataSource source;
    private WriterThread writerThread;

    public Object getControl(String controlType) {
        logger.warning("TODO: getControl " + controlType);
        return null;
    }

    public Object[] getControls() {
        logger.warning("TODO: getControls");
        return new Object[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.writerThread != null) {
            this.writerThread.close();
            try {
                this.writerThread.waitUntilClosed();
            }
            catch (InterruptedException e) {
            }
            finally {
                this.writerThread = null;
            }
        }
        try {
            this.stop();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
        }
        if (this.source != null) {
            this.source.disconnect();
        }
    }

    public String getContentType() {
        if (this.source != null) {
            return this.source.getContentType();
        }
        return null;
    }

    public void open() throws IOException, SecurityException {
        if (this.getOutputLocator() == null) {
            throw new IOException("Output locator not set");
        }
        String path = URLUtils.extractValidNewFilePathFromFileUrl(this.getOutputLocator().toExternalForm());
        if (path == null) {
            throw new IOException("Cannot determine path from URL: " + this.getOutputLocator().toExternalForm());
        }
        File f = new File(path);
        if (f.exists()) {
            logger.fine("Deleting " + f.getAbsolutePath());
            if (!f.delete()) {
                throw new IOException("Unable to delete: " + f.getAbsolutePath());
            }
        }
        RandomAccessFile raf = new RandomAccessFile(f, "rw");
        PushSourceStream[] streams = this.source.getStreams();
        this.source.connect();
        this.writerThread = new WriterThread(this.source.getStreams()[0], raf);
        this.writerThread.setName("WriterThread for " + raf);
        this.writerThread.setDaemon(true);
    }

    public void start() throws IOException {
        this.source.start();
        this.writerThread.start();
    }

    public void stop() throws IOException {
        if (this.source != null) {
            this.source.stop();
        }
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        logger.finer("setSource: " + source);
        if (!(source instanceof PushDataSource)) {
            throw new IncompatibleSourceException();
        }
        this.source = (PushDataSource)source;
    }

    private class WriterThread
    extends CloseableThread
    implements SourceTransferHandler,
    Seekable {
        private final PushSourceStream sourceStream;
        private final RandomAccessFile raf;
        private static final boolean USE_TRANSFER_HANDLER = true;
        private static final int DEFAULT_BUFFER_SIZE = 10000;
        private Object dataAvailable = new Object();

        public boolean isRandomAccess() {
            return true;
        }

        public long seek(long where) {
            try {
                this.raf.seek(where);
                return this.raf.getFilePointer();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
                throw new RuntimeException(e);
            }
        }

        public long tell() {
            try {
                return this.raf.getFilePointer();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
                throw new RuntimeException(e);
            }
        }

        public WriterThread(PushSourceStream sourceStream, RandomAccessFile raf) {
            this.sourceStream = sourceStream;
            this.raf = raf;
            sourceStream.setTransferHandler(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transferData(PushSourceStream stream) {
            Object object = this.dataAvailable;
            synchronized (object) {
                this.dataAvailable.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            logger.fine("getMinimumTransferSize: " + this.sourceStream.getMinimumTransferSize());
            byte[] buffer = new byte[this.sourceStream.getMinimumTransferSize() > 10000 ? this.sourceStream.getMinimumTransferSize() : 10000];
            boolean eos = false;
            while (!this.isClosing() && !eos) {
                try {
                    Object object = this.dataAvailable;
                    synchronized (object) {
                        this.dataAvailable.wait();
                        int read = this.sourceStream.read(buffer, 0, buffer.length);
                        if (read == 0) {
                            break;
                        }
                        if (read < 0) {
                            eos = true;
                            this.raf.close();
                            logger.fine("EOS");
                            Handler.this.notifyDataSinkListeners(new EndOfStreamEvent(Handler.this, "EOS"));
                            break;
                        }
                        this.raf.write(buffer, 0, read);
                    }
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (InterruptedIOException e) {
                    break;
                }
                catch (IOException e) {
                }
            }
            this.setClosed();
            try {
                this.raf.close();
                logger.fine("EOS");
                Handler.this.notifyDataSinkListeners(new EndOfStreamEvent(Handler.this, "EOS"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

