/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.parser;

import java.awt.Component;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Owned;
import javax.media.Track;
import javax.media.control.FrameRateControl;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import net.sf.fmj.media.AbstractDemultiplexer;
import net.sf.fmj.media.AbstractTrack;
import net.sf.fmj.utility.LoggerSingleton;

public class RawPushBufferParser
extends AbstractDemultiplexer {
    private static final Logger logger = LoggerSingleton.logger;
    private ContentDescriptor[] supportedInputContentDescriptors = new ContentDescriptor[]{new ContentDescriptor("raw")};
    private PushBufferDataSource source;
    private PushBufferStreamTrack[] tracks;
    private float frameRate = -1.0f;
    private int sleepTime;
    private long lastSleepTime = -1L;

    public RawPushBufferParser() {
        this.addControl(new FRC());
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return this.supportedInputContentDescriptors;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        return this.tracks;
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        if (!(source instanceof PushBufferDataSource)) {
            throw new IncompatibleSourceException();
        }
        this.source = (PushBufferDataSource)source;
    }

    public void start() throws IOException {
        this.source.start();
        if (this.tracks == null) {
            PushBufferStream[] streams = this.source.getStreams();
            this.tracks = new PushBufferStreamTrack[streams.length];
            for (int i = 0; i < streams.length; ++i) {
                this.tracks[i] = new PushBufferStreamTrack(streams[i]);
            }
        }
    }

    public void stop() {
        try {
            this.source.stop();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
        }
    }

    private class PushBufferStreamTrack
    extends AbstractTrack
    implements BufferTransferHandler {
        private final PushBufferStream stream;
        private Object dataAvailable = new Object();
        private int framesAvailable = 0;

        public PushBufferStreamTrack(PushBufferStream stream) {
            this.stream = stream;
            stream.setTransferHandler(this);
        }

        public Format getFormat() {
            return this.stream.getFormat();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transferData(PushBufferStream stream) {
            Object object = this.dataAvailable;
            synchronized (object) {
                ++this.framesAvailable;
                this.dataAvailable.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFrame(Buffer buffer) {
            block7: {
                try {
                    Object object = this.dataAvailable;
                    synchronized (object) {
                        while (this.framesAvailable == 0) {
                            this.dataAvailable.wait();
                        }
                        this.stream.read(buffer);
                        --this.framesAvailable;
                    }
                    this.adaptiveSleep(RawPushBufferParser.this.sleepTime);
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    buffer.setEOM(true);
                    buffer.setDiscard(true);
                    buffer.setLength(0);
                    if (e instanceof InterruptedIOException) break block7;
                    logger.log(Level.FINE, "" + e, e);
                }
            }
        }

        private void adaptiveSleep(long sleepTime) {
            if (sleepTime > 0L) {
                long currentTime = System.nanoTime() / 1000000L;
                if (RawPushBufferParser.this.lastSleepTime == -1L) {
                    RawPushBufferParser.this.lastSleepTime = currentTime;
                } else {
                    RawPushBufferParser.this.lastSleepTime += sleepTime;
                }
                try {
                    long deltaSleep = RawPushBufferParser.this.lastSleepTime - currentTime;
                    if (deltaSleep >= 2L) {
                        Thread.sleep(deltaSleep);
                    } else {
                        RawPushBufferParser.this.lastSleepTime = currentTime;
                    }
                }
                catch (Exception dontcare) {
                    // empty catch block
                }
            }
        }
    }

    private class FRC
    implements FrameRateControl,
    Owned {
        private FRC() {
        }

        public Object getOwner() {
            return RawPushBufferParser.this;
        }

        public float getFrameRate() {
            return RawPushBufferParser.this.frameRate;
        }

        public float setFrameRate(float newFrameRate) {
            RawPushBufferParser.this.frameRate = newFrameRate;
            RawPushBufferParser.this.sleepTime = (int)(1000.0f / RawPushBufferParser.this.frameRate);
            return RawPushBufferParser.this.frameRate;
        }

        public float getMaxSupportedFrameRate() {
            return -1.0f;
        }

        public float getPreferredFrameRate() {
            return -1.0f;
        }

        public Component getControlComponent() {
            return null;
        }
    }
}

