/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.net.DatagramPacket;
import net.sf.fmj.media.rtp.RTPHeader;

public class RTPPacket {
    private RTPHeader header = null;
    private byte[] data = null;

    public RTPPacket(DatagramPacket packet) throws IOException {
        this(packet.getData(), packet.getOffset(), packet.getLength());
    }

    public RTPPacket(byte[] data, int offset, int length) throws IOException {
        this.header = new RTPHeader(data, offset, length);
        this.data = new byte[length - 12];
        System.arraycopy(data, offset + 12, this.data, 0, length - 12);
    }

    public RTPHeader getRtpHeader() {
        return this.header;
    }

    public byte[] getRtpData() {
        return this.data;
    }

    public int getRtpLength() {
        return this.data.length;
    }
}

