/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Vector;
import javax.media.rtp.OutputDataStream;

public class SocketOutputStream
implements OutputDataStream {
    private DatagramSocket socket = null;
    private Vector<InetAddress> remoteAddrs;
    private Vector<Integer> remotePorts;

    public SocketOutputStream(DatagramSocket sckt) {
        this.socket = sckt;
        this.remoteAddrs = new Vector();
        this.remotePorts = new Vector();
    }

    public void addTarget(InetAddress remoteAddr, int remotePort) {
        this.remoteAddrs.add(remoteAddr);
        this.remotePorts.add(new Integer(remotePort));
    }

    public boolean removeTarget(InetAddress remoteAddr, int remotePort) {
        boolean ok = true;
        ok = ok && this.remoteAddrs.remove(remoteAddr);
        ok = ok && this.remoteAddrs.remove(new Integer(remotePort));
        return ok;
    }

    public void removeTargets() {
        this.remoteAddrs.removeAllElements();
        this.remotePorts.removeAllElements();
    }

    public int write(byte[] buffer, int offset, int length) {
        for (int i = 0; i < this.remoteAddrs.size(); ++i) {
            InetAddress remoteAddr = this.remoteAddrs.elementAt(i);
            int remotePort = this.remotePorts.elementAt(i);
            try {
                this.socket.send(new DatagramPacket(buffer, offset, length, remoteAddr, remotePort));
                continue;
            }
            catch (Exception e) {
                return -1;
            }
        }
        return length;
    }

    public int writeToRemote(byte[] buffer, int offset, int length, InetAddress remoteAddr, int remotePort) {
        try {
            this.socket.send(new DatagramPacket(buffer, offset, length, remoteAddr, remotePort));
        }
        catch (Exception e) {
            return -1;
        }
        return length;
    }
}

