/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.AsfExtHeaderReader;
import org.jaudiotagger.audio.asf.io.ChunkContainerReader;
import org.jaudiotagger.audio.asf.io.ChunkReader;
import org.jaudiotagger.audio.asf.io.ContentDescriptionReader;
import org.jaudiotagger.audio.asf.io.EncodingChunkReader;
import org.jaudiotagger.audio.asf.io.EncryptionChunkReader;
import org.jaudiotagger.audio.asf.io.ExtContentDescReader;
import org.jaudiotagger.audio.asf.io.FileHeaderReader;
import org.jaudiotagger.audio.asf.io.FullRequestInputStream;
import org.jaudiotagger.audio.asf.io.RandomAccessFileInputstream;
import org.jaudiotagger.audio.asf.io.StreamBitratePropertiesReader;
import org.jaudiotagger.audio.asf.io.StreamChunkReader;
import org.jaudiotagger.audio.asf.util.Utils;

public class AsfHeaderReader
extends ChunkContainerReader<AsfHeader> {
    private static final AsfHeaderReader FULL_READER;
    private static final AsfHeaderReader INFO_READER;
    private static final AsfHeaderReader TAG_READER;

    private static InputStream createStream(RandomAccessFile raf) {
        return new FullRequestInputStream(new BufferedInputStream(new RandomAccessFileInputstream(raf)));
    }

    public static AsfHeader readHeader(File file) throws IOException {
        AsfHeader result = null;
        FileInputStream stream = new FileInputStream(file);
        result = (AsfHeader)FULL_READER.read(Utils.readGUID(stream), stream, 0L);
        ((InputStream)stream).close();
        return result;
    }

    public static AsfHeader readHeader(RandomAccessFile in) throws IOException {
        InputStream stream = AsfHeaderReader.createStream(in);
        return (AsfHeader)FULL_READER.read(Utils.readGUID(stream), stream, 0L);
    }

    public static AsfHeader readInfoHeader(RandomAccessFile in) throws IOException {
        InputStream stream = AsfHeaderReader.createStream(in);
        return (AsfHeader)INFO_READER.read(Utils.readGUID(stream), stream, 0L);
    }

    public static AsfHeader readTagHeader(RandomAccessFile in) throws IOException {
        InputStream stream = AsfHeaderReader.createStream(in);
        return (AsfHeader)TAG_READER.read(Utils.readGUID(stream), stream, 0L);
    }

    public AsfHeaderReader(List<Class<? extends ChunkReader>> toRegister, boolean readChunkOnce) {
        super(toRegister, readChunkOnce);
    }

    @Override
    protected AsfHeader createContainer(long streamPosition, BigInteger chunkLength, InputStream stream) throws IOException {
        long chunkCount = Utils.readUINT32(stream);
        if (stream.read() != 1) {
            throw new IOException("No ASF");
        }
        if (stream.read() != 2) {
            throw new IOException("No ASF");
        }
        return new AsfHeader(streamPosition, chunkLength, chunkCount);
    }

    @Override
    public GUID getApplyingId() {
        return GUID.GUID_HEADER;
    }

    public void setExtendedHeaderReader(AsfExtHeaderReader extReader) {
        if (extReader == null) {
            throw new NullPointerException("Argument must not be null.");
        }
        this.readerMap.put(extReader.getApplyingId(), extReader);
    }

    static {
        ArrayList<Class<? extends ChunkReader>> readers = new ArrayList<Class<? extends ChunkReader>>();
        readers.add(FileHeaderReader.class);
        readers.add(StreamChunkReader.class);
        INFO_READER = new AsfHeaderReader(readers, true);
        readers.clear();
        readers.add(ContentDescriptionReader.class);
        readers.add(ExtContentDescReader.class);
        AsfExtHeaderReader extReader = new AsfExtHeaderReader(readers, true);
        AsfExtHeaderReader extReader2 = new AsfExtHeaderReader(readers, true);
        TAG_READER = new AsfHeaderReader(readers, true);
        TAG_READER.setExtendedHeaderReader(extReader);
        readers.add(FileHeaderReader.class);
        readers.add(StreamChunkReader.class);
        readers.add(EncodingChunkReader.class);
        readers.add(EncryptionChunkReader.class);
        readers.add(StreamBitratePropertiesReader.class);
        FULL_READER = new AsfHeaderReader(readers, false);
        FULL_READER.setExtendedHeaderReader(extReader2);
    }
}

