/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.test;

import java.io.File;
import java.io.FileFilter;
import org.jaudiotagger.audio.mp3.MP3File;

public class ExtractID3TagFromFile {
    public static final String IDENT = "$Id: ExtractID3TagFromFile.java,v 1.5 2008/07/21 10:46:30 paultaylor Exp $";

    public static void main(String[] args) {
        ExtractID3TagFromFile test = new ExtractID3TagFromFile();
        if (args.length != 2) {
            System.err.println("usage ExtractID3TagFromFile Filename FilenameOut");
            System.err.println("      You must enter the file to extract the tag from and where to extract to");
            System.exit(1);
        }
        File file = new File(args[0]);
        File outFile = new File(args[1]);
        if (!file.isFile()) {
            System.err.println("usage ExtractID3TagFromFile Filename FilenameOut");
            System.err.println("      File " + args[0] + " could not be found");
            System.exit(1);
        }
        try {
            MP3File tmpMP3 = new MP3File(file);
            tmpMP3.extractID3v2TagDataIntoFile(outFile);
        }
        catch (Exception e) {
            System.err.println("Unable to extract tag");
            System.exit(1);
        }
    }

    final class MP3FileFilter
    extends javax.swing.filechooser.FileFilter
    implements FileFilter {
        private final boolean allowDirectories;

        public MP3FileFilter() {
            this(false);
        }

        private MP3FileFilter(boolean allowDirectories) {
            this.allowDirectories = allowDirectories;
        }

        @Override
        public final boolean accept(File file) {
            return file.getName().toLowerCase().endsWith(".mp3") || file.isDirectory() && this.allowDirectories;
        }

        @Override
        public final String getDescription() {
            return new String(".mp3 Files");
        }
    }
}

