/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.activation.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.limewire.activation.api.ActivationID;
import org.limewire.activation.api.ActivationItem;
import org.limewire.activation.api.ActivationModuleEvent;
import org.limewire.activation.impl.ActivationModel;
import org.limewire.listener.AsynchronousEventMulticaster;
import org.limewire.listener.AsynchronousMulticasterImpl;
import org.limewire.listener.EventListener;

@Singleton
class ActivationModelImpl
implements ActivationModel {
    private final Map<ActivationID, ActivationItem> itemMap = new HashMap<ActivationID, ActivationItem>(4);
    private final AsynchronousEventMulticaster<ActivationModuleEvent> listeners;

    @Inject
    public ActivationModelImpl(@Named(value="fastExecutor") Executor executor) {
        this.listeners = new AsynchronousMulticasterImpl<ActivationModuleEvent>(executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActivationItem> getActivationItems() {
        ActivationModelImpl activationModelImpl = this;
        synchronized (activationModelImpl) {
            return new ArrayList<ActivationItem>(this.itemMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        ActivationModelImpl activationModelImpl = this;
        synchronized (activationModelImpl) {
            return this.itemMap.size();
        }
    }

    @Override
    public void setActivationItems(List<ActivationItem> items) {
        this.setActivationItems(items, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setActivationItems(List<ActivationItem> items, boolean loadedFromDisk) {
        ArrayList<ActivationItem> oldItems;
        ActivationModelImpl activationModelImpl = this;
        synchronized (activationModelImpl) {
            oldItems = new ArrayList<ActivationItem>(this.itemMap.values());
            this.itemMap.clear();
            for (ActivationItem item : items) {
                this.itemMap.put(item.getModuleID(), item);
            }
        }
        ArrayList<ActivationItem> eventItems = new ArrayList<ActivationItem>(items);
        for (ActivationItem item : oldItems) {
            if (this.itemMap.containsKey((Object)item.getModuleID())) {
                ActivationItem currentItem = this.itemMap.get((Object)item.getModuleID());
                if (currentItem.getStatus() != item.getStatus()) continue;
                eventItems.remove(currentItem);
                continue;
            }
            this.listeners.broadcast(new ActivationModuleEvent(item.getModuleID(), ActivationItem.Status.EXPIRED));
        }
        for (ActivationItem item : eventItems) {
            if (item.getModuleID() == ActivationID.UNKNOWN_MODULE) continue;
            this.listeners.broadcast(new ActivationModuleEvent(item.getModuleID(), item.getStatus()));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive(ActivationID id) {
        ActivationItem item;
        ActivationModelImpl activationModelImpl = this;
        synchronized (activationModelImpl) {
            item = this.itemMap.get((Object)id);
        }
        if (item == null) {
            return false;
        }
        return item.getStatus() == ActivationItem.Status.ACTIVE;
    }

    @Override
    public void addListener(EventListener<ActivationModuleEvent> listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public boolean removeListener(EventListener<ActivationModuleEvent> listener) {
        return this.listeners.removeListener(listener);
    }
}

