/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public class LimeScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    public LimeScheduledThreadPoolExecutor(int corePoolSize) {
        super(corePoolSize);
    }

    public LimeScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    public LimeScheduledThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, handler);
    }

    public LimeScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory, handler);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        block6: {
            super.afterExecute(r, t);
            if (r instanceof FutureTask) {
                FutureTask task = (FutureTask)r;
                try {
                    if (task.isDone() && !task.isCancelled()) {
                        task.get();
                    }
                }
                catch (InterruptedException e) {
                }
                catch (ExecutionException e) {
                    Throwable badStuff = e.getCause();
                    if (!(badStuff instanceof RuntimeException) && !(badStuff instanceof Error)) break block6;
                    Thread currThread = Thread.currentThread();
                    Thread.UncaughtExceptionHandler handler = currThread.getUncaughtExceptionHandler();
                    if (handler != null) {
                        handler.uncaughtException(currThread, badStuff);
                    }
                    Thread.getDefaultUncaughtExceptionHandler().uncaughtException(currThread, badStuff);
                }
            }
        }
    }
}

