/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.api.library;

import java.util.Collection;
import java.util.Collections;
import org.limewire.core.api.library.RemoteLibrary;
import org.limewire.core.api.library.RemoteLibraryState;
import org.limewire.core.api.search.SearchResult;
import org.limewire.listener.DefaultSourceTypeEvent;

public class RemoteLibraryEvent
extends DefaultSourceTypeEvent<RemoteLibrary, Type> {
    private final RemoteLibraryState state;
    private final Collection<SearchResult> addedResults;
    private final int startIndex;

    private RemoteLibraryEvent(RemoteLibrary source, Type type, Collection<SearchResult> addedResults, int startIndex) {
        super(source, type);
        this.startIndex = startIndex;
        this.state = source.getState();
        this.addedResults = addedResults;
    }

    public static RemoteLibraryEvent createStateChangedEvent(RemoteLibrary remoteLibrary) {
        return new RemoteLibraryEvent(remoteLibrary, Type.STATE_CHANGED, Collections.<SearchResult>emptyList(), -1);
    }

    public static RemoteLibraryEvent createResultsClearedEvent(RemoteLibrary remoteLibrary) {
        return new RemoteLibraryEvent(remoteLibrary, Type.RESULTS_CLEARED, Collections.<SearchResult>emptyList(), -1);
    }

    public static RemoteLibraryEvent createResultsRemovedEvent(RemoteLibrary remoteLibrary) {
        return new RemoteLibraryEvent(remoteLibrary, Type.RESULTS_REMOVED, Collections.<SearchResult>emptyList(), -1);
    }

    public static RemoteLibraryEvent createResultsAddedEvent(RemoteLibrary remoteLibrary, Collection<SearchResult> addedResults, int startIndex) {
        return new RemoteLibraryEvent(remoteLibrary, Type.RESULTS_ADDED, addedResults, startIndex);
    }

    public RemoteLibraryState getState() {
        return this.state;
    }

    public Collection<SearchResult> getAddedResults() {
        return this.addedResults;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public static enum Type {
        RESULTS_CLEARED,
        RESULTS_ADDED,
        RESULTS_REMOVED,
        STATE_CHANGED;

    }
}

