/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.download.listener;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.downloader.CoreDownloader;
import com.limegroup.gnutella.downloader.DownloadStateEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.limewire.core.settings.DownloadSettings;
import org.limewire.listener.EventListener;
import org.limewire.setting.FileSetSetting;
import org.limewire.util.Objects;

public class RecentDownloadListener
implements EventListener<DownloadStateEvent> {
    private static final int DEFAULT_MAX_TRACKED_DOWNLOADS = 10;
    private final Downloader downloader;
    private final int maxTrackedDownloads;

    public RecentDownloadListener(Downloader downloader, int maxTrackedDownloads) {
        assert (maxTrackedDownloads > 0);
        this.downloader = Objects.nonNull(downloader, "downloader");
        this.maxTrackedDownloads = maxTrackedDownloads;
        if (downloader.getState() == Downloader.DownloadState.COMPLETE && downloader instanceof CoreDownloader) {
            this.handleEvent(new DownloadStateEvent((CoreDownloader)downloader, Downloader.DownloadState.COMPLETE));
        }
    }

    public RecentDownloadListener(Downloader downloader) {
        this(downloader, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleEvent(DownloadStateEvent event) {
        File saveFile;
        Downloader.DownloadState downloadStatus = (Downloader.DownloadState)((Object)event.getType());
        if (Downloader.DownloadState.COMPLETE != downloadStatus || (saveFile = this.downloader.getSaveFile()) == null || !DownloadSettings.REMEMBER_RECENT_DOWNLOADS.getValue()) return;
        Class<RecentDownloadListener> clazz = RecentDownloadListener.class;
        synchronized (RecentDownloadListener.class) {
            ArrayList<File> files;
            FileSetSetting fileSetSetting = DownloadSettings.RECENT_DOWNLOADS;
            synchronized (fileSetSetting) {
                files = new ArrayList<File>((Collection<File>)DownloadSettings.RECENT_DOWNLOADS.get());
            }
            files.add(saveFile);
            Collections.sort(files, new FileDateLeastToMostRecentComparator());
            while (files.size() > this.maxTrackedDownloads) {
                files.remove(0);
            }
            DownloadSettings.RECENT_DOWNLOADS.set(new HashSet(files));
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private static class FileDateLeastToMostRecentComparator
    implements Comparator<File> {
        private FileDateLeastToMostRecentComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            return Long.valueOf(o1.lastModified()).compareTo(o2.lastModified());
        }
    }
}

