/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.inspections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.limewire.core.impl.inspections.InspectionDataContainer;
import org.limewire.core.impl.inspections.InspectionsResultProcessor;
import org.limewire.core.settings.ApplicationSettings;
import org.limewire.core.settings.InspectionsSettings;
import org.limewire.inspection.InspectionException;
import org.limewire.inspection.Inspector;
import org.limewire.io.InvalidDataException;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.StringUtils;

public class InspectionsSpec {
    private static final Log LOG = LogFactory.getLog(InspectionsSpec.class);
    private final List<String> inspectionPoints;
    private final long startDelay;
    private final long interval;
    private ScheduledFuture scheduledInspections;

    InspectionsSpec(List<String> inspectionPoints, long startDelay, long interval) {
        this.inspectionPoints = new ArrayList<String>(new LinkedHashSet<String>(inspectionPoints));
        this.startDelay = startDelay;
        this.interval = interval;
    }

    InspectionsSpec(Object bdecoded) throws InvalidDataException {
        try {
            Map specMap = (Map)bdecoded;
            long startDelay = (Long)specMap.get("startdelay");
            long interval = (Long)specMap.get("interval");
            List inspPointsEncoded = (List)specMap.get("insp");
            LinkedHashSet<String> inspectionPoints = new LinkedHashSet<String>();
            for (Object inspPt : inspPointsEncoded) {
                inspectionPoints.add(StringUtils.getUTF8String((byte[])inspPt));
            }
            this.inspectionPoints = new ArrayList<String>(inspectionPoints);
            this.startDelay = startDelay;
            this.interval = interval;
            this.validate();
        }
        catch (ClassCastException e) {
            throw new InvalidDataException("invalid inspections specification data", e);
        }
    }

    private void validate() throws InvalidDataException {
        if (this.interval < (long)InspectionsSettings.INSPECTION_SPEC_MINIMUM_INTERVAL.get().intValue() && this.interval != 0L) {
            throw new InvalidDataException("invalid inspection spec interval: " + this.interval);
        }
    }

    Map<String, Object> asBencodedMap() {
        HashMap<String, Object> inspectionSpecEncoded = new HashMap<String, Object>(3);
        inspectionSpecEncoded.put("startdelay", this.startDelay);
        inspectionSpecEncoded.put("interval", this.interval);
        inspectionSpecEncoded.put("insp", this.inspectionPoints);
        return inspectionSpecEncoded;
    }

    long getInitialDelay() {
        return this.startDelay;
    }

    long getInterval() {
        return this.interval;
    }

    List<String> getInspectionPoints() {
        return Collections.unmodifiableList(this.inspectionPoints);
    }

    private InspectionDataContainer inspect(Inspector inspector, boolean collectUsageData) {
        InspectionDataContainer inspectionResults = new InspectionDataContainer();
        ArrayList<String> failedInspections = new ArrayList<String>();
        for (String inspectionKey : this.inspectionPoints) {
            try {
                inspectionResults.addInspectionResult(inspectionKey, inspector.inspect(inspectionKey, collectUsageData));
            }
            catch (InspectionException e) {
                LOG.error("Error performing inspection", e);
                HashMap<String, String> errorMap = new HashMap<String, String>();
                errorMap.put("error", e.getMessage());
                inspectionResults.addInspectionResult(inspectionKey, errorMap);
                failedInspections.add(inspectionKey);
            }
        }
        if (!failedInspections.isEmpty()) {
            this.inspectionPoints.removeAll(failedInspections);
            if (this.inspectionPoints.isEmpty()) {
                this.ensureCancelled();
            }
        }
        return inspectionResults;
    }

    synchronized void schedule(InspectionsResultProcessor processor, Inspector inspector, ScheduledExecutorService scheduler) {
        this.ensureCancelled();
        InspectionsSpecProcessing doInspection = new InspectionsSpecProcessing(processor, inspector);
        this.scheduledInspections = this.interval == 0L ? scheduler.schedule(doInspection, this.startDelay, TimeUnit.SECONDS) : scheduler.scheduleWithFixedDelay(doInspection, this.startDelay, this.interval, TimeUnit.SECONDS);
    }

    synchronized void ensureCancelled() {
        if (this.scheduledInspections != null) {
            this.scheduledInspections.cancel(false);
            this.scheduledInspections = null;
        }
    }

    private class InspectionsSpecProcessing
    implements Runnable {
        private final Inspector inspector;
        private final InspectionsResultProcessor processor;

        InspectionsSpecProcessing(InspectionsResultProcessor processor, Inspector inspector) {
            this.processor = processor;
            this.inspector = inspector;
        }

        @Override
        public void run() {
            InspectionDataContainer inspResults = InspectionsSpec.this.inspect(this.inspector, (Boolean)ApplicationSettings.ALLOW_ANONYMOUS_STATISTICS_GATHERING.get());
            this.processor.inspectionsPerformed(InspectionsSpec.this, inspResults);
        }
    }
}

