/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.monitor;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import com.google.inject.Inject;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.monitor.IncomingSearchManager;
import org.limewire.core.impl.monitor.IncomingSearchListener;
import org.limewire.core.impl.monitor.IncomingSearchListenerList;
import org.limewire.inject.EagerSingleton;

@EagerSingleton
public class CoreIncomingSearchManager
implements IncomingSearchManager,
IncomingSearchListener {
    private final EventList<String> incomingSearchList = GlazedListsFactory.threadSafeList(new BasicEventList());
    private boolean listEnabled = true;
    private int listSize = 32;

    @Inject
    public CoreIncomingSearchManager(IncomingSearchListenerList incomingListenerList) {
        incomingListenerList.addIncomingSearchListener(this);
    }

    @Override
    public EventList<String> getIncomingSearchList() {
        return GlazedListsFactory.readOnlyList(this.incomingSearchList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setListEnabled(boolean enabled) {
        this.incomingSearchList.getReadWriteLock().writeLock().lock();
        try {
            this.listEnabled = enabled;
        }
        finally {
            this.incomingSearchList.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setListSize(int size) {
        this.incomingSearchList.getReadWriteLock().writeLock().lock();
        try {
            this.listSize = size;
            this.reduceList(size);
        }
        finally {
            this.incomingSearchList.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleQueryString(String query) {
        this.incomingSearchList.getReadWriteLock().writeLock().lock();
        try {
            if (this.listEnabled) {
                this.incomingSearchList.add(0, query);
                this.reduceList(this.listSize);
            }
        }
        finally {
            this.incomingSearchList.getReadWriteLock().writeLock().unlock();
        }
    }

    private void reduceList(int size) {
        while (size >= 0 && this.incomingSearchList.size() > size) {
            this.incomingSearchList.remove(this.incomingSearchList.size() - 1);
        }
    }
}

