/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import java.io.InputStream;
import java.nio.ByteBuffer;
import org.limewire.util.BufferUtils;

public class ByteBufferInputStream
extends InputStream {
    private static final ByteBuffer[] EMPTY = new ByteBuffer[0];
    protected int index = 0;
    protected int mark = -1;
    protected ByteBuffer[] buffers;

    public ByteBufferInputStream(ByteBuffer ... buffers) {
        this.buffers = buffers;
    }

    public ByteBuffer[] getBuffers() {
        if (this.buffers == EMPTY) {
            throw new IllegalStateException("InputStream is closed");
        }
        return this.buffers;
    }

    @Override
    public int available() {
        int available = 0;
        for (int i = this.buffers.length - 1; i >= this.index; --i) {
            available += this.buffers[i].remaining();
        }
        return available;
    }

    @Override
    public void close() {
        this.index = 0;
        this.mark = -1;
        this.buffers = EMPTY;
    }

    @Override
    public void mark(int readlimit) {
        if (this.index < this.buffers.length) {
            this.mark = this.index;
            for (int i = this.buffers.length - 1; i >= this.mark; --i) {
                this.buffers[i].mark();
            }
        }
    }

    @Override
    public void reset() {
        if (this.mark != -1) {
            this.index = this.mark;
            for (int i = this.buffers.length - 1; i >= this.index; --i) {
                this.buffers[i].reset();
            }
            this.mark = -1;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() {
        while (this.index < this.buffers.length) {
            ByteBuffer b = this.buffers[this.index];
            if (b.hasRemaining()) {
                return b.get() & 0xFF;
            }
            ++this.index;
        }
        return -1;
    }

    @Override
    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.index >= this.buffers.length) {
            return -1;
        }
        if (this.index == this.buffers.length - 1 && !this.buffers[this.index].hasRemaining()) {
            return -1;
        }
        if (len == 0 || b.length == 0) {
            return this.available() > 0 ? 0 : -1;
        }
        int r = 0;
        while (this.index < this.buffers.length) {
            ByteBuffer buf = this.buffers[this.index];
            int l = Math.min(buf.remaining(), len - r);
            buf.get(b, off + r, l);
            if ((r += l) == len) break;
            ++this.index;
        }
        return r > 0 ? r : -1;
    }

    @Override
    public long skip(long n) {
        long s = 0L;
        while (this.index < this.buffers.length) {
            ByteBuffer b = this.buffers[this.index];
            long l = Math.min((long)b.remaining(), n - s);
            b.position(b.position() + (int)l);
            if ((s += l) == n) break;
            ++this.index;
        }
        return s;
    }

    public long read(ByteBuffer dst) {
        long read = 0L;
        while (this.index < this.buffers.length) {
            ByteBuffer b = this.buffers[this.index];
            if (b.hasRemaining()) {
                read += (long)BufferUtils.transfer(b, dst, false);
            }
            if (!dst.hasRemaining()) break;
            ++this.index;
        }
        return read;
    }

    public ByteBuffer bufferFor(int length) {
        ByteBuffer ret = null;
        while (this.index < this.buffers.length && !this.buffers[this.index].hasRemaining()) {
            ++this.index;
        }
        if (this.index < this.buffers.length) {
            length = Math.min(length, this.available());
            ByteBuffer b = this.buffers[this.index];
            if (b.remaining() >= length) {
                int oldLimit = b.limit();
                b.limit(b.position() + length);
                ret = b.slice();
                b.limit(oldLimit);
                b.position(b.position() + length);
            } else {
                ret = ByteBuffer.allocate(length);
                this.read(ret);
                ret.flip();
            }
        } else {
            ret = BufferUtils.getEmptyBuffer();
        }
        return ret;
    }
}

