/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.limewire.io.Connectable;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;
import org.limewire.util.StringUtils;

public class ConnectableImpl
implements Connectable {
    public static final Connectable INVALID_CONNECTABLE;
    private final IpPort ipPort;
    private final boolean tlsCapable;
    private int hashCode = -1;

    public ConnectableImpl(IpPort ipPort, boolean tlsCapable) {
        this.ipPort = ipPort;
        this.tlsCapable = tlsCapable;
    }

    public ConnectableImpl(InetSocketAddress addr, boolean tlsCapable) {
        this(new IpPortImpl(addr), tlsCapable);
    }

    public ConnectableImpl(InetAddress host, int port, boolean tlsCapable) {
        this(new IpPortImpl(host, port), tlsCapable);
    }

    public ConnectableImpl(String host, int port, boolean tlsCapable) throws UnknownHostException {
        this(new IpPortImpl(host, port), tlsCapable);
    }

    public ConnectableImpl(String hostPort, boolean tlsCapable) throws UnknownHostException {
        this(new IpPortImpl(hostPort), tlsCapable);
    }

    public ConnectableImpl(Connectable connectable) {
        this(new IpPortImpl(connectable.getInetSocketAddress(), connectable.getAddress()), connectable.isTLSCapable());
    }

    @Override
    public boolean isTLSCapable() {
        return this.tlsCapable;
    }

    @Override
    public String getAddress() {
        return this.ipPort.getAddress();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.ipPort.getInetAddress();
    }

    @Override
    public int getPort() {
        return this.ipPort.getPort();
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        return this.ipPort.getInetSocketAddress();
    }

    @Override
    public String getAddressDescription() {
        return this.getAddress();
    }

    public String toString() {
        return StringUtils.toStringBlacklist(this, this.hashCode, INVALID_CONNECTABLE);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Connectable) {
            Connectable connectable = (Connectable)obj;
            return this.getInetAddress().equals(connectable.getInetAddress()) && this.getPort() == connectable.getPort() && this.isTLSCapable() == connectable.isTLSCapable();
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = this.hashCode;
        if (hash == -1) {
            hash = this.getInetAddress().hashCode();
            hash = hash * 31 + this.getPort();
            this.hashCode = hash = hash * 31 + (this.tlsCapable ? 1 : 0);
        }
        return this.hashCode;
    }

    static {
        try {
            INVALID_CONNECTABLE = new ConnectableImpl("0.0.0.0", 1, false);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

