/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.lifecycle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.inject.EagerSingleton;
import org.limewire.lifecycle.Asynchronous;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.lifecycle.ServiceRegistryListener;
import org.limewire.lifecycle.ServiceStage;
import org.limewire.lifecycle.StagedRegisterBuilder;
import org.limewire.lifecycle.StagedRegisterBuilderImpl;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.ExceptionUtils;
import org.limewire.util.Stopwatch;

@EagerSingleton
class ServiceRegistryImpl
implements ServiceRegistry {
    private static final Log LOG = LogFactory.getLog(ServiceRegistryImpl.class);
    private final List<StagedRegisterBuilderImpl> builders = new ArrayList<StagedRegisterBuilderImpl>();
    private final Map<Object, List<ServiceHolder>> services = new HashMap<Object, List<ServiceHolder>>();
    private final List<ServiceHolder> startedServices = new ArrayList<ServiceHolder>();
    private final List<ServiceRegistryListener> registryListeners = new ArrayList<ServiceRegistryListener>();

    ServiceRegistryImpl() {
    }

    @Override
    public void initialize() {
        Iterator<StagedRegisterBuilderImpl> iter = this.builders.iterator();
        while (iter.hasNext()) {
            List<ServiceHolder> servicesInStage;
            StagedRegisterBuilderImpl builder = iter.next();
            Object stage = builder.getCustomStage();
            if (stage == null) {
                stage = builder.getStage();
            }
            if ((servicesInStage = this.services.get(stage)) == null) {
                servicesInStage = new ArrayList<ServiceHolder>();
                this.services.put(stage, servicesInStage);
            }
            servicesInStage.add(new ServiceHolder(builder.getService()));
            iter.remove();
        }
        for (ServiceStage stage : this.getStagesInOrder()) {
            if (this.services.get((Object)stage) == null) continue;
            for (ServiceHolder service : this.services.get((Object)stage)) {
                service.init();
            }
        }
        for (Map.Entry<Object, List<ServiceHolder>> entry : this.services.entrySet()) {
            if (entry.getKey().getClass() == ServiceStage.class || entry.getValue() == null) continue;
            for (ServiceHolder service : entry.getValue()) {
                service.init();
            }
        }
    }

    @Override
    public void start(Object stage) {
        this.initialize();
        this.startStage(stage);
    }

    @Override
    public void start() {
        this.initialize();
        Stopwatch stopwatch = new Stopwatch(LOG);
        for (ServiceStage stage : this.getStagesInOrder()) {
            this.startStage((Object)stage);
        }
        stopwatch.resetAndLog("started ServiceRegistry");
    }

    private void startStage(Object stage) {
        Stopwatch stopwatch = new Stopwatch(LOG);
        List<ServiceHolder> servicedStages = this.services.get(stage);
        if (servicedStages != null) {
            Iterator<ServiceHolder> iter = servicedStages.iterator();
            while (iter.hasNext()) {
                ServiceHolder service = iter.next();
                try {
                    service.start();
                    this.startedServices.add(service);
                }
                catch (Throwable e) {
                    ExceptionUtils.reportOrReturn(e);
                }
                iter.remove();
            }
            for (ServiceHolder startedService : this.startedServices) {
                try {
                    startedService.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        if (LOG.isTraceEnabled()) {
            stopwatch.resetAndLog("started stage " + stage.toString());
        }
    }

    @Override
    public void stop() {
        int i;
        Stopwatch stopwatch = new Stopwatch(LOG);
        for (i = this.startedServices.size() - 1; i >= 0; --i) {
            this.startedServices.get(i).stop();
        }
        for (i = this.startedServices.size() - 1; i >= 0; --i) {
            try {
                this.startedServices.get(i).join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.startedServices.remove(i);
        }
        if (LOG.isTraceEnabled()) {
            stopwatch.resetAndLog("stopped ServiceRegistry");
        }
    }

    @Override
    public StagedRegisterBuilder register(Service service) {
        StagedRegisterBuilderImpl builder = new StagedRegisterBuilderImpl(service);
        this.builders.add(builder);
        return builder;
    }

    @Override
    public void addListener(ServiceRegistryListener serviceRegistryListener) {
        this.registryListeners.add(serviceRegistryListener);
    }

    ServiceStage[] getStagesInOrder() {
        return new ServiceStage[]{ServiceStage.EARLY, ServiceStage.NORMAL, ServiceStage.LATE, ServiceStage.VERY_LATE};
    }

    private class ServiceHolder {
        private final AnnotatedService service;
        private boolean initted;
        private boolean started;
        private boolean stopped;

        public ServiceHolder(Service service) {
            this.service = new AnnotatedService(service);
        }

        void init() {
            if (!this.initted) {
                this.initted = true;
                for (ServiceRegistryListener listener : ServiceRegistryImpl.this.registryListeners) {
                    listener.initializing(this.service);
                }
                this.service.initialize();
            }
        }

        void start() {
            if (!this.started) {
                this.started = true;
                for (ServiceRegistryListener listener : ServiceRegistryImpl.this.registryListeners) {
                    listener.starting(this.service);
                }
                this.service.start();
            }
        }

        void stop() {
            if (!this.stopped) {
                this.stopped = true;
                for (ServiceRegistryListener listener : ServiceRegistryImpl.this.registryListeners) {
                    listener.stopping(this.service);
                }
                this.service.stop();
            }
        }

        void join() throws InterruptedException {
            this.service.join();
        }

        private class AnnotatedService
        implements Service {
            private final Service service;
            private volatile Thread serviceExecutor;
            private volatile Asynchronous asynchronous;

            AnnotatedService(Service service) {
                this.service = service;
            }

            void join() throws InterruptedException {
                if (this.asynchronous != null) {
                    this.asynchronous.join().join(this.serviceExecutor, this.asynchronous.timeout());
                }
            }

            @Override
            public void initialize() {
                this.service.initialize();
            }

            @Override
            public String getServiceName() {
                return this.service.getServiceName();
            }

            @Override
            public void start() {
                this.asynchronous = this.getAsynchronousAnnotation("start");
                if (this.asynchronous != null) {
                    this.serviceExecutor = this.asyncStart();
                } else {
                    Stopwatch stopwatch = new Stopwatch(LOG);
                    this.service.start();
                    if (LOG.isTraceEnabled()) {
                        stopwatch.resetAndLog("started " + this.service.getClass());
                    }
                }
            }

            private Thread asyncStart() {
                Thread startThread = ThreadExecutor.newManagedThread(new Runnable(){

                    @Override
                    public void run() {
                        Stopwatch stopwatch = new Stopwatch(LOG);
                        AnnotatedService.this.service.start();
                        if (LOG.isTraceEnabled()) {
                            stopwatch.resetAndLog("started " + AnnotatedService.this.service.getClass());
                        }
                    }
                }, "ServiceRegistry-start-" + this.service.getServiceName());
                startThread.setDaemon(this.asynchronous.daemon());
                startThread.start();
                return startThread;
            }

            @Override
            public void stop() {
                this.joinOnStart();
                this.asynchronous = this.getAsynchronousAnnotation("stop");
                if (this.asynchronous != null) {
                    this.serviceExecutor = this.asyncStop();
                } else {
                    Stopwatch stopwatch = new Stopwatch(LOG);
                    this.service.stop();
                    if (LOG.isTraceEnabled()) {
                        stopwatch.resetAndLog("stopped " + this.service.getClass());
                    }
                }
            }

            private void joinOnStart() {
                if (this.asynchronous != null) {
                    try {
                        this.serviceExecutor.join();
                    }
                    catch (InterruptedException e) {
                        LOG.debug("interrupted while join()'ing on start: ", e);
                    }
                }
            }

            private Thread asyncStop() {
                Thread stopThread = ThreadExecutor.newManagedThread(new Runnable(){

                    @Override
                    public void run() {
                        Stopwatch stopwatch = new Stopwatch(LOG);
                        AnnotatedService.this.service.stop();
                        if (LOG.isTraceEnabled()) {
                            stopwatch.resetAndLog("stopped " + AnnotatedService.this.service.getClass());
                        }
                    }
                }, "ServiceRegistry-stop-" + this.service.getServiceName());
                stopThread.setDaemon(this.asynchronous.daemon());
                stopThread.start();
                return stopThread;
            }

            private Asynchronous getAsynchronousAnnotation(String methodName) {
                try {
                    return this.service.getClass().getMethod(methodName, new Class[0]).getAnnotation(Asynchronous.class);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }
}

