/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.listener;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;
import org.limewire.listener.EventMulticaster;
import org.limewire.listener.EventMulticasterImpl;
import org.limewire.listener.PendingEventBroadcaster;
import org.limewire.util.ExceptionUtils;

public class PendingEventMulticasterImpl<E>
implements EventMulticaster<E>,
PendingEventBroadcaster<E> {
    private final EventMulticaster<E> multicaster;
    private final ConcurrentLinkedQueue<E> queuedEvents = new ConcurrentLinkedQueue();
    private final AtomicBoolean firing = new AtomicBoolean();

    public PendingEventMulticasterImpl() {
        this(new EventMulticasterImpl());
    }

    public PendingEventMulticasterImpl(EventMulticaster<E> multicaster) {
        this.multicaster = multicaster;
    }

    @Override
    public void addListener(EventListener<E> eventListener) {
        this.multicaster.addListener(eventListener);
    }

    @Override
    public boolean removeListener(EventListener<E> eventListener) {
        return this.multicaster.removeListener(eventListener);
    }

    @Override
    public void handleEvent(E event) {
        this.broadcast(event);
    }

    @Override
    public void broadcast(E event) {
        this.addPendingEvent(event);
        this.firePendingEvents();
    }

    @Override
    public void addPendingEvent(E event) {
        this.queuedEvents.add(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void firePendingEvents() {
        while (!this.queuedEvents.isEmpty() && this.firing.compareAndSet(false, true)) {
            try {
                E e;
                Throwable t = null;
                while ((e = this.queuedEvents.poll()) != null) {
                    try {
                        this.multicaster.broadcast(e);
                    }
                    catch (Throwable thrown) {
                        thrown = ExceptionUtils.reportOrReturn(thrown);
                        if (thrown == null || t != null) continue;
                        t = thrown;
                    }
                }
                if (t == null) continue;
                ExceptionUtils.reportOrRethrow(t);
            }
            finally {
                this.firing.set(false);
            }
        }
    }

    @Override
    public EventListenerList.EventListenerListContext getListenerContext() {
        return this.multicaster.getListenerContext();
    }
}

